/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.piecewise;

import it.geosolutions.jaiext.piecewise.DefaultDomainElement1D;
import it.geosolutions.jaiext.piecewise.DomainElement1D;
import it.geosolutions.jaiext.piecewise.MathTransformation;
import it.geosolutions.jaiext.piecewise.SingleDimensionTransformation;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.util.Arrays;

public class PiecewiseUtilities {
    private static final int PRIME_NUMBER = 37;

    private PiecewiseUtilities() {
    }

    public static void domainElementsOverlap(DomainElement1D[] domainElements, int idx) {
        Range range1 = domainElements[idx - 1].getRange();
        Range range2 = domainElements[idx].getRange();
        Number[] args = new Number[]{range1.getMin(), range1.getMax(), range2.getMin(), range2.getMax()};
        String[] results = new String[4];
        for (int j = 0; j < args.length; ++j) {
            double value = args[j].doubleValue();
            if (Double.isNaN(value)) {
                String hex = Long.toHexString(Double.doubleToRawLongBits(value));
                results[j] = "NaN(" + hex + ')';
                continue;
            }
            results[j] = value + "";
        }
        throw new IllegalArgumentException("Provided ranges are overlapping:" + results[0] + " : " + results[1] + " / " + results[2] + " : " + results[3]);
    }

    public static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Input object is null");
        }
    }

    public static int binarySearch(double[] array, double val) {
        int low = 0;
        int high = array.length - 1;
        boolean keyIsNaN = Double.isNaN(val);
        while (low <= high) {
            boolean adjustLow;
            long keyRawBits;
            int mid = low + high >> 1;
            double midVal = array[mid];
            if (midVal < val) {
                low = mid + 1;
                continue;
            }
            if (midVal > val) {
                high = mid - 1;
                continue;
            }
            long midRawBits = Double.doubleToRawLongBits(midVal);
            if (midRawBits == (keyRawBits = Double.doubleToRawLongBits(val))) {
                return mid;
            }
            boolean midIsNaN = Double.isNaN(midVal);
            if (keyIsNaN) {
                adjustLow = !midIsNaN || midRawBits < keyRawBits;
            } else {
                boolean bl = adjustLow = !midIsNaN && midRawBits < keyRawBits;
            }
            if (adjustLow) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low + 1);
    }

    public static int compare(double v1, double v2) {
        if (Double.isNaN(v1) && Double.isNaN(v2)) {
            long bits2;
            long bits1 = Double.doubleToRawLongBits(v1);
            if (bits1 < (bits2 = Double.doubleToRawLongBits(v2))) {
                return -1;
            }
            if (bits1 > bits2) {
                return 1;
            }
        }
        return Double.compare(v1, v2);
    }

    public static boolean isSorted(DefaultDomainElement1D[] domains) {
        if (domains == null) {
            return true;
        }
        for (int i = 1; i < domains.length; ++i) {
            DefaultDomainElement1D d1 = domains[i];
            assert (!(d1.getInputMinimum() > d1.getInputMaximum())) : d1;
            DefaultDomainElement1D d0 = domains[i - 1];
            assert (!(d0.getInputMinimum() > d0.getInputMaximum())) : d0;
            if (PiecewiseUtilities.compare(d0.getInputMaximum(), d1.getInputMinimum()) <= 0) continue;
            return false;
        }
        return true;
    }

    public static double doubleValue(Class<? extends Number> type, Number number, int direction) {
        assert (direction >= -1 && direction <= 1) : direction;
        return ImageUtilities.rool(type, number.doubleValue(), direction);
    }

    public static MathTransformation createLinearTransform1D(double scale, double offset) {
        return SingleDimensionTransformation.create(scale, offset);
    }

    public static MathTransformation createLinearTransform1D(Range sourceRange, Range destinationRange) {
        double maxDestination;
        Class<? extends Number> sType = sourceRange.getDataType().getClassValue();
        Class<? extends Number> dType = destinationRange.getDataType().getClassValue();
        int sMinInc = sourceRange.isMinIncluded() ? 0 : 1;
        int sMaxInc = sourceRange.isMaxIncluded() ? 0 : -1;
        int dMinInc = destinationRange.isMinIncluded() ? 0 : 1;
        int dMaxInc = destinationRange.isMaxIncluded() ? 0 : -1;
        double minSource = PiecewiseUtilities.doubleValue(sType, sourceRange.getMin(), sMinInc);
        double maxSource = PiecewiseUtilities.doubleValue(sType, sourceRange.getMax(), sMaxInc);
        double minDestination = PiecewiseUtilities.doubleValue(dType, destinationRange.getMin(), dMinInc);
        if (PiecewiseUtilities.compare(minDestination, maxDestination = PiecewiseUtilities.doubleValue(dType, destinationRange.getMax(), dMaxInc)) == 0) {
            return SingleDimensionTransformation.create(0.0, minDestination);
        }
        if (PiecewiseUtilities.compare(minSource, maxSource) == 0) {
            throw new IllegalArgumentException("Impossible to map a single value to a range.");
        }
        double scale = (maxDestination - minDestination) / (maxSource - minSource);
        if (Double.isNaN(scale)) {
            scale = 0.0;
        }
        double offset = minDestination - scale * minSource;
        return PiecewiseUtilities.createLinearTransform1D(scale, offset);
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (object instanceof double[]) {
            return Arrays.hashCode((double[])object);
        }
        if (object instanceof float[]) {
            return Arrays.hashCode((float[])object);
        }
        if (object instanceof long[]) {
            return Arrays.hashCode((long[])object);
        }
        if (object instanceof int[]) {
            return Arrays.hashCode((int[])object);
        }
        if (object instanceof short[]) {
            return Arrays.hashCode((short[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.hashCode((byte[])object);
        }
        if (object instanceof char[]) {
            return Arrays.hashCode((char[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.hashCode((boolean[])object);
        }
        return object.hashCode();
    }

    public static int hash(Object value, int seed) throws AssertionError {
        seed *= 37;
        if (value != null) {
            assert (!value.getClass().isArray()) : value;
            seed += value.hashCode();
        }
        return seed;
    }

    public static int hash(double value, int seed) {
        return PiecewiseUtilities.hash(Double.doubleToLongBits(value), seed);
    }

    public static int hash(long value, int seed) {
        return seed * 37 + ((int)value ^ (int)(value >>> 32));
    }

    public static boolean equals(double o1, double o2) {
        if (Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2)) {
            return true;
        }
        double tol = PiecewiseUtilities.getTolerance();
        double min2 = o1 - Math.signum(o1) * o1 * tol;
        double max = o1 + Math.signum(o1) * o1 * tol;
        return min2 <= o2 && o2 <= max;
    }

    public static boolean equals(Object object1, Object object2) {
        assert (object1 == null || !object1.getClass().isArray()) : object1;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    private static double getTolerance() {
        Double tol = Double.parseDouble(System.getProperty("jaiext.piecewise.tolerance"));
        if (tol == null) {
            return 0.0;
        }
        return tol;
    }

    public static boolean equals(Range outputRange, Range outputRange2) {
        return outputRange.equals(outputRange2);
    }
}

