/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriteParamJava;
import java.awt.Point;
import jj2000.j2k.IntegerSpec;
import jj2000.j2k.entropy.CBlkSizeSpec;
import jj2000.j2k.entropy.PrecinctSizeSpec;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ForwWTFull
extends ForwardWT {
    private boolean intData;
    private SubbandAn[][] subbTrees;
    private BlkImgDataSrc src;
    private int cb0x;
    private int cb0y;
    private IntegerSpec dls;
    private AnWTFilterSpec filters;
    private CBlkSizeSpec cblks;
    private PrecinctSizeSpec pss;
    private DataBlk[] decomposedComps;
    private int[] lastn;
    private int[] lastm;
    SubbandAn[] currentSubband;
    Point ncblks;

    public ForwWTFull(BlkImgDataSrc src, J2KImageWriteParamJava wp, int pox, int poy) {
        super(src);
        this.src = src;
        this.cb0x = this.cb0x;
        this.cb0y = this.cb0y;
        this.dls = wp.getDecompositionLevel();
        this.filters = wp.getFilters();
        this.cblks = wp.getCodeBlockSize();
        this.pss = wp.getPrecinctPartition();
        int ncomp = src.getNumComps();
        int ntiles = src.getNumTiles();
        this.currentSubband = new SubbandAn[ncomp];
        this.decomposedComps = new DataBlk[ncomp];
        this.subbTrees = new SubbandAn[ntiles][ncomp];
        this.lastn = new int[ncomp];
        this.lastm = new int[ncomp];
    }

    public int getImplementationType(int c2) {
        return 2;
    }

    public int getDecompLevels(int t, int c2) {
        return (Integer)this.dls.getTileCompVal(t, c2);
    }

    public int getDecomp(int t, int c2) {
        return 0;
    }

    public AnWTFilter[] getHorAnWaveletFilters(int t, int c2) {
        return this.filters.getHFilters(t, c2);
    }

    public AnWTFilter[] getVertAnWaveletFilters(int t, int c2) {
        return this.filters.getVFilters(t, c2);
    }

    public boolean isReversible(int t, int c2) {
        return this.filters.isReversible(t, c2);
    }

    public int getCbULX() {
        return this.cb0x;
    }

    public int getCbULY() {
        return this.cb0y;
    }

    public int getFixedPoint(int c2) {
        return this.src.getFixedPoint(c2);
    }

    public CBlkWTData getNextInternCodeBlock(int c2, CBlkWTData cblk) {
        block13: {
            boolean bl = this.intData = this.filters.getWTDataType(this.tIdx, c2) == 3;
            if (this.decomposedComps[c2] == null) {
                int lstart;
                DataBlk bufblk;
                int w = this.getTileCompWidth(this.tIdx, c2);
                int h2 = this.getTileCompHeight(this.tIdx, c2);
                if (this.intData) {
                    this.decomposedComps[c2] = new DataBlkInt(0, 0, w, h2);
                    bufblk = new DataBlkInt();
                } else {
                    this.decomposedComps[c2] = new DataBlkFloat(0, 0, w, h2);
                    bufblk = new DataBlkFloat();
                }
                Object dst_data = this.decomposedComps[c2].getData();
                bufblk.ulx = lstart = this.getCompULX(c2);
                bufblk.w = w;
                bufblk.h = 1;
                int kk = this.getCompULY(c2);
                for (int k = 0; k < h2; ++k) {
                    bufblk.uly = kk++;
                    bufblk.ulx = lstart;
                    bufblk = this.src.getInternCompData(bufblk, c2);
                    System.arraycopy(bufblk.getData(), bufblk.offset, dst_data, k * w, w);
                }
                this.waveletTreeDecomposition(this.decomposedComps[c2], this.getAnSubbandTree(this.tIdx, c2), c2);
                this.currentSubband[c2] = this.getNextSubband(c2);
                this.lastn[c2] = -1;
                this.lastm[c2] = 0;
            }
            do {
                this.ncblks = this.currentSubband[c2].numCb;
                int n = c2;
                this.lastn[n] = this.lastn[n] + 1;
                if (this.lastn[c2] == this.ncblks.x) {
                    this.lastn[c2] = 0;
                    int n2 = c2;
                    this.lastm[n2] = this.lastm[n2] + 1;
                }
                if (this.lastm[c2] < this.ncblks.y) break block13;
                this.currentSubband[c2] = this.getNextSubband(c2);
                this.lastn[c2] = -1;
                this.lastm[c2] = 0;
            } while (this.currentSubband[c2] != null);
            this.decomposedComps[c2] = null;
            return null;
        }
        int acb0x = this.cb0x;
        int acb0y = this.cb0y;
        switch (this.currentSubband[c2].sbandIdx) {
            case 0: {
                break;
            }
            case 1: {
                acb0x = 0;
                break;
            }
            case 2: {
                acb0y = 0;
                break;
            }
            case 3: {
                acb0x = 0;
                acb0y = 0;
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        if (cblk == null) {
            cblk = this.intData ? new CBlkWTDataInt() : new CBlkWTDataFloat();
        }
        int cbn = this.lastn[c2];
        int cbm = this.lastm[c2];
        SubbandAn sb = this.currentSubband[c2];
        cblk.n = cbn;
        cblk.m = cbm;
        cblk.sb = sb;
        int cn = (sb.ulcx - acb0x + sb.nomCBlkW) / sb.nomCBlkW - 1;
        int cm = (sb.ulcy - acb0y + sb.nomCBlkH) / sb.nomCBlkH - 1;
        cblk.ulx = cbn == 0 ? sb.ulx : (cn + cbn) * sb.nomCBlkW - (sb.ulcx - acb0x) + sb.ulx;
        cblk.uly = cbm == 0 ? sb.uly : (cm + cbm) * sb.nomCBlkH - (sb.ulcy - acb0y) + sb.uly;
        cblk.w = cbn < this.ncblks.x - 1 ? (cn + cbn + 1) * sb.nomCBlkW - (sb.ulcx - acb0x) + sb.ulx - cblk.ulx : sb.ulx + sb.w - cblk.ulx;
        cblk.h = cbm < this.ncblks.y - 1 ? (cm + cbm + 1) * sb.nomCBlkH - (sb.ulcy - acb0y) + sb.uly - cblk.uly : sb.uly + sb.h - cblk.uly;
        cblk.wmseScaling = 1.0f;
        cblk.offset = cblk.uly * this.decomposedComps[c2].w + cblk.ulx;
        cblk.scanw = this.decomposedComps[c2].w;
        cblk.setData(this.decomposedComps[c2].getData());
        return cblk;
    }

    public CBlkWTData getNextCodeBlock(int c2, CBlkWTData cblk) {
        this.intData = this.filters.getWTDataType(this.tIdx, c2) == 3;
        Object dst_data = null;
        if (cblk != null) {
            dst_data = cblk.getData();
        }
        if ((cblk = this.getNextInternCodeBlock(c2, cblk)) == null) {
            return null;
        }
        if (this.intData) {
            int[] dst_data_int = (int[])dst_data;
            if (dst_data_int == null || dst_data_int.length < cblk.w * cblk.h) {
                dst_data = new int[cblk.w * cblk.h];
            }
        } else {
            float[] dst_data_float = (float[])dst_data;
            if (dst_data_float == null || dst_data_float.length < cblk.w * cblk.h) {
                dst_data = new float[cblk.w * cblk.h];
            }
        }
        Object src_data = cblk.getData();
        int w = cblk.w;
        int j = w * (cblk.h - 1);
        int k = cblk.offset + (cblk.h - 1) * cblk.scanw;
        while (j >= 0) {
            System.arraycopy(src_data, k, dst_data, j, w);
            j -= w;
            k -= cblk.scanw;
        }
        cblk.setData(dst_data);
        cblk.offset = 0;
        cblk.scanw = w;
        return cblk;
    }

    public int getDataType(int t, int c2) {
        return this.filters.getWTDataType(t, c2);
    }

    private SubbandAn getNextSubband(int c2) {
        boolean down = true;
        boolean up = false;
        boolean direction = down;
        SubbandAn nextsb = this.currentSubband[c2];
        if (nextsb == null) {
            nextsb = this.getAnSubbandTree(this.tIdx, c2);
            if (!nextsb.isNode) {
                return nextsb;
            }
        }
        while (nextsb != null) {
            if (!nextsb.isNode) {
                switch (nextsb.orientation) {
                    case 3: {
                        nextsb = (SubbandAn)nextsb.getParent().getLH();
                        direction = down;
                        break;
                    }
                    case 2: {
                        nextsb = (SubbandAn)nextsb.getParent().getHL();
                        direction = down;
                        break;
                    }
                    case 1: {
                        nextsb = (SubbandAn)nextsb.getParent().getLL();
                        direction = down;
                        break;
                    }
                    case 0: {
                        nextsb = (SubbandAn)nextsb.getParent();
                        direction = up;
                    }
                }
            } else if (nextsb.isNode) {
                if (direction == down) {
                    nextsb = (SubbandAn)nextsb.getHH();
                } else if (direction == up) {
                    switch (nextsb.orientation) {
                        case 3: {
                            nextsb = (SubbandAn)nextsb.getParent().getLH();
                            direction = down;
                            break;
                        }
                        case 2: {
                            nextsb = (SubbandAn)nextsb.getParent().getHL();
                            direction = down;
                            break;
                        }
                        case 1: {
                            nextsb = (SubbandAn)nextsb.getParent().getLL();
                            direction = down;
                            break;
                        }
                        case 0: {
                            nextsb = (SubbandAn)nextsb.getParent();
                            direction = up;
                        }
                    }
                }
            }
            if (nextsb != null && nextsb.isNode) continue;
        }
        return nextsb;
    }

    private void waveletTreeDecomposition(DataBlk band, SubbandAn subband, int c2) {
        if (!subband.isNode) {
            return;
        }
        this.wavelet2DDecomposition(band, subband, c2);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getHH(), c2);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getLH(), c2);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getHL(), c2);
        this.waveletTreeDecomposition(band, (SubbandAn)subband.getLL(), c2);
    }

    private void wavelet2DDecomposition(DataBlk band, SubbandAn subband, int c2) {
        if (subband.w == 0 || subband.h == 0) {
            return;
        }
        int ulx = subband.ulx;
        int uly = subband.uly;
        int w = subband.w;
        int h2 = subband.h;
        int band_w = this.getTileCompWidth(this.tIdx, c2);
        int band_h = this.getTileCompHeight(this.tIdx, c2);
        if (this.intData) {
            int i;
            int offset;
            int j;
            int[] tmpVector = new int[Math.max(w, h2)];
            int[] data = ((DataBlkInt)band).getDataInt();
            if (subband.ulcy % 2 == 0) {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h2; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_lpf(tmpVector, 0, h2, 1, data, offset, band_w, data, offset + (h2 + 1) / 2 * band_w, band_w);
                }
            } else {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h2; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_hpf(tmpVector, 0, h2, 1, data, offset, band_w, data, offset + h2 / 2 * band_w, band_w);
                }
            }
            if (subband.ulcx % 2 == 0) {
                for (i = 0; i < h2; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
                }
            } else {
                for (i = 0; i < h2; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
                }
            }
        } else {
            int i;
            int offset;
            int j;
            float[] tmpVector = new float[Math.max(w, h2)];
            float[] data = ((DataBlkFloat)band).getDataFloat();
            if (subband.ulcy % 2 == 0) {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h2; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_lpf(tmpVector, 0, h2, 1, data, offset, band_w, data, offset + (h2 + 1) / 2 * band_w, band_w);
                }
            } else {
                for (j = 0; j < w; ++j) {
                    offset = uly * band_w + ulx + j;
                    for (i = 0; i < h2; ++i) {
                        tmpVector[i] = data[offset + i * band_w];
                    }
                    subband.vFilter.analyze_hpf(tmpVector, 0, h2, 1, data, offset, band_w, data, offset + h2 / 2 * band_w, band_w);
                }
            }
            if (subband.ulcx % 2 == 0) {
                for (i = 0; i < h2; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_lpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + (w + 1) / 2, 1);
                }
            } else {
                for (i = 0; i < h2; ++i) {
                    offset = (uly + i) * band_w + ulx;
                    for (j = 0; j < w; ++j) {
                        tmpVector[j] = data[offset + j];
                    }
                    subband.hFilter.analyze_hpf(tmpVector, 0, w, 1, data, offset, 1, data, offset + w / 2, 1);
                }
            }
        }
    }

    public void setTile(int x, int y) {
        super.setTile(x, y);
        if (this.decomposedComps != null) {
            for (int i = this.decomposedComps.length - 1; i >= 0; --i) {
                this.decomposedComps[i] = null;
                this.currentSubband[i] = null;
            }
        }
    }

    public void nextTile() {
        super.nextTile();
        if (this.decomposedComps != null) {
            for (int i = this.decomposedComps.length - 1; i >= 0; --i) {
                this.decomposedComps[i] = null;
                this.currentSubband[i] = null;
            }
        }
    }

    public SubbandAn getAnSubbandTree(int t, int c2) {
        if (this.subbTrees[t][c2] == null) {
            this.subbTrees[t][c2] = new SubbandAn(this.getTileCompWidth(this.tIdx, c2), this.getTileCompHeight(this.tIdx, c2), this.getCompULX(c2), this.getCompULY(c2), this.getDecompLevels(t, c2), this.getHorAnWaveletFilters(t, c2), this.getVertAnWaveletFilters(t, c2));
            this.initSubbandsFields(t, c2, this.subbTrees[t][c2]);
        }
        return this.subbTrees[t][c2];
    }

    private void initSubbandsFields(int t, int c2, Subband sb) {
        int cbw = this.cblks.getCBlkWidth((byte)3, t, c2);
        int cbh = this.cblks.getCBlkHeight((byte)3, t, c2);
        if (!sb.isNode) {
            int ppx = this.pss.getPPX(t, c2, sb.resLvl);
            int ppy = this.pss.getPPY(t, c2, sb.resLvl);
            if (ppx != 65535 || ppy != 65535) {
                int ppxExp = MathUtil.log2(ppx);
                int ppyExp = MathUtil.log2(ppy);
                int cbwExp = MathUtil.log2(cbw);
                int cbhExp = MathUtil.log2(cbh);
                switch (sb.resLvl) {
                    case 0: {
                        sb.nomCBlkW = cbwExp < ppxExp ? 1 << cbwExp : 1 << ppxExp;
                        sb.nomCBlkH = cbhExp < ppyExp ? 1 << cbhExp : 1 << ppyExp;
                        break;
                    }
                    default: {
                        sb.nomCBlkW = cbwExp < ppxExp - 1 ? 1 << cbwExp : 1 << ppxExp - 1;
                        sb.nomCBlkH = cbhExp < ppyExp - 1 ? 1 << cbhExp : 1 << ppyExp - 1;
                        break;
                    }
                }
            } else {
                sb.nomCBlkW = cbw;
                sb.nomCBlkH = cbh;
            }
            if (sb.numCb == null) {
                sb.numCb = new Point();
            }
            if (sb.w != 0 && sb.h != 0) {
                int acb0x = this.cb0x;
                int acb0y = this.cb0y;
                switch (sb.sbandIdx) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        acb0x = 0;
                        break;
                    }
                    case 2: {
                        acb0y = 0;
                        break;
                    }
                    case 3: {
                        acb0x = 0;
                        acb0y = 0;
                        break;
                    }
                    default: {
                        throw new Error("Internal JJ2000 error");
                    }
                }
                if (sb.ulcx - acb0x < 0 || sb.ulcy - acb0y < 0) {
                    throw new IllegalArgumentException("Invalid code-blocks partition origin or image offset in the reference grid.");
                }
                int tmp = sb.ulcx - acb0x + sb.nomCBlkW;
                sb.numCb.x = (tmp + sb.w - 1) / sb.nomCBlkW - (tmp / sb.nomCBlkW - 1);
                tmp = sb.ulcy - acb0y + sb.nomCBlkH;
                sb.numCb.y = (tmp + sb.h - 1) / sb.nomCBlkH - (tmp / sb.nomCBlkH - 1);
            } else {
                sb.numCb.y = 0;
                sb.numCb.x = 0;
            }
        } else {
            this.initSubbandsFields(t, c2, sb.getLL());
            this.initSubbandsFields(t, c2, sb.getHL());
            this.initSubbandsFields(t, c2, sb.getLH());
            this.initSubbandsFields(t, c2, sb.getHH());
        }
    }
}

