/*
 * Decompiled with CFR 0.152.
 */
package net.sf.geographiclib;

import net.sf.geographiclib.GeoMath;
import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.GeodesicLine;
import net.sf.geographiclib.GnomonicData;
import net.sf.geographiclib.Pair;

public class Gnomonic {
    private static final double eps_ = 0.01 * Math.sqrt(GeoMath.epsilon);
    private static final int numit_ = 10;
    private Geodesic _earth;
    private double _a;
    private double _f;

    public Gnomonic(Geodesic earth) {
        this._earth = earth;
        this._a = this._earth.MajorRadius();
        this._f = this._earth.Flattening();
    }

    public GnomonicData Forward(double lat0, double lon0, double lat, double lon) {
        GeodesicData inv = this._earth.Inverse(lat0, lon0, lat, lon, 12805);
        GnomonicData fwd = new GnomonicData(lat0, lon0, lat, lon, Double.NaN, Double.NaN, inv.azi2, inv.M12);
        if (inv.M12 > 0.0) {
            double rho = inv.m12 / inv.M12;
            Pair p = GeoMath.sincosd(inv.azi1);
            fwd.x = rho * p.first;
            fwd.y = rho * p.second;
        }
        return fwd;
    }

    public GnomonicData Reverse(double lat0, double lon0, double x, double y) {
        boolean little;
        GnomonicData rev = new GnomonicData(lat0, lon0, Double.NaN, Double.NaN, x, y, Double.NaN, Double.NaN);
        double azi0 = GeoMath.atan2d(x, y);
        double rho = Math.hypot(x, y);
        double s2 = this._a * Math.atan(rho / this._a);
        boolean bl = little = rho <= this._a;
        if (!little) {
            rho = 1.0 / rho;
        }
        GeodesicLine line = this._earth.Line(lat0, lon0, azi0, 15247);
        int count = 10;
        int trip = 0;
        GeodesicData pos = null;
        while (count-- > 0) {
            pos = line.Position(s2, 15247);
            if (trip > 0) break;
            double ds = little ? (pos.m12 / pos.M12 - rho) * pos.M12 * pos.M12 : (rho - pos.M12 / pos.m12) * pos.m12 * pos.m12;
            s2 -= ds;
            if (!(Math.abs(ds) <= eps_ * this._a)) continue;
            ++trip;
        }
        if (trip == 0) {
            return rev;
        }
        rev.lat = pos.lat2;
        rev.lon = pos.lon2;
        rev.azi = pos.azi2;
        rev.rk = pos.M12;
        return rev;
    }

    public double MajorRadius() {
        return this._a;
    }

    public double Flattening() {
        return this._f;
    }
}

