/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.binPacking;

import java.util.BitSet;
import java.util.Comparator;
import java.util.stream.IntStream;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.procedure.UnaryIntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropBinPacking
extends Propagator<IntVar> {
    private final IntVar[] itemBin;
    protected int[] itemSize;
    protected IntVar[] binLoad;
    protected final int offset;
    private final int nbItems;
    private final int nbAvailableBins;
    protected IIntDeltaMonitor[] monitors;
    protected ISet[] P;
    protected ISet[] R;
    protected IStateInt[] sumR;
    private final IStateInt[] sumP;
    private final BitSet binsToProcess;
    private final boolean useNoSumFiltering;
    private int sumA;
    private int sumB;
    private int sumC;
    private int k;
    private int kPrime;
    private final int[] indexSortedBySize;
    private final int[] X;
    private int xSize;
    private final UnaryIntProcedure<Integer> procedure = new UnaryIntProcedure<Integer>(){
        int item;

        @Override
        public UnaryIntProcedure<Integer> set(Integer itemIdx) {
            this.item = itemIdx;
            return this;
        }

        @Override
        public void execute(int bin) throws ContradictionException {
            if ((bin -= PropBinPacking.this.offset) >= 0 && bin < PropBinPacking.this.nbAvailableBins && PropBinPacking.this.P[bin].contains(this.item)) {
                PropBinPacking.this.P[bin].remove(this.item);
                PropBinPacking.this.binLoad[bin].updateUpperBound(PropBinPacking.this.sumP[bin].add(-PropBinPacking.this.itemSize[this.item]), PropBinPacking.this);
            }
        }
    };

    public PropBinPacking(IntVar[] itemBin, int[] itemSize, IntVar[] binLoad, int offset) {
        this(itemBin, itemSize, binLoad, offset, true);
    }

    public PropBinPacking(IntVar[] itemBin, int[] itemSize, IntVar[] binLoad, int offset, boolean useNoSumFiltering) {
        super((Variable[])ArrayUtils.append(itemBin, binLoad), (Priority)PropagatorPriority.LINEAR, true);
        this.itemBin = itemBin;
        this.itemSize = itemSize;
        this.binLoad = binLoad;
        this.offset = offset;
        this.useNoSumFiltering = useNoSumFiltering;
        this.nbItems = itemBin.length;
        this.nbAvailableBins = binLoad.length;
        this.monitors = new IIntDeltaMonitor[this.nbItems];
        for (int i2 = 0; i2 < this.nbItems; ++i2) {
            this.monitors[i2] = itemBin[i2].monitorDelta(this);
        }
        this.P = new ISet[this.nbAvailableBins];
        this.R = new ISet[this.nbAvailableBins];
        this.sumR = new IStateInt[this.nbAvailableBins];
        this.sumP = new IStateInt[this.nbAvailableBins];
        for (int j = 0; j < this.nbAvailableBins; ++j) {
            this.P[j] = SetFactory.makeStoredSet(SetType.BITSET, 0, itemBin[0].getModel());
            this.R[j] = SetFactory.makeStoredSet(SetType.BITSET, 0, itemBin[0].getModel());
            int pj = 0;
            int rj = 0;
            for (int i3 = 0; i3 < this.nbItems; ++i3) {
                if (!itemBin[i3].contains(j + offset)) continue;
                this.P[j].add(i3);
                pj += itemSize[i3];
                if (!itemBin[i3].isInstantiated()) continue;
                this.R[j].add(i3);
                rj += itemSize[i3];
            }
            this.sumR[j] = itemBin[0].getModel().getEnvironment().makeInt(rj);
            this.sumP[j] = itemBin[0].getModel().getEnvironment().makeInt(pj);
        }
        this.binsToProcess = new BitSet(this.nbAvailableBins);
        this.X = new int[itemSize.length];
        this.indexSortedBySize = IntStream.range(0, itemSize.length).boxed().sorted(Comparator.comparingInt(i -> -itemSize[i])).mapToInt(i -> i).toArray();
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx < this.nbItems) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    private void removeItemFromBin(int binIdx, int itemIdx) throws ContradictionException {
        if (this.P[binIdx].contains(itemIdx)) {
            this.P[binIdx].remove(itemIdx);
            this.binLoad[binIdx].updateUpperBound(this.sumP[binIdx].add(-this.itemSize[itemIdx]), this);
            this.binsToProcess.set(binIdx);
            if (this.itemBin[itemIdx].isInstantiated()) {
                this.updateRAfterInstantiation(this.itemBin[itemIdx].getValue() - this.offset, itemIdx);
            }
        }
    }

    protected void updateRAfterInstantiation(int binIdx, int itemIdx) throws ContradictionException {
        if (this.R[binIdx].add(itemIdx)) {
            this.binLoad[binIdx].updateLowerBound(this.sumR[binIdx].add(this.itemSize[itemIdx]), this);
            this.binsToProcess.set(binIdx);
            for (int k = 0; k < this.nbAvailableBins; ++k) {
                if (k == binIdx || !this.P[k].remove(itemIdx)) continue;
                this.binLoad[k].updateUpperBound(this.sumP[k].add(-this.itemSize[itemIdx]), this);
                this.binsToProcess.set(k);
            }
        }
    }

    private boolean singleItemEliminationAndCommitment(int j) throws ContradictionException {
        boolean hasFiltered = false;
        ISetIterator iter = this.P[j].iterator();
        while (iter.hasNext()) {
            int i = iter.nextInt();
            if (!this.itemBin[i].contains(j + this.offset)) {
                this.removeItemFromBin(j, i);
                continue;
            }
            if (this.R[j].contains(i)) continue;
            if (this.sumP[j].get() - this.itemSize[i] < this.binLoad[j].getLB()) {
                hasFiltered |= this.itemBin[i].instantiateTo(j + this.offset, this);
                this.updateRAfterInstantiation(j, i);
                continue;
            }
            if (this.sumR[j].get() + this.itemSize[i] <= this.binLoad[j].getUB() || !this.itemBin[i].removeValue(j + this.offset, this)) continue;
            hasFiltered = true;
            this.removeItemFromBin(j, i);
        }
        return hasFiltered;
    }

    private void processBin(int j) throws ContradictionException {
        boolean hasFiltered;
        this.binsToProcess.clear(j);
        do {
            hasFiltered = this.singleItemEliminationAndCommitment(j);
            if (!this.useNoSumFiltering) continue;
            hasFiltered |= this.noSumFiltering(j);
        } while (hasFiltered);
    }

    private void fillXArrayWithCj(int j, int idxToRemove) {
        this.xSize = 0;
        for (int i = 0; i < this.nbItems; ++i) {
            if (this.indexSortedBySize[i] == idxToRemove || !this.P[j].contains(this.indexSortedBySize[i]) || this.R[j].contains(this.indexSortedBySize[i])) continue;
            this.X[this.xSize++] = this.indexSortedBySize[i];
        }
    }

    private void noSumInit() {
        this.sumA = 0;
        this.sumB = 0;
        this.sumC = 0;
        this.k = 0;
        this.kPrime = 0;
    }

    private boolean noSumComputings(int alpha, int beta) {
        while (this.kPrime < this.xSize && this.sumC + this.itemSize[this.X[this.xSize - 1 - this.kPrime]] < alpha) {
            this.sumC += this.itemSize[this.X[this.xSize - 1 - this.kPrime]];
            ++this.kPrime;
        }
        if (this.kPrime < this.xSize) {
            this.sumB = this.itemSize[this.X[this.xSize - 1 - this.kPrime]];
        }
        while (this.k < this.xSize && this.sumA < alpha && this.sumB <= beta) {
            this.sumA += this.itemSize[this.X[this.k]];
            ++this.k;
            if (this.sumA >= alpha) continue;
            --this.kPrime;
            this.sumB += this.itemSize[this.X[this.xSize - 1 - this.kPrime]];
            this.sumC -= this.itemSize[this.X[this.xSize - 1 - this.kPrime]];
            while (this.sumA + this.sumC >= alpha) {
                --this.kPrime;
                this.sumC -= this.itemSize[this.X[this.xSize - 1 - this.kPrime]];
                this.sumB += this.itemSize[this.X[this.xSize - 1 - this.kPrime]] - this.itemSize[this.X[this.xSize - 1 - this.kPrime - this.k - 1]];
            }
        }
        return this.sumA < alpha;
    }

    private boolean noSum(int j, int alpha, int beta) {
        return this.noSum(j, alpha, beta, -1);
    }

    private boolean noSum(int j, int alpha, int beta, int idxToRemove) {
        if (alpha <= 0 || beta >= this.sumP[j].get() - this.sumR[j].get()) {
            return false;
        }
        this.noSumInit();
        this.fillXArrayWithCj(j, idxToRemove);
        return this.noSumComputings(alpha, beta);
    }

    private boolean noSumFiltering(int j) throws ContradictionException {
        int ubVal;
        int lbVal;
        boolean hasFiltered = false;
        if (this.noSum(j, this.binLoad[j].getLB() - this.sumR[j].get(), this.binLoad[j].getUB() - this.sumR[j].get())) {
            this.fails();
        }
        if (this.noSum(j, lbVal = this.binLoad[j].getLB() - this.sumR[j].get(), lbVal)) {
            hasFiltered = true;
            this.binLoad[j].updateLowerBound(this.sumR[j].get() + this.sumB, this);
        }
        if (this.noSum(j, ubVal = this.binLoad[j].getUB() - this.sumR[j].get(), ubVal)) {
            this.binLoad[j].updateUpperBound(this.sumR[j].get() + this.sumA + this.sumC, this);
        }
        ISetIterator iter = this.P[j].iterator();
        while (iter.hasNext()) {
            int ubVal2;
            int i = iter.nextInt();
            if (this.R[j].contains(i)) continue;
            int lbVal2 = this.binLoad[j].getLB() - this.sumR[j].get() - this.itemSize[i];
            if (this.noSum(j, lbVal2, ubVal2 = this.binLoad[j].getUB() - this.sumR[j].get() - this.itemSize[i], i) && this.itemBin[i].removeValue(j + this.offset, this)) {
                hasFiltered = true;
                this.removeItemFromBin(j, i);
            }
            if (!this.noSum(j, lbVal2 += this.itemSize[i], ubVal2 += this.itemSize[i], i)) continue;
            hasFiltered |= this.itemBin[i].instantiateTo(j + this.offset, this);
            this.updateRAfterInstantiation(j, i);
        }
        return hasFiltered;
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (idxVarInProp < this.nbItems) {
            this.monitors[idxVarInProp].forEachRemVal(this.procedure.set(idxVarInProp));
            if (this.itemBin[idxVarInProp].isInstantiated()) {
                int j = this.itemBin[idxVarInProp].getValue() - this.offset;
                this.updateRAfterInstantiation(j, idxVarInProp);
                this.binsToProcess.set(j);
            }
        } else {
            this.binsToProcess.set(idxVarInProp - this.nbItems);
        }
        this.forcePropagate(PropagatorEventType.CUSTOM_PROPAGATION);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            int i;
            for (i = 0; i < this.itemBin.length; ++i) {
                int j;
                this.itemBin[i].updateBounds(this.offset, this.nbAvailableBins + this.offset - 1, this);
                if (this.itemBin[i].isInstantiated()) {
                    j = this.itemBin[i].getValue() - this.offset;
                    this.updateRAfterInstantiation(j, i);
                    continue;
                }
                for (j = 0; j < this.nbAvailableBins; ++j) {
                    if (this.itemBin[i].contains(j + this.offset)) continue;
                    this.removeItemFromBin(j, i);
                }
            }
            this.binsToProcess.set(0, this.nbAvailableBins);
            for (i = 0; i < this.nbItems; ++i) {
                this.monitors[i].startMonitoring();
            }
        }
        while (!this.binsToProcess.isEmpty()) {
            this.processBin(this.binsToProcess.nextSetBit(0));
        }
    }

    @Override
    public ESat isEntailed() {
        for (int i = 0; i < this.nbItems; ++i) {
            int val;
            if (!this.itemBin[i].isInstantiated() || (val = this.itemBin[i].getValue()) >= this.offset && val < this.nbAvailableBins + this.offset) continue;
            return ESat.FALSE;
        }
        for (int b2 = 0; b2 < this.nbAvailableBins; ++b2) {
            int min2 = 0;
            int max = 0;
            for (int i = 0; i < this.nbItems; ++i) {
                if (!this.itemBin[i].contains(b2 + this.offset)) continue;
                max += this.itemSize[i];
                if (!this.itemBin[i].isInstantiated()) continue;
                min2 += this.itemSize[i];
            }
            if (min2 <= this.binLoad[b2].getUB() && max >= this.binLoad[b2].getLB()) continue;
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

