/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.cumulative;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.cumulative.CumulFilter;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.PropagatorEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.chocosolver.util.objects.setDataStructures.SetType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropCumulative
extends Propagator<IntVar> {
    protected final int n;
    protected final IntVar[] s;
    protected final IntVar[] d;
    protected final IntVar[] e;
    protected final IntVar[] h;
    protected final IntVar capa;
    protected CumulFilter[] filters;
    protected ISet allTasks;
    protected final IStateInt lastCapaMax;

    protected PropCumulative(IntVar[] s2, IntVar[] d2, IntVar[] e2, IntVar[] h2, IntVar capa, boolean reactToFineEvt, CumulFilter ... filters) {
        super((Variable[])ArrayUtils.append(s2, d2, e2, h2, {capa}), (Priority)PropagatorPriority.QUADRATIC, reactToFineEvt);
        this.n = s2.length;
        if (this.n != d2.length || this.n != e2.length || this.n != h2.length) {
            throw new UnsupportedOperationException();
        }
        this.s = Arrays.copyOfRange((IntVar[])this.vars, 0, this.n);
        this.d = Arrays.copyOfRange((IntVar[])this.vars, this.n, this.n * 2);
        this.e = Arrays.copyOfRange((IntVar[])this.vars, this.n * 2, this.n * 3);
        this.h = Arrays.copyOfRange((IntVar[])this.vars, this.n * 3, this.n * 4);
        this.capa = ((IntVar[])this.vars)[4 * this.n];
        this.filters = filters;
        this.lastCapaMax = this.model.getEnvironment().makeInt(capa.getUB() + 1);
        this.allTasks = SetFactory.makeStoredSet(SetType.BIPARTITESET, 0, this.getModel());
        for (int t = 0; t < this.n; ++t) {
            this.allTasks.add(t);
        }
    }

    public PropCumulative(IntVar[] s2, IntVar[] d2, IntVar[] e2, IntVar[] h2, IntVar capa, CumulFilter ... filters) {
        this(s2, d2, e2, h2, capa, false, filters);
    }

    @Override
    public int getPropagationConditions(int idx) {
        if (idx == ((IntVar[])this.vars).length - 1) {
            return IntEventType.combine(IntEventType.INSTANTIATE, IntEventType.DECUPP);
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (PropagatorEventType.isFullPropagation(evtmask)) {
            this.propIni();
        }
        this.updateMaxCapa();
        this.filter(this.allTasks);
    }

    protected void propIni() throws ContradictionException {
        for (int i = 0; i < this.n; ++i) {
            this.d[i].updateLowerBound(0, this);
            this.h[i].updateLowerBound(0, this);
            this.s[i].updateBounds(this.e[i].getLB() - this.d[i].getUB(), this.e[i].getUB() - this.d[i].getLB(), this);
            this.e[i].updateBounds(this.s[i].getLB() + this.d[i].getLB(), this.s[i].getUB() + this.d[i].getUB(), this);
            this.d[i].updateBounds(this.e[i].getLB() - this.s[i].getUB(), this.e[i].getUB() - this.s[i].getLB(), this);
        }
    }

    protected void updateMaxCapa() throws ContradictionException {
        if (this.lastCapaMax.get() != this.capa.getUB()) {
            int capaMax = this.capa.getUB();
            this.lastCapaMax.set(capaMax);
            for (int i = 0; i < this.n; ++i) {
                if (this.d[i].getLB() > 0) {
                    this.h[i].updateUpperBound(capaMax, this);
                    continue;
                }
                if (this.h[i].getLB() <= capaMax) continue;
                this.d[i].instantiateTo(0, this);
            }
        }
    }

    public void filter(ISet tasks) throws ContradictionException {
        ISetIterator tIter = tasks.iterator();
        while (tIter.hasNext()) {
            int t = tIter.nextInt();
            if (this.h[t].getUB() != 0 && this.d[t].getUB() != 0) continue;
            tasks.remove(t);
        }
        for (CumulFilter cf : this.filters) {
            cf.filter(this.s, this.d, this.e, this.h, this.capa, tasks, this);
        }
    }

    @Override
    public ESat isEntailed() {
        int min2 = this.s[0].getUB();
        int max = this.e[0].getLB();
        for (int i = 0; i < this.n; ++i) {
            min2 = Math.min(min2, this.s[i].getUB());
            max = Math.max(max, this.e[i].getLB());
            if (this.s[i].getLB() + this.d[i].getLB() <= this.e[i].getUB() && this.s[i].getUB() + this.d[i].getUB() >= this.e[i].getLB()) continue;
            return ESat.FALSE;
        }
        int maxLoad = 0;
        if (min2 <= max) {
            int capamax = this.capa.getUB();
            int[] consoMin = new int[max - min2];
            for (int i = 0; i < this.n; ++i) {
                for (int t = this.s[i].getUB(); t < this.e[i].getLB(); ++t) {
                    int n = t - min2;
                    consoMin[n] = consoMin[n] + this.h[i].getLB();
                    if (consoMin[t - min2] > capamax) {
                        return ESat.FALSE;
                    }
                    maxLoad = Math.max(maxLoad, consoMin[t - min2]);
                }
            }
        }
        for (int i = 0; i < ((IntVar[])this.vars).length - 1; ++i) {
            if (((IntVar[])this.vars)[i].isInstantiated()) continue;
            return ESat.UNDEFINED;
        }
        assert (min2 <= max);
        if (maxLoad <= ((IntVar[])this.vars)[4 * this.n].getLB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + "(");
        for (int i = 0; i < this.n; ++i) {
            sb.append("[").append(((IntVar[])this.vars)[i].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 2 * this.n].toString());
            sb.append(",").append(((IntVar[])this.vars)[i + 3 * this.n].toString()).append("],");
        }
        sb.append(((IntVar[])this.vars)[4 * this.n].toString()).append(")");
        return sb.toString();
    }

    private int getInd(IntVar pivot) {
        int ind = -1;
        for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
            if (((IntVar[])this.vars)[i] != pivot) continue;
            ind = i;
        }
        if (ind == -1) {
            throw new UnsupportedOperationException("Unfindable pivot variable ");
        }
        return ind;
    }

    private boolean explainOverlap(ExplanationForSignedClause e2, int[] indexes, int t, int[] indD) {
        boolean flag = false;
        for (int i : indexes) {
            if (e2.domain(((IntVar[])this.vars)[i]).max() >= t || e2.domain(((IntVar[])this.vars)[i]).min() < t - e2.domain(((IntVar[])this.vars)[indD[i]]).min()) continue;
            ((IntVar[])this.vars)[i].unionLit(t, 0x3FFFFFFF, e2);
            ((IntVar[])this.vars)[i].unionLit(-1073741823, t - 1 - e2.domain(((IntVar[])this.vars)[indD[i]]).min(), e2);
            flag = true;
        }
        return flag;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause e2) {
        IntVar pivot = e2.readVar(p);
        int[] X2 = IntStream.range(0, this.n).filter((int i) -> ((IntVar[])this.vars)[i] != pivot).toArray();
        int[] indD = IntStream.range(this.n, this.n * 2).toArray();
        int t = e2.readValue(p);
        int ipivot = this.getInd(pivot);
        int dpivot = e2.domain(((IntVar[])this.vars)[ipivot + this.n]).min();
        if (ipivot >= this.n) {
            throw new UnsupportedOperationException("Try to explain an event not on a start variable");
        }
        switch (e2.readMask(p)) {
            case 2: {
                if (this.explainOverlap(e2, X2, t, indD)) {
                    IntIterableRangeSet set = e2.empty();
                    set.addBetween(t - dpivot, t - 1);
                    pivot.intersectLit(set.flip(), e2);
                    break;
                }
                throw new UnsupportedOperationException("Unable to find overlapping tasks");
            }
            case 4: {
                if (this.explainOverlap(e2, X2, ++t + dpivot, indD)) {
                    IntIterableRangeSet set = e2.empty();
                    set.addBetween(t, t - 1 + dpivot);
                    pivot.intersectLit(set.flip(), e2);
                    break;
                }
                throw new UnsupportedOperationException("Unable to find overlapping tasks");
            }
            default: {
                throw new UnsupportedOperationException("Unknown event type explanation");
            }
        }
    }
}

