/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.ternary;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class PropXplusYeqZ
extends Propagator<IntVar> {
    private static final int THRESHOLD = 300;
    private final int x = 0;
    private final int y = 1;
    private final int z = 2;
    private final boolean allbounded;
    private final IntIterableRangeSet set;

    public PropXplusYeqZ(IntVar X2, IntVar Y, IntVar Z) {
        super((Variable[])new IntVar[]{X2, Y, Z}, (Priority)PropagatorPriority.TERNARY, false);
        this.allbounded = !X2.hasEnumeratedDomain() & !Y.hasEnumeratedDomain() & !Z.hasEnumeratedDomain();
        this.set = new IntIterableRangeSet();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        do {
            boolean loop = this.filterPlus(2, 0, 1);
            loop |= this.filterMinus(0, 2, 1);
            loop |= this.filterMinus(1, 2, 0);
        } while (loop &= this.allbounded);
    }

    private boolean filterPlus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() + ((IntVar[])this.vars)[v2].getLB();
        int ub = ((IntVar[])this.vars)[v1].getUB() + ((IntVar[])this.vars)[v2].getUB();
        boolean change = ((IntVar[])this.vars)[vr].updateBounds(lb, ub, this);
        if (((IntVar[])this.vars)[v1].getDomainSize() * ((IntVar[])this.vars)[v2].getDomainSize() > 300) {
            return change;
        }
        if (!this.allbounded) {
            this.set.clear();
            int ub1 = ((IntVar[])this.vars)[v1].getUB();
            int ub2 = ((IntVar[])this.vars)[v2].getUB();
            int l1 = ((IntVar[])this.vars)[v1].getLB();
            int u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            while (u1 <= ub1) {
                int l2 = ((IntVar[])this.vars)[v2].getLB();
                int u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                while (u2 <= ub2) {
                    this.set.addBetween(l1 + l2, u1 + u2);
                    l2 = ((IntVar[])this.vars)[v2].nextValue(u2);
                    u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                }
                l1 = ((IntVar[])this.vars)[v1].nextValue(u1);
                u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            }
            change |= ((IntVar[])this.vars)[vr].removeAllValuesBut(this.set, this);
        }
        return change;
    }

    private boolean filterMinus(int vr, int v1, int v2) throws ContradictionException {
        int lb = ((IntVar[])this.vars)[v1].getLB() - ((IntVar[])this.vars)[v2].getUB();
        int ub = ((IntVar[])this.vars)[v1].getUB() - ((IntVar[])this.vars)[v2].getLB();
        boolean change = ((IntVar[])this.vars)[vr].updateBounds(lb, ub, this);
        if (((IntVar[])this.vars)[v1].getDomainSize() * ((IntVar[])this.vars)[v2].getDomainSize() > 300) {
            return change;
        }
        if (!this.allbounded) {
            this.set.clear();
            int ub1 = ((IntVar[])this.vars)[v1].getUB();
            int ub2 = ((IntVar[])this.vars)[v2].getUB();
            int l1 = ((IntVar[])this.vars)[v1].getLB();
            int u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            while (u1 <= ub1) {
                int l2 = ((IntVar[])this.vars)[v2].getLB();
                int u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                while (u2 <= ub2) {
                    this.set.addBetween(l1 - u2, u1 - l2);
                    l2 = ((IntVar[])this.vars)[v2].nextValue(u2);
                    u2 = ((IntVar[])this.vars)[v2].nextValueOut(l2) - 1;
                }
                l1 = ((IntVar[])this.vars)[v1].nextValue(u1);
                u1 = ((IntVar[])this.vars)[v1].nextValueOut(l1) - 1;
            }
            change |= ((IntVar[])this.vars)[vr].removeAllValuesBut(this.set, this);
        }
        return change;
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            return ESat.eval(((IntVar[])this.vars)[0].getValue() + ((IntVar[])this.vars)[1].getValue() == ((IntVar[])this.vars)[2].getValue());
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        int m3 = explanation.readMask(p);
        IntVar pivot = explanation.readVar(p);
        if (IntEventType.isInclow(m3)) {
            if (pivot == ((IntVar[])this.vars)[2]) {
                int a2 = explanation.readDom(((IntVar[])this.vars)[0]).min();
                int b2 = explanation.readDom(((IntVar[])this.vars)[1]).min();
                IntIterableRangeSet dx = explanation.universe();
                dx.removeBetween(a2, 0x3FFFFFFF);
                IntIterableRangeSet dy = explanation.universe();
                dy.removeBetween(b2, 0x3FFFFFFF);
                ((IntVar[])this.vars)[0].unionLit(dx, explanation);
                ((IntVar[])this.vars)[1].unionLit(dy, explanation);
                ((IntVar[])this.vars)[2].intersectLit(a2 + b2, 0x3FFFFFFF, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                int a3 = explanation.readDom(((IntVar[])this.vars)[1]).max();
                int b3 = explanation.readDom(((IntVar[])this.vars)[2]).min();
                IntIterableRangeSet dy = explanation.universe();
                dy.removeBetween(-1073741823, a3);
                IntIterableRangeSet dz = explanation.universe();
                dz.removeBetween(b3, 0x3FFFFFFF);
                ((IntVar[])this.vars)[0].intersectLit(b3 - a3, 0x3FFFFFFF, explanation);
                ((IntVar[])this.vars)[1].unionLit(dy, explanation);
                ((IntVar[])this.vars)[2].unionLit(dz, explanation);
            } else {
                int a4 = explanation.readDom(((IntVar[])this.vars)[0]).max();
                int b4 = explanation.readDom(((IntVar[])this.vars)[2]).min();
                IntIterableRangeSet dx = explanation.universe();
                dx.removeBetween(-1073741823, a4);
                IntIterableRangeSet dz = explanation.universe();
                dz.removeBetween(b4, 0x3FFFFFFF);
                ((IntVar[])this.vars)[0].unionLit(dx, explanation);
                ((IntVar[])this.vars)[1].intersectLit(b4 - a4, 0x3FFFFFFF, explanation);
                ((IntVar[])this.vars)[2].unionLit(dz, explanation);
            }
        } else if (IntEventType.isDecupp(m3)) {
            if (pivot == ((IntVar[])this.vars)[2]) {
                int a5 = explanation.readDom(((IntVar[])this.vars)[0]).max();
                int b5 = explanation.readDom(((IntVar[])this.vars)[1]).max();
                IntIterableRangeSet dx = explanation.universe();
                dx.removeBetween(-1073741823, a5);
                IntIterableRangeSet dy = explanation.universe();
                dy.removeBetween(-1073741823, b5);
                ((IntVar[])this.vars)[0].unionLit(dx, explanation);
                ((IntVar[])this.vars)[1].unionLit(dy, explanation);
                ((IntVar[])this.vars)[2].intersectLit(-1073741823, a5 + b5, explanation);
            } else if (pivot == ((IntVar[])this.vars)[0]) {
                int a6 = explanation.readDom(((IntVar[])this.vars)[1]).min();
                int b6 = explanation.readDom(((IntVar[])this.vars)[2]).max();
                IntIterableRangeSet dy = explanation.universe();
                dy.removeBetween(a6, 0x3FFFFFFF);
                IntIterableRangeSet dz = explanation.universe();
                dz.removeBetween(-1073741823, b6);
                ((IntVar[])this.vars)[0].intersectLit(-1073741823, b6 - a6, explanation);
                ((IntVar[])this.vars)[1].unionLit(dy, explanation);
                ((IntVar[])this.vars)[2].unionLit(dz, explanation);
            } else {
                int a7 = explanation.readDom(((IntVar[])this.vars)[0]).min();
                int b7 = explanation.readDom(((IntVar[])this.vars)[2]).max();
                IntIterableRangeSet dx = explanation.universe();
                dx.removeBetween(a7, 0x3FFFFFFF);
                IntIterableRangeSet dz = explanation.universe();
                dz.removeBetween(-1073741823, b7);
                ((IntVar[])this.vars)[0].unionLit(dx, explanation);
                ((IntVar[])this.vars)[1].intersectLit(-1073741823, b7 - a7, explanation);
                ((IntVar[])this.vars)[2].unionLit(dz, explanation);
            }
        } else {
            assert (IntEventType.isRemove(m3));
            Propagator.defaultExplain(this, p, explanation);
        }
    }
}

