/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import java.util.function.Consumer;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.variables.IntVar;

public abstract class IntNeighbor
implements INeighbor {
    protected final IntVar[] variables;
    protected final int[] values;

    protected IntNeighbor(IntVar[] variables) {
        this.variables = variables;
        this.values = new int[variables.length];
    }

    @Override
    public void recordSolution() {
        for (int i = 0; i < this.variables.length; ++i) {
            this.values[i] = this.variables[i].getValue();
        }
    }

    public void freeze(int i) throws ContradictionException {
        this.variables[i].instantiateTo(this.values[i], this);
    }

    @Override
    public void loadFromSolution(Solution solution) {
        for (int i = 0; i < this.variables.length; ++i) {
            this.values[i] = solution.getIntVal(this.variables[i]);
        }
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
        for (int i = 0; i < this.variables.length; ++i) {
            action.accept(this.variables[i]);
        }
    }
}

