/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.DecisionMaker;
import org.chocosolver.solver.search.strategy.decision.RootDecision;

public class DecisionPath
extends DecisionMaker
implements Serializable {
    private final List<Decision> decisions = new ArrayList<Decision>();
    IStateInt last;

    public DecisionPath(IEnvironment environment) {
        this.decisions.add(RootDecision.ROOT);
        this.last = environment.makeInt(1);
    }

    public void buildNext() {
        int p = this.last.get();
        if (p == this.decisions.size() - 1) {
            this.decisions.get(p).buildNext();
        }
    }

    public void apply() throws ContradictionException {
        int p = this.last.get();
        if (p == this.decisions.size() - 1) {
            this.decisions.get(p).apply();
            this.last.add(1);
        }
    }

    public void pushDecision(Decision decision) {
        int p = this.last.get();
        decision.setPosition(p);
        if (this.decisions.size() == p) {
            this.decisions.add(decision);
        } else if (this.decisions.size() == p + 1) {
            this.decisions.set(p, decision);
        } else {
            throw new SolverException("Cannot add decision to decision path");
        }
    }

    public void synchronize() {
        this.synchronize(true);
    }

    public void synchronize(boolean free) {
        if (this.decisions.size() > 1) {
            int t = this.last.get();
            for (int f = this.decisions.size() - 1; f >= t; --f) {
                Decision d2 = this.decisions.remove(f);
                if (!free) continue;
                d2.free();
            }
        }
    }

    public Decision getLastDecision() {
        int size = this.decisions.size();
        return this.decisions.get(size - 1);
    }

    public int size() {
        return this.decisions.size();
    }

    public Decision getDecision(int i) {
        if (i < 0 || i >= this.decisions.size()) {
            throw new IndexOutOfBoundsException("Index: " + i + ", Size: " + this.decisions.size());
        }
        return this.decisions.get(i);
    }

    public void transferInto(Collection<Decision> aList, boolean includeRootDecision) {
        int i;
        int n = i = includeRootDecision ? 0 : 1;
        while (i < this.decisions.size()) {
            aList.add(this.decisions.get(i));
            ++i;
        }
    }

    public String lastDecisionToString() {
        StringBuilder st = new StringBuilder();
        int lst = this.last.get();
        if (lst < this.decisions.size()) {
            Decision decision = this.decisions.get(lst);
            st.append(String.format("[%d/%d] %s", decision.getArity() - decision.triesLeft() + 1, decision.getArity(), decision));
        } else {
            st.append(String.format("[1/1] d_0: %s", this.decisions.get(0).toString()));
        }
        return st.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(String.format("Path[%s]: ", this.decisions.size()));
        sb.append(this.decisions.get(0));
        for (int i = 1; i < this.decisions.size(); ++i) {
            sb.append(", ").append(this.decisions.get(i));
        }
        return sb.toString();
    }
}

