/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.RealEvtScheduler;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.objects.RealInterval;

public class RealVarImpl
extends AbstractVariable
implements RealVar {
    private final IStateDouble LB;
    private final IStateDouble UB;
    private final double precision;

    public RealVarImpl(String name, double lb, double ub, double precision, Model model) {
        super(name, model);
        this.LB = model.getEnvironment().makeFloat(lb);
        this.UB = model.getEnvironment().makeFloat(ub);
        this.precision = precision;
    }

    @Override
    public double getPrecision() {
        return this.precision;
    }

    @Override
    public void silentlyAssign(RealInterval bounds) {
        this.silentlyAssign(bounds.getLB(), bounds.getUB());
    }

    @Override
    public void silentlyAssign(double lb, double ub) {
        this.LB.set(lb);
        this.UB.set(ub);
    }

    @Override
    public double getLB() {
        return this.LB.get();
    }

    @Override
    public double getUB() {
        return this.UB.get();
    }

    @Override
    public void intersect(double l, double u, ICause cause) throws ContradictionException {
        this.updateBounds(l, u, cause);
    }

    @Override
    public boolean updateLowerBound(double value, ICause cause) throws ContradictionException {
        assert (cause != null);
        double old = this.getLB();
        if (old < value) {
            if (this.getUB() < value) {
                this.contradiction(cause, "the new lower bound is greater than the current upper bound");
            } else {
                this.LB.set(value);
                this.notifyPropagators(RealEventType.INCLOW, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(double value, ICause cause) throws ContradictionException {
        assert (cause != null);
        double old = this.getUB();
        if (old > value) {
            if (this.getLB() > value) {
                this.contradiction(cause, "the new upper bound is lesser than the current lower bound");
            } else {
                this.UB.set(value);
                this.notifyPropagators(RealEventType.DECUPP, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean updateBounds(double lowerbound, double upperbound, ICause cause) throws ContradictionException {
        assert (cause != null);
        double oldlb = this.getLB();
        double oldub = this.getUB();
        if (oldlb < lowerbound || oldub > upperbound) {
            if (oldub < lowerbound || oldlb > upperbound) {
                this.contradiction(cause, "new bounds are incorrect");
            } else {
                RealEventType e2 = RealEventType.VOID;
                if (oldlb < lowerbound) {
                    this.LB.set(lowerbound);
                    e2 = RealEventType.INCLOW;
                }
                if (oldub > upperbound) {
                    this.UB.set(upperbound);
                    e2 = e2 == RealEventType.INCLOW ? RealEventType.BOUND : RealEventType.DECUPP;
                }
                this.notifyPropagators(e2, cause);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInstantiated() {
        double lb = this.LB.get();
        double ub = this.UB.get();
        return ub - lb < this.precision || this.nextValue(lb) >= ub;
    }

    private double nextValue(double x) {
        if (x < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) - 1L);
        }
        if (x == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (x < Double.POSITIVE_INFINITY) {
            return Double.longBitsToDouble(Double.doubleToLongBits(x) + 1L);
        }
        return x;
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public void createDelta() {
        throw new SolverException("Unable to create delta for RealVar!");
    }

    @Override
    public int getTypeAndKind() {
        return 65;
    }

    protected EvtScheduler createScheduler() {
        return new RealEvtScheduler();
    }

    @Override
    public String toString() {
        return String.format("%s = [%.16f .. %.16f]", this.name, this.getLB(), this.getUB());
    }

    @Override
    public void tighten() {
    }

    @Override
    public void project(ICause cause) throws ContradictionException {
    }

    @Override
    public void collectVariables(TreeSet<RealVar> set) {
        set.add(this);
    }

    @Override
    public void subExps(List<CArExpression> list) {
        list.add(this);
    }

    @Override
    public boolean isolate(RealVar var, List<CArExpression> wx, List<CArExpression> wox) {
        return var == this;
    }

    @Override
    public void init() {
    }
}

