/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.setDataStructures.iterable;

import java.util.Arrays;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public class IntIterableSetUtils {
    public static IntIterableRangeSet complement(IntIterableRangeSet set, int lbu, int ubu) {
        assert (lbu <= ubu);
        IntIterableRangeSet t = new IntIterableRangeSet();
        t.ELEMENTS = new int[set.SIZE + 2];
        int i = 0;
        int lb = lbu;
        while (i < set.SIZE && set.ELEMENTS[i] <= lbu) {
            lb = set.ELEMENTS[(i += 2) - 1] + 1;
        }
        if (i == set.SIZE) {
            if (lb <= ubu) {
                t.pushRange(lb, ubu);
            }
        } else {
            assert (set.ELEMENTS[i] > lb);
            t.pushRange(lb, set.ELEMENTS[i++] - 1);
            while (i < set.SIZE - 2 && set.ELEMENTS[i] < ubu) {
                t.pushRange(set.ELEMENTS[i++] + 1, set.ELEMENTS[i++] - 1);
            }
            if (set.ELEMENTS[i] < ubu) {
                t.pushRange(set.ELEMENTS[i] + 1, ubu);
            }
        }
        return t;
    }

    public static IntIterableRangeSet plus(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        IntIterableRangeSet t = new IntIterableRangeSet();
        IntIterableSetUtils.plus(t, set1, set2);
        return t;
    }

    public static void plus(IntIterableRangeSet setr, IntIterableRangeSet set1, IntIterableRangeSet set2) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            setr.grow(set1.SIZE);
            int i = 0;
            int j = 0;
            int[] is = new int[s2];
            Arrays.fill(is, -1);
            is[0] = 0;
            int lb = set1.ELEMENTS[0] + set2.ELEMENTS[0];
            int ub = set1.ELEMENTS[1] + set2.ELEMENTS[1];
            do {
                int _lb;
                int k;
                boolean extend = false;
                for (k = i; k <= j; ++k) {
                    _lb = set1.ELEMENTS[is[k] << 1] + set2.ELEMENTS[k << 1];
                    if (lb > _lb || _lb > ub + 1) continue;
                    ub = Math.max(set1.ELEMENTS[(is[k] << 1) + 1] + set2.ELEMENTS[(k << 1) + 1], ub);
                    extend = true;
                    if (k < s2 - 1 && k == j) {
                        int n = k + 1;
                        is[n] = is[n] + 1;
                        if (is[k + 1] == 0) {
                            ++j;
                        }
                    }
                    int n = k;
                    is[n] = is[n] + 1;
                    if (is[k] != s1) continue;
                    ++i;
                }
                if (extend) continue;
                setr.pushRange(lb, ub);
                lb = Integer.MAX_VALUE;
                for (k = i; k <= j; ++k) {
                    _lb = set1.ELEMENTS[is[k] << 1] + set2.ELEMENTS[k << 1];
                    if (lb <= _lb) continue;
                    lb = _lb;
                    ub = set1.ELEMENTS[(is[k] << 1) + 1] + set2.ELEMENTS[(k << 1) + 1];
                }
            } while (is[s2 - 1] < s1);
            setr.pushRange(lb, ub);
        }
    }

    public static void plus(IntIterableRangeSet setr, IntIterableRangeSet set1, int l, int u) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        if (s1 > 0 && l <= u) {
            setr.grow(set1.SIZE);
            int lb = set1.ELEMENTS[0] + l;
            int ub = set1.ELEMENTS[1] + u;
            for (int k = 0; k < s1; ++k) {
                int _lb = set1.ELEMENTS[k << 1] + l;
                if (lb <= _lb && _lb <= ub + 1) {
                    ub = Math.max(set1.ELEMENTS[(k << 1) + 1] + u, ub);
                    continue;
                }
                setr.pushRange(lb, ub);
                lb = set1.ELEMENTS[k << 1] + l;
                ub = set1.ELEMENTS[(k << 1) + 1] + u;
            }
            setr.pushRange(lb, ub);
        }
    }

    public static IntIterableRangeSet minus(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        IntIterableRangeSet t = new IntIterableRangeSet();
        IntIterableSetUtils.minus(t, set1, set2);
        return t;
    }

    public static void minus(IntIterableRangeSet setr, IntIterableRangeSet set1, IntIterableRangeSet set2) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            setr.grow(set1.SIZE);
            int i = s2 - 1;
            int j = s2 - 1;
            int[] is = new int[s2];
            Arrays.fill(is, -1);
            is[s2 - 1] = 0;
            int lb = set1.ELEMENTS[0] - set2.ELEMENTS[(s2 - 1 << 1) + 1];
            int ub = set1.ELEMENTS[1] - set2.ELEMENTS[s2 - 1 << 1];
            do {
                int _lb;
                int k;
                boolean extend = false;
                for (k = j; k >= i; --k) {
                    _lb = set1.ELEMENTS[is[k] << 1] - set2.ELEMENTS[(k << 1) + 1];
                    if (lb > _lb || _lb > ub + 1) continue;
                    ub = Math.max(set1.ELEMENTS[(is[k] << 1) + 1] - set2.ELEMENTS[k << 1], ub);
                    extend = true;
                    if (k > 0 && k == i) {
                        int n = k - 1;
                        is[n] = is[n] + 1;
                        if (is[k - 1] == 0) {
                            --i;
                        }
                    }
                    int n = k;
                    is[n] = is[n] + 1;
                    if (is[k] != s1) continue;
                    --j;
                }
                if (extend) continue;
                setr.pushRange(lb, ub);
                lb = Integer.MAX_VALUE;
                for (k = i; k <= j; ++k) {
                    _lb = set1.ELEMENTS[is[k] << 1] - set2.ELEMENTS[(k << 1) + 1];
                    if (lb <= _lb) continue;
                    lb = _lb;
                    ub = set1.ELEMENTS[(is[k] << 1) + 1] - set2.ELEMENTS[k << 1];
                }
            } while (is[0] < s1);
            setr.pushRange(lb, ub);
        }
    }

    public static void minus(IntIterableRangeSet setr, IntIterableRangeSet set1, int l, int u) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        if (s1 > 0 && l <= u) {
            setr.grow(set1.SIZE);
            int lb = set1.ELEMENTS[0] - u;
            int ub = set1.ELEMENTS[1] - l;
            for (int k = s1; k >= 0; --k) {
                int _lb = set1.ELEMENTS[k << 1] - u;
                if (lb <= _lb && _lb <= ub + 1) {
                    ub = Math.max(set1.ELEMENTS[(k << 1) + 1] - l, ub);
                    continue;
                }
                setr.pushRange(lb, ub);
                lb = set1.ELEMENTS[k << 1] - u;
                ub = set1.ELEMENTS[(k << 1) + 1] - l;
            }
            setr.pushRange(lb, ub);
        }
    }

    public static IntIterableRangeSet intersection(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        IntIterableRangeSet t = new IntIterableRangeSet();
        IntIterableSetUtils.intersection(t, set1, set2);
        return t;
    }

    public static void intersection(IntIterableRangeSet setr, IntIterableRangeSet set1, IntIterableRangeSet set2) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            setr.grow(set1.SIZE);
            int i = 0;
            int j = 0;
            int lbi = set1.ELEMENTS[0];
            int ubi = set1.ELEMENTS[1];
            int lbj = set2.ELEMENTS[0];
            int ubj = set2.ELEMENTS[1];
            while (i < s1 && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    int lb = Math.max(lbi, lbj);
                    int ub = Math.min(ubi, ubj);
                    setr.pushRange(lb, ub);
                }
                if (ubi <= ubj && ++i < s1) {
                    lbi = set1.ELEMENTS[i << 1];
                    ubi = set1.ELEMENTS[(i << 1) + 1];
                    continue;
                }
                if (ubj > ubi || ++j >= s2) continue;
                lbj = set2.ELEMENTS[j << 1];
                ubj = set2.ELEMENTS[(j << 1) + 1];
            }
        }
    }

    public static void intersection(IntIterableRangeSet setr, IntIterableRangeSet set1, int from, int to) {
        int s2;
        setr.clear();
        int s1 = set1.SIZE >> 1;
        int n = s2 = from <= to ? 1 : 0;
        if (s1 > 0 && s2 > 0) {
            setr.grow(set1.SIZE);
            int i = 0;
            int j = 0;
            int lbi = set1.ELEMENTS[0];
            int ubi = set1.ELEMENTS[1];
            int lbj = from;
            int ubj = to;
            while (i < s1 && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    int lb = Math.max(lbi, lbj);
                    int ub = Math.min(ubi, ubj);
                    setr.pushRange(lb, ub);
                }
                if (ubi <= ubj && ++i < s1) {
                    lbi = set1.ELEMENTS[i << 1];
                    ubi = set1.ELEMENTS[(i << 1) + 1];
                    continue;
                }
                if (ubj > ubi) continue;
                ++j;
            }
        }
    }

    public static boolean intersectionOf(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        boolean change = false;
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int i = 0;
            int j = 0;
            int s3 = 0;
            int c2 = 0;
            int[] e2 = new int[set1.SIZE];
            int lbi = set1.ELEMENTS[0];
            int ubi = set1.ELEMENTS[1];
            int lbj = set2.ELEMENTS[0];
            int ubj = set2.ELEMENTS[1];
            while (i < s1 && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    int lb = Math.max(lbi, lbj);
                    int ub = Math.min(ubi, ubj);
                    if (s3 + 2 > e2.length) {
                        int oldCapacity = e2.length;
                        int newCapacity = oldCapacity + (oldCapacity >> 1);
                        if (newCapacity < s3 + 2) {
                            newCapacity = s3 + 2;
                        }
                        e2 = Arrays.copyOf(e2, newCapacity);
                    }
                    e2[s3++] = lb;
                    e2[s3++] = ub;
                    c2 += ub - lb + 1;
                    change = true;
                }
                if (ubi <= ubj && ++i < s1) {
                    lbi = set1.ELEMENTS[i << 1];
                    ubi = set1.ELEMENTS[(i << 1) + 1];
                    continue;
                }
                if (ubj > ubi || ++j >= s2) continue;
                lbj = set2.ELEMENTS[j << 1];
                ubj = set2.ELEMENTS[(j << 1) + 1];
            }
            set1.ELEMENTS = e2;
            set1.SIZE = s3;
            change |= set1.CARDINALITY != c2;
            set1.CARDINALITY = c2;
        } else {
            change = set1.CARDINALITY > 0;
            set1.clear();
        }
        return change;
    }

    public static IntIterableRangeSet union(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        IntIterableRangeSet t = new IntIterableRangeSet();
        IntIterableSetUtils.union(t, set1, set2);
        return t;
    }

    public static void union(IntIterableRangeSet setr, IntIterableRangeSet set1, IntIterableRangeSet set2) {
        setr.clear();
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int ubi;
            int lbi;
            setr.grow(set1.SIZE);
            int i = 0;
            int j = 0;
            int lb = lbi = set1.ELEMENTS[0];
            int ub = ubi = set1.ELEMENTS[1];
            int lbj = set2.ELEMENTS[0];
            int ubj = set2.ELEMENTS[1];
            if (lb > lbj) {
                lb = lbj;
                ub = ubj;
            }
            while (i < s1 || j < s2) {
                boolean extend = false;
                if (lb - 1 <= lbi && lbi <= ub + 1) {
                    ub = Math.max(ub, ubi);
                    boolean bl = extend = i < s1;
                    if (++i < s1) {
                        lbi = set1.ELEMENTS[i << 1];
                        ubi = set1.ELEMENTS[(i << 1) + 1];
                    }
                }
                if (lb - 1 <= lbj && lbj <= ub + 1) {
                    ub = Math.max(ub, ubj);
                    extend |= j < s2;
                    if (++j < s2) {
                        lbj = set2.ELEMENTS[j << 1];
                        ubj = set2.ELEMENTS[(j << 1) + 1];
                    }
                }
                if (extend) continue;
                setr.pushRange(lb, ub);
                if (i < s1) {
                    lb = lbi;
                    ub = ubi;
                    if (j >= s2 || lbi <= lbj) continue;
                    lb = lbj;
                    ub = ubj;
                    continue;
                }
                if (j >= s2) continue;
                lb = lbj;
                ub = ubj;
            }
            setr.pushRange(lb, ub);
        }
    }

    public static boolean unionOf(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        boolean change = false;
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int newCapacity;
            int oldCapacity;
            int ubi;
            int lbi;
            int i = 0;
            int j = 0;
            int s3 = 0;
            int c2 = 0;
            int[] e2 = new int[set1.SIZE];
            int lb = lbi = set1.ELEMENTS[0];
            int ub = ubi = set1.ELEMENTS[1];
            int lbj = set2.ELEMENTS[0];
            int ubj = set2.ELEMENTS[1];
            if (lb > lbj) {
                lb = lbj;
                ub = ubj;
            }
            while (i < s1 || j < s2) {
                boolean extend = false;
                if (lb - 1 <= lbi && lbi <= ub + 1) {
                    ub = Math.max(ub, ubi);
                    boolean bl = extend = i < s1;
                    if (++i < s1) {
                        lbi = set1.ELEMENTS[i << 1];
                        ubi = set1.ELEMENTS[(i << 1) + 1];
                    }
                }
                if (lb - 1 <= lbj && lbj <= ub + 1) {
                    ub = Math.max(ub, ubj);
                    extend |= j < s2;
                    if (++j < s2) {
                        lbj = set2.ELEMENTS[j << 1];
                        ubj = set2.ELEMENTS[(j << 1) + 1];
                    }
                }
                if (extend) continue;
                if (s3 + 2 > e2.length) {
                    oldCapacity = e2.length;
                    newCapacity = oldCapacity + (oldCapacity >> 1);
                    if (newCapacity < s3 + 2) {
                        newCapacity = s3 + 2;
                    }
                    e2 = Arrays.copyOf(e2, newCapacity);
                }
                e2[s3++] = lb;
                e2[s3++] = ub;
                c2 += ub - lb + 1;
                if (i < s1) {
                    lb = lbi;
                    ub = ubi;
                    if (j >= s2 || lbi <= lbj) continue;
                    lb = lbj;
                    ub = ubj;
                    continue;
                }
                if (j >= s2) continue;
                lb = lbj;
                ub = ubj;
            }
            if (s3 + 2 > e2.length) {
                oldCapacity = e2.length;
                newCapacity = oldCapacity + (oldCapacity >> 1);
                if (newCapacity < s3 + 2) {
                    newCapacity = s3 + 2;
                }
                e2 = Arrays.copyOf(e2, newCapacity);
            }
            e2[s3++] = lb;
            e2[s3++] = ub;
            set1.ELEMENTS = e2;
            set1.SIZE = s3;
            change = set1.CARDINALITY != (c2 += ub - lb + 1);
            set1.CARDINALITY = c2;
        } else if (s2 > 0) {
            set1.grow(set2.SIZE);
            System.arraycopy(set2.ELEMENTS, 0, set1.ELEMENTS, 0, set2.SIZE);
            set1.SIZE = set2.SIZE;
            set1.CARDINALITY = set2.CARDINALITY;
            change = true;
        }
        return change;
    }

    public static boolean includedIn(IntVar var, IntIterableRangeSet set) {
        int s1 = var.getDomainSize();
        int s2 = set.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int j = 0;
            int lbi = var.getLB();
            int ubi = var.nextValueOut(lbi) - 1;
            int lbj = set.ELEMENTS[0];
            int ubj = set.ELEMENTS[1];
            while (lbi < Integer.MAX_VALUE && j < s2) {
                if (ubj < lbi && ++j < s2) {
                    lbj = set.ELEMENTS[j << 1];
                    ubj = set.ELEMENTS[(j << 1) + 1];
                    continue;
                }
                if (lbj <= lbi && ubi <= ubj) {
                    lbi = var.nextValue(ubi);
                    if (lbi >= Integer.MAX_VALUE) continue;
                    ubi = var.nextValueOut(lbi) - 1;
                    continue;
                }
                return false;
            }
        }
        return s2 > 0;
    }

    public static boolean includedIn(IntIterableRangeSet set1, IntIterableRangeSet set2) {
        int s1 = set1.SIZE >> 1;
        int s2 = set2.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            int i = 0;
            int j = 0;
            int lbi = set1.ELEMENTS[0];
            int ubi = set1.ELEMENTS[1];
            int lbj = set2.ELEMENTS[0];
            int ubj = set2.ELEMENTS[1];
            while (i < s1 && j < s2) {
                if (ubj < lbi && ++j < s2) {
                    lbj = set2.ELEMENTS[j << 1];
                    ubj = set2.ELEMENTS[(j << 1) + 1];
                    continue;
                }
                if (lbj <= lbi && ubi <= ubj) {
                    if (++i >= s1) continue;
                    lbi = set1.ELEMENTS[i << 1];
                    ubi = set1.ELEMENTS[(i << 1) + 1];
                    continue;
                }
                return false;
            }
        }
        return s2 > 0;
    }

    public static boolean notIncludedIn(IntVar var, IntIterableRangeSet set) {
        int s1 = var.getDomainSize();
        int s2 = set.SIZE >> 1;
        if (s1 > 0 && s2 > 0) {
            DisposableRangeIterator rit = var.getRangeIterator(true);
            int j = 0;
            int lbi = rit.min();
            int ubi = rit.max();
            rit.next();
            int lbj = set.ELEMENTS[0];
            int ubj = set.ELEMENTS[1];
            while (rit.hasNext() && j < s2) {
                if (lbi <= lbj && lbj <= ubi || lbj <= lbi && lbi <= ubj) {
                    rit.dispose();
                    return true;
                }
                if (ubi <= ubj && rit.hasNext()) {
                    lbi = rit.min();
                    ubi = rit.max();
                    rit.next();
                    continue;
                }
                if (ubj > ubi || ++j >= s2) continue;
                lbj = set.ELEMENTS[j << 1];
                ubj = set.ELEMENTS[(j << 1) + 1];
            }
            rit.dispose();
        }
        return false;
    }
}

