/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.disk.storage.portability;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.offheapstore.disk.persistent.PersistentPortability;
import org.terracotta.offheapstore.storage.portability.SerializablePortability;
import org.terracotta.offheapstore.util.FindbugsSuppressWarnings;

public class PersistentSerializablePortability
extends SerializablePortability
implements PersistentPortability<Serializable> {
    private static final int MAGIC = -17973521;

    public PersistentSerializablePortability() {
    }

    public PersistentSerializablePortability(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void persist(ObjectOutput output) throws IOException {
        output.writeInt(-17973521);
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            for (Map.Entry e2 : this.lookup.entrySet()) {
                if (!(e2.getKey() instanceof Integer)) continue;
                output.writeInt((Integer)e2.getKey());
                output.writeObject(e2.getValue());
            }
            output.writeInt(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FindbugsSuppressWarnings(value={"JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
    public void bootstrap(ObjectInput input) throws IOException {
        if (input.readInt() != -17973521) {
            throw new IOException("Wrong magic number");
        }
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            int nextIndex = 0;
            while (true) {
                ObjectStreamClass osc;
                int representation;
                if ((representation = input.readInt()) == -1) {
                    if (this.nextStreamIndex == 0) {
                        this.nextStreamIndex = nextIndex;
                        break;
                    }
                    if (this.nextStreamIndex == nextIndex) break;
                    throw new IOException("Cannot bootstrap already used instance");
                }
                try {
                    osc = (ObjectStreamClass)input.readObject();
                }
                catch (ClassNotFoundException e2) {
                    throw new IOException(e2);
                }
                SerializablePortability.SerializableDataKey key = new SerializablePortability.SerializableDataKey(PersistentSerializablePortability.disconnect(osc), true);
                ObjectStreamClass oldOsc = this.lookup.putIfAbsent(representation, osc);
                Integer oldRep = this.lookup.putIfAbsent(key, representation);
                if (oldRep != null && !oldRep.equals(representation)) {
                    throw new IOException("Existing colliding class mapping detected");
                }
                if (oldOsc != null && !oldOsc.getName().equals(osc.getName())) {
                    throw new IOException("Existing colliding class mapping detected");
                }
                nextIndex = Math.max(nextIndex, representation + 1);
            }
        }
    }
}

