/*
 * Decompiled with CFR 0.152.
 */
package com.musigma.consumer;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.common.InvalidConfigException;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.javaapi.FetchResponse;
import kafka.javaapi.consumer.SimpleConsumer;
import kafka.javaapi.message.ByteBufferMessageSet;
import kafka.message.MessageAndOffset;
import org.I0Itec.zkclient.exception.ZkTimeoutException;

public class MuSimpleConsumer {
    private SimpleConsumer consumer;
    private String clientId;
    private UUID key = UUID.randomUUID();
    private static ConcurrentMap<UUID, Queue<String>> concurrentMap = new ConcurrentHashMap<UUID, Queue<String>>(100, 0.75f, 100);

    public UUID getKey() {
        return this.key;
    }

    public void CreateSimpleConsumer(String kafkaServerURL, String skafkaServerPort, String sconnectionTimeOut, String skafkaProducerBufferSize, String clientId) {
        int kafkaServerPort = Integer.parseInt(skafkaServerPort);
        int connectionTimeOut = Integer.parseInt(sconnectionTimeOut);
        int kafkaProducerBufferSize = Integer.parseInt(skafkaProducerBufferSize);
        this.clientId = clientId;
        try {
            this.consumer = new SimpleConsumer(kafkaServerURL, kafkaServerPort, connectionTimeOut, kafkaProducerBufferSize, clientId);
        }
        catch (NumberFormatException e) {
            System.out.println("Please check all consumer properties passed");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Please check all consumer properties passed");
            e.printStackTrace();
        }
        catch (ZkTimeoutException e) {
            System.out.println("Unable to connect to zookeeper server");
            e.printStackTrace();
        }
        catch (InvalidConfigException e) {
            System.out.println("Invalid value set for consumer properties. Please check all consumer properties passed");
            e.printStackTrace();
        }
    }

    public void receive(String topicName, String spartition, String sOffset, String smsgReadSize) throws UnsupportedEncodingException {
        try {
            int partition2 = Integer.parseInt(spartition);
            int Offset = Integer.parseInt(sOffset);
            int msgReadSize = Integer.parseInt(smsgReadSize);
            LinkedList<String> msgs = new LinkedList<String>();
            long readOffset = Offset;
            FetchRequest req = new FetchRequestBuilder().clientId(this.clientId).addFetch(topicName, partition2, readOffset, msgReadSize).build();
            FetchResponse fetchResponse = this.consumer.fetch(req);
            ByteBufferMessageSet toRead = fetchResponse.messageSet(topicName, partition2);
            for (MessageAndOffset messageAndOffset : toRead) {
                ByteBuffer payload = messageAndOffset.message().payload();
                byte[] bytes = new byte[payload.limit()];
                payload.get(bytes);
                String msg = new String(bytes, "UTF-8");
                msgs.add(msg);
                concurrentMap.put(this.key, msgs);
            }
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Unsupported Encoding");
            e.printStackTrace();
        }
        catch (UnknownTopicOrPartitionException e) {
            System.out.println("Unknown topic or partition");
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            System.out.println("Please check all parameters passed");
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String read() {
        UUID retrieveKey = this.getKey();
        Queue readMessages = (Queue)concurrentMap.get(retrieveKey);
        if (readMessages.isEmpty()) {
            return "";
        }
        return (String)readMessages.poll();
    }

    public void close() {
        this.consumer.close();
    }
}

