/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001)4\u0001\"\u0001\u0002\u0005\u0002\u0003\u0005\ta\u0002\u0002\u0015%\u0016\u0004H.[2b\r\u0016$8\r[3s)\"\u0014X-\u00193\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!AA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\n'\u0001\u0011\t\u0011)A\u0005)m\tAA\\1nKB\u0011Q\u0003\u0007\b\u0003\u001bYI!a\u0006\b\u0002\rA\u0013X\rZ3g\u0013\tI\"D\u0001\u0004TiJLgn\u001a\u0006\u0003/9I!a\u0005\u000f\n\u0005uq\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012T!a\b\u0003\u0002\u000bU$\u0018\u000e\\:\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\nAb]8ve\u000e,'I]8lKJ\u0004\"a\t\u0014\u000e\u0003\u0011R!!\n\u0003\u0002\u000f\rdWo\u001d;fe&\u0011q\u0005\n\u0002\u0007\u0005J|7.\u001a:\t\u0011%\u0002!\u0011!Q\u0001\n)\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!C\u0016\n\u00051\u0012!aC&bM.\f7i\u001c8gS\u001eD\u0001B\f\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000be\u0016\u0004H.[2b\u001b\u001e\u0014\bCA\u00051\u0013\t\t$A\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\u0015)dg\u000e\u001d:!\tI\u0001\u0001C\u0003\u0014e\u0001\u0007A\u0003C\u0003\"e\u0001\u0007!\u0005C\u0003*e\u0001\u0007!\u0006C\u0003/e\u0001\u0007q\u0006C\u0003<\u0001\u0011\u0005A(\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\u0005{\u0001CU\n\u0005\u0002\u000e}%\u0011qH\u0004\u0002\u0005+:LG\u000fC\u0003Bu\u0001\u0007!)A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:\u0004\"a\u0011$\u000e\u0003\u0011S!!\u0012\u0003\u0002\r\r|W.\\8o\u0013\t9EIA\tU_BL7-\u00118e!\u0006\u0014H/\u001b;j_:DQ!\u0013\u001eA\u0002)\u000b1BZ3uG\"|eMZ:fiB\u0011QbS\u0005\u0003\u0019:\u0011A\u0001T8oO\")aJ\u000fa\u0001\u001f\u0006i\u0001/\u0019:uSRLwN\u001c#bi\u0006\u0004\"\u0001U*\u000e\u0003ES!A\u0015\u0003\u0002\u0007\u0005\u0004\u0018.\u0003\u0002U#\nQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\")a\u000b\u0001C\u0001/\u00061\u0002.\u00198eY\u0016|eMZ:fi>+Ho\u00144SC:<W\r\u0006\u0002K1\")\u0011)\u0016a\u0001\u0005\")!\f\u0001C\u00017\u0006Q\u0002.\u00198eY\u0016\u0004\u0016M\u001d;ji&|gn],ji\",%O]8sgR\u0011Q\b\u0018\u0005\u0006;f\u0003\rAX\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bcA0h\u0005:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G\u001a\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\u0019t\u0011a\u00029bG.\fw-Z\u0005\u0003Q&\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0003M:\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread
implements ScalaObject {
    public final Broker kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;

    @Override
    public void processPartitionData(TopicAndPartition topicAndPartition$1, long fetchOffset, FetchResponsePartitionData partitionData$1) {
        try {
            String topic$1 = topicAndPartition$1.topic();
            int partitionId$1 = topicAndPartition$1.partition();
            Replica replica$1 = this.replicaMgr.getReplica(topic$1, partitionId$1, this.replicaMgr.getReplica$default$3()).get();
            ByteBufferMessageSet messageSet$1 = (ByteBufferMessageSet)partitionData$1.messages();
            if (fetchOffset != replica$1.logEndOffset()) {
                throw new RuntimeException(Predef$.MODULE$.augmentString("Offset mismatch: fetched offset = %d, log end offset = %d.").format((Seq<Object>)Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(replica$1.logEndOffset())})));
            }
            this.trace((Function0<String>)new $anonfun$processPartitionData$1(this, topicAndPartition$1, partitionData$1, replica$1, messageSet$1));
            replica$1.log().get().append(messageSet$1, false);
            this.trace((Function0<String>)new $anonfun$processPartitionData$2(this, topicAndPartition$1, replica$1, messageSet$1));
            long followerHighWatermark$1 = Predef$.MODULE$.longWrapper(replica$1.logEndOffset()).min(partitionData$1.hw());
            replica$1.highWatermark_$eq(followerHighWatermark$1);
            this.trace((Function0<String>)new $anonfun$processPartitionData$3(this, topic$1, partitionId$1, replica$1, followerHighWatermark$1));
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)new $anonfun$processPartitionData$4(this), (Function0<Throwable>)new $anonfun$processPartitionData$5(this, kafkaStorageException));
            Runtime.getRuntime().halt(1);
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicAndPartition topicAndPartition$2) {
        long l;
        Replica replica = this.replicaMgr.getReplica(topicAndPartition$2.topic(), topicAndPartition$2.partition(), this.replicaMgr.getReplica$default$3()).get();
        long leaderEndOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.LatestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset$1 < replica.logEndOffset()) {
            this.replicaMgr.logManager().truncateTo((Map<TopicAndPartition, Long>)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(topicAndPartition$2).$minus$greater(BoxesRunTime.boxToLong(leaderEndOffset$1))})));
            this.warn((Function0<String>)new $anonfun$handleOffsetOutOfRange$1(this, topicAndPartition$2, leaderEndOffset$1));
            l = leaderEndOffset$1;
        } else {
            long leaderStartOffset$1 = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition$2, OffsetRequest$.MODULE$.EarliestTime(), this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.replicaMgr.logManager().truncateFullyAndStartAt(topicAndPartition$2, leaderStartOffset$1);
            this.warn((Function0<String>)new $anonfun$handleOffsetOutOfRange$2(this, topicAndPartition$2, leaderStartOffset$1));
            l = leaderStartOffset$1;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicAndPartition> partitions) {
    }

    public ReplicaFetcherThread(String name, Broker sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        super(name, name, sourceBroker, brokerConfig.replicaSocketTimeoutMs(), brokerConfig.replicaSocketReceiveBufferBytes(), brokerConfig.replicaFetchMaxBytes(), brokerConfig.brokerId(), brokerConfig.replicaFetchWaitMaxMs(), brokerConfig.replicaFetchMinBytes(), false);
    }
}

