/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.AbstractDensityBasedClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.estimators.DiscreteEstimator;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class MakeDensityBasedClusterer
extends AbstractDensityBasedClusterer
implements NumberOfClustersRequestable,
OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -5643302427972186631L;
    private Instances m_theInstances;
    private double[] m_priors;
    private double[][][] m_modelNormal;
    private DiscreteEstimator[][] m_model;
    private double m_minStdDev = 1.0E-6;
    private Clusterer m_wrappedClusterer = new SimpleKMeans();
    private ReplaceMissingValues m_replaceMissing;
    private static double m_normConst = 0.5 * Math.log(Math.PI * 2);

    public MakeDensityBasedClusterer() {
    }

    public MakeDensityBasedClusterer(Clusterer toWrap) {
        this.setClusterer(toWrap);
    }

    public String globalInfo() {
        return "Class for wrapping a Clusterer to make it return a distribution and density. Fits normal distributions and discrete distributions within each cluster produced by the wrapped clusterer. Supports the NumberOfClustersRequestable interface only if the wrapped Clusterer does.";
    }

    protected String defaultClustererString() {
        return SimpleKMeans.class.getName();
    }

    @Override
    public void setNumClusters(int n) throws Exception {
        if (this.m_wrappedClusterer == null) {
            throw new Exception("Can't set the number of clusters to generate - no clusterer has been set yet.");
        }
        if (!(this.m_wrappedClusterer instanceof NumberOfClustersRequestable)) {
            throw new Exception("Can't set the number of clusters to generate - wrapped clusterer does not support this facility.");
        }
        ((NumberOfClustersRequestable)((Object)this.m_wrappedClusterer)).setNumClusters(n);
    }

    @Override
    public Capabilities getCapabilities() {
        if (this.m_wrappedClusterer != null) {
            return this.m_wrappedClusterer.getCapabilities();
        }
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        int i;
        this.getCapabilities().testWithFail(data);
        this.m_replaceMissing = new ReplaceMissingValues();
        this.m_replaceMissing.setInputFormat(data);
        data = Filter.useFilter(data, this.m_replaceMissing);
        this.m_theInstances = new Instances(data, 0);
        if (this.m_wrappedClusterer == null) {
            throw new Exception("No clusterer has been set");
        }
        this.m_wrappedClusterer.buildClusterer(data);
        this.m_model = new DiscreteEstimator[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()];
        this.m_modelNormal = new double[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()][2];
        double[][] weights = new double[this.m_wrappedClusterer.numberOfClusters()][data.numAttributes()];
        this.m_priors = new double[this.m_wrappedClusterer.numberOfClusters()];
        int i2 = 0;
        while (i2 < this.m_wrappedClusterer.numberOfClusters()) {
            this.m_priors[i2] = 1.0;
            int j = 0;
            while (j < data.numAttributes()) {
                if (data.attribute(j).isNominal()) {
                    this.m_model[i2][j] = new DiscreteEstimator(data.attribute(j).numValues(), true);
                }
                ++j;
            }
            ++i2;
        }
        Instance inst = null;
        int[] clusterIndex = new int[data.numInstances()];
        int i3 = 0;
        while (i3 < data.numInstances()) {
            int cluster;
            inst = data.instance(i3);
            int n = cluster = this.m_wrappedClusterer.clusterInstance(inst);
            this.m_priors[n] = this.m_priors[n] + inst.weight();
            int j = 0;
            while (j < data.numAttributes()) {
                if (!inst.isMissing(j)) {
                    if (data.attribute(j).isNominal()) {
                        this.m_model[cluster][j].addValue(inst.value(j), inst.weight());
                    } else {
                        double[] dArray = this.m_modelNormal[cluster][j];
                        dArray[0] = dArray[0] + inst.weight() * inst.value(j);
                        double[] dArray2 = weights[cluster];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + inst.weight();
                    }
                }
                ++j;
            }
            clusterIndex[i3] = cluster;
            ++i3;
        }
        int j = 0;
        while (j < data.numAttributes()) {
            if (data.attribute(j).isNumeric()) {
                i = 0;
                while (i < this.m_wrappedClusterer.numberOfClusters()) {
                    if (weights[i][j] > 0.0) {
                        double[] dArray = this.m_modelNormal[i][j];
                        dArray[0] = dArray[0] / weights[i][j];
                    }
                    ++i;
                }
            }
            ++j;
        }
        i3 = 0;
        while (i3 < data.numInstances()) {
            inst = data.instance(i3);
            int j2 = 0;
            while (j2 < data.numAttributes()) {
                if (!inst.isMissing(j2) && data.attribute(j2).isNumeric()) {
                    double diff = this.m_modelNormal[clusterIndex[i3]][j2][0] - inst.value(j2);
                    double[] dArray = this.m_modelNormal[clusterIndex[i3]][j2];
                    dArray[1] = dArray[1] + inst.weight() * diff * diff;
                }
                ++j2;
            }
            ++i3;
        }
        j = 0;
        while (j < data.numAttributes()) {
            if (data.attribute(j).isNumeric()) {
                i = 0;
                while (i < this.m_wrappedClusterer.numberOfClusters()) {
                    if (weights[i][j] > 0.0) {
                        this.m_modelNormal[i][j][1] = Math.sqrt(this.m_modelNormal[i][j][1] / weights[i][j]);
                    } else if (weights[i][j] <= 0.0) {
                        this.m_modelNormal[i][j][1] = Double.MAX_VALUE;
                    }
                    if (this.m_modelNormal[i][j][1] <= this.m_minStdDev) {
                        this.m_modelNormal[i][j][1] = data.attributeStats((int)j).numericStats.stdDev;
                        if (this.m_modelNormal[i][j][1] <= this.m_minStdDev) {
                            this.m_modelNormal[i][j][1] = this.m_minStdDev;
                        }
                    }
                    ++i;
                }
            }
            ++j;
        }
        Utils.normalize(this.m_priors);
    }

    @Override
    public double[] clusterPriors() {
        double[] n = new double[this.m_priors.length];
        System.arraycopy(this.m_priors, 0, n, 0, n.length);
        return n;
    }

    @Override
    public double[] logDensityPerClusterForInstance(Instance inst) throws Exception {
        double[] wghts = new double[this.m_wrappedClusterer.numberOfClusters()];
        this.m_replaceMissing.input(inst);
        inst = this.m_replaceMissing.output();
        int i = 0;
        while (i < this.m_wrappedClusterer.numberOfClusters()) {
            double logprob = 0.0;
            int j = 0;
            while (j < inst.numAttributes()) {
                if (!inst.isMissing(j)) {
                    logprob = inst.attribute(j).isNominal() ? (logprob += Math.log(this.m_model[i][j].getProbability(inst.value(j)))) : (logprob += this.logNormalDens(inst.value(j), this.m_modelNormal[i][j][0], this.m_modelNormal[i][j][1]));
                }
                ++j;
            }
            wghts[i] = logprob;
            ++i;
        }
        return wghts;
    }

    private double logNormalDens(double x, double mean, double stdDev) {
        double diff = x - mean;
        return -(diff * diff / (2.0 * stdDev * stdDev)) - m_normConst - Math.log(stdDev);
    }

    @Override
    public int numberOfClusters() throws Exception {
        return this.m_wrappedClusterer.numberOfClusters();
    }

    public String toString() {
        if (this.m_priors == null) {
            return "No clusterer built yet!";
        }
        StringBuffer text = new StringBuffer();
        text.append("MakeDensityBasedClusterer: \n\nWrapped clusterer: " + this.m_wrappedClusterer.toString());
        text.append("\nFitted estimators (with ML estimates of variance):\n");
        int j = 0;
        while (j < this.m_priors.length) {
            text.append("\nCluster: " + j + " Prior probability: " + Utils.doubleToString(this.m_priors[j], 4) + "\n\n");
            int i = 0;
            while (i < this.m_model[0].length) {
                text.append("Attribute: " + this.m_theInstances.attribute(i).name() + "\n");
                if (this.m_theInstances.attribute(i).isNominal()) {
                    if (this.m_model[j][i] != null) {
                        text.append(this.m_model[j][i].toString());
                    }
                } else {
                    text.append("Normal Distribution. Mean = " + Utils.doubleToString(this.m_modelNormal[j][i][0], 4) + " StdDev = " + Utils.doubleToString(this.m_modelNormal[j][i][1], 4) + "\n");
                }
                ++i;
            }
            ++j;
        }
        return text.toString();
    }

    public String clustererTipText() {
        return "the clusterer to wrap";
    }

    public void setClusterer(Clusterer toWrap) {
        this.m_wrappedClusterer = toWrap;
    }

    public Clusterer getClusterer() {
        return this.m_wrappedClusterer;
    }

    public String minStdDevTipText() {
        return "set minimum allowable standard deviation";
    }

    public void setMinStdDev(double m) {
        this.m_minStdDev = m;
    }

    public double getMinStdDev() {
        return this.m_minStdDev;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tminimum allowable standard deviation for normal density computation \n\t(default 1e-6)", "M", 1, "-M <num>"));
        result.addElement(new Option("\tClusterer to wrap.\n\t(default " + this.defaultClustererString() + ")", "W", 1, "-W <clusterer name>"));
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            result.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_wrappedClusterer.getClass().getName() + ":"));
            Enumeration enu = ((OptionHandler)((Object)this.m_wrappedClusterer)).listOptions();
            while (enu.hasMoreElements()) {
                result.addElement((Option)enu.nextElement());
            }
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String optionString = Utils.getOption('M', options);
        if (optionString.length() != 0) {
            this.setMinStdDev(new Double(optionString));
        } else {
            this.setMinStdDev(1.0E-6);
        }
        String wString = Utils.getOption('W', options);
        if (wString.length() == 0) {
            wString = this.defaultClustererString();
        }
        this.setClusterer(AbstractClusterer.forName(wString, Utils.partitionOptions(options)));
    }

    @Override
    public String[] getOptions() {
        String[] clustererOptions = new String[]{};
        if (this.m_wrappedClusterer != null && this.m_wrappedClusterer instanceof OptionHandler) {
            clustererOptions = ((OptionHandler)((Object)this.m_wrappedClusterer)).getOptions();
        }
        String[] options = new String[clustererOptions.length + 5];
        int current = 0;
        options[current++] = "-M";
        options[current++] = "" + this.getMinStdDev();
        if (this.getClusterer() != null) {
            options[current++] = "-W";
            options[current++] = this.getClusterer().getClass().getName();
        }
        options[current++] = "--";
        System.arraycopy(clustererOptions, 0, options, current, clustererOptions.length);
        current += clustererOptions.length;
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] argv) {
        MakeDensityBasedClusterer.runClusterer(new MakeDensityBasedClusterer(), argv);
    }
}

