/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.util;

import dr.evolution.util.Units;
import java.util.Date;

public class TimeScale
implements Units {
    protected double origin = 720035.0;
    protected Units.Type units;
    protected boolean backwards;
    protected static double MILLIS_PER_DAY = 8.64E7;
    protected static double DAYS_PER_YEAR = 365.25;
    protected static double MONTHS_PER_YEAR = 12.0;
    protected static double DAYS_PER_MONTH = DAYS_PER_YEAR / MONTHS_PER_YEAR;

    public TimeScale(Units.Type type, boolean bl) {
        this(type, bl, 0.0);
    }

    public TimeScale(Units.Type type, boolean bl, double d) {
        this.units = type;
        this.backwards = bl;
        this.origin = d;
    }

    public TimeScale(Units.Type type, boolean bl, Date date) {
        this.units = type;
        this.backwards = bl;
        long l = date.getTime();
        double d = (double)l / MILLIS_PER_DAY;
        switch (type) {
            case DAYS: {
                this.origin = d;
                break;
            }
            case MONTHS: {
                this.origin = d / DAYS_PER_MONTH;
                break;
            }
            case YEARS: {
                this.origin = d / DAYS_PER_YEAR;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    public boolean isBackwards() {
        return this.backwards;
    }

    public double getOrigin() {
        return this.origin;
    }

    public double convertTime(double d, TimeScale timeScale) {
        if (timeScale.isBackwards()) {
            d = -d;
        }
        double d2 = TimeScale.convertTimeUnits(d += timeScale.getOrigin(), this.getUnits(), timeScale.getUnits());
        d2 -= this.origin;
        if (this.backwards) {
            d2 = -d2;
        }
        return d2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("timescale(");
        stringBuffer.append(this.unitString(0.0));
        if (this.backwards) {
            stringBuffer.append(", backwards");
        } else {
            stringBuffer.append(", forewards");
        }
        stringBuffer.append(" from " + this.origin + ")");
        return stringBuffer.toString();
    }

    public String unitString(double d) {
        String string = null;
        switch (this.units) {
            case DAYS: {
                string = "day";
                break;
            }
            case MONTHS: {
                string = "month";
                break;
            }
            case YEARS: {
                string = "year";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (d == 1.0) {
            return string;
        }
        return string + "s";
    }

    public static void main(String[] stringArray) {
        TimeScale timeScale = new TimeScale(Units.Type.DAYS, true);
        TimeScale timeScale2 = new TimeScale(Units.Type.YEARS, true);
        System.out.println(timeScale);
        System.out.println(timeScale2);
        double d = 100.0;
        System.out.println("Test time = " + d);
        System.out.println("timeScale1.convertTime(" + d + ", timeScale2)=" + timeScale.convertTime(d, timeScale2));
        System.out.println("timeScale2.convertTime(" + d + ", timeScale1)=" + timeScale2.convertTime(d, timeScale));
    }

    public static double convertTimeUnits(double d, Units.Type type, Units.Type type2) {
        return d * TimeScale.getScale(type, type2);
    }

    public static double getScale(Units.Type type, Units.Type type2) {
        if (type == type2) {
            return 1.0;
        }
        switch (type) {
            case DAYS: {
                switch (type2) {
                    case MONTHS: {
                        return 1.0 / DAYS_PER_MONTH;
                    }
                    case YEARS: {
                        return 1.0 / DAYS_PER_YEAR;
                    }
                }
                throw new IllegalArgumentException();
            }
            case MONTHS: {
                switch (type2) {
                    case DAYS: {
                        return DAYS_PER_MONTH;
                    }
                    case YEARS: {
                        return 1.0 / MONTHS_PER_YEAR;
                    }
                }
                throw new IllegalArgumentException();
            }
            case YEARS: {
                switch (type2) {
                    case DAYS: {
                        return DAYS_PER_YEAR;
                    }
                    case MONTHS: {
                        return MONTHS_PER_YEAR;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        throw new IllegalArgumentException();
    }
}

