/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.BifractionalDiffusionDensity;

public class BifractionalDiffusionModel
extends MultivariateDiffusionModel {
    private Parameter alpha;
    private Parameter beta;
    private BifractionalDiffusionDensity bifractionalDensity;
    private boolean densityKnown;
    private double scalarDistance = 0.01;
    private double scalarTime = 10000.0;

    public BifractionalDiffusionModel(Parameter parameter, Parameter parameter2) {
        this.alpha = parameter;
        this.beta = parameter2;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.densityKnown = false;
    }

    @Override
    protected double calculateLogDensity(double[] dArray, double[] dArray2, double d) {
        double d2;
        double d3;
        double d4 = this.alpha.getParameterValue(0);
        double d5 = this.beta.getParameterValue(0);
        double d6 = this.distanceEuclidean(dArray, dArray2) * this.scalarDistance;
        if (!this.densityKnown) {
            this.setupDensity();
            this.densityKnown = true;
        }
        if (Double.isNaN(d3 = Math.log(d2 = this.bifractionalDensity.pdf(d6, d * this.scalarTime)))) {
            System.err.println("a = " + d4);
            System.err.println("b = " + d5);
            System.err.println("r = " + d6);
            System.err.println("t = " + d * this.scalarTime);
            System.err.println("pdf    = " + d2);
            System.err.println("logPdf = " + d3);
        }
        return d3;
    }

    private void setupDensity() {
        double d = this.alpha.getParameterValue(0);
        double d2 = this.beta.getParameterValue(0);
        this.bifractionalDensity = new BifractionalDiffusionDensity(d, d2);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.alpha || variable == this.beta) {
            this.densityKnown = false;
        }
    }

    private double distanceEuclidean(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray2[i] - dArray[i];
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    @Override
    protected void calculatePrecisionInfo() {
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        this.densityKnown = false;
    }
}

