/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.SpaceTime;
import dr.geo.VisualizeKMLNumericalProbs;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;

public class VisualizeKMLJointProb
extends VisualizeKMLNumericalProbs {
    Point2D B;

    public VisualizeKMLJointProb(String string) {
        super(string);
        this.B = this.athens;
        if (this.rejector.reject(0.0, new double[]{this.B.getX(), this.B.getY()})) {
            throw new RuntimeException("The B position was rejected!");
        }
        System.out.println("Populating Athens transition probs");
        this.probs.populate(this.start, 50000, false);
        this.probs.populate(this.B, 50000, false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Shape shape;
        int n;
        int n2;
        System.out.println("entering paintComponent()");
        this.computeScales();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.5f));
        int n3 = this.probs.x(this.start.getX());
        int n4 = this.probs.y(this.start.getY());
        int n5 = this.probs.x(this.B.getX());
        int n6 = this.probs.y(this.B.getY());
        int n7 = 49;
        AffineTransform affineTransform = this.getFullTransform();
        double d = 0.0;
        double[][] dArray = new double[this.probs.latticeWidth][this.probs.latticeHeight];
        for (n2 = 0; n2 < this.probs.latticeWidth; ++n2) {
            for (n = 0; n < this.probs.latticeHeight; ++n) {
                dArray[n2][n] = this.probs.p(n3, n4, n2, n, n7) * this.probs.p(n5, n6, n2, n, n7);
                if (!(dArray[n2][n] > d)) continue;
                d = dArray[n2][n];
            }
        }
        System.out.println("Painting lattice probs");
        for (n2 = 0; n2 < this.probs.latticeWidth; ++n2) {
            for (n = 0; n < this.probs.latticeHeight; ++n) {
                double[] dArray2 = dArray[n2];
                int n8 = n;
                dArray2[n8] = dArray2[n8] / d;
                shape = new Rectangle2D.Double((double)n2 * this.probs.dx + this.probs.minx, (double)n * this.probs.dy + this.probs.miny, this.probs.dx, this.probs.dy);
                graphics.setColor(this.cf.getColor((float)dArray[n2][n]));
                graphics2D.fill(affineTransform.createTransformedShape(shape));
                graphics.setColor(Color.black);
                graphics2D.draw(affineTransform.createTransformedShape(shape));
            }
        }
        System.out.println("Painting shapes");
        for (Shape shape2 : this.shapes) {
            System.out.print(".");
            System.out.flush();
            shape = new GeneralPath(shape2);
            shape.transform(affineTransform);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.fill(shape);
        }
        graphics2D.setColor(Color.yellow);
        SpaceTime.paintDot(new SpaceTime(0.0, this.start), 4.0, affineTransform, graphics2D);
        SpaceTime.paintDot(new SpaceTime(0.0, this.B), 4.0, affineTransform, graphics2D);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Europe");
        jFrame.getContentPane().add("Center", new VisualizeKMLJointProb(stringArray[0]));
        jFrame.setSize(900, 900);
        jFrame.setVisible(true);
    }
}

