/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.model.GradientProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.math.distributions.GaussianProcessRandomGenerator;
import dr.math.distributions.MultivariateDistribution;

public class AutoRegressiveNormalDistribution
implements MultivariateDistribution,
GaussianProcessRandomGenerator,
GradientProvider,
HessianProvider {
    public static final String TYPE = "AutoRegressiveNormal";
    private final int dim;
    private final double marginal;
    private final double decay;
    private static final double logNormalize = -0.5 * Math.log(Math.PI * 2);

    public AutoRegressiveNormalDistribution(int n, double d, double d2) {
        this.dim = n;
        this.marginal = d;
        this.decay = d2;
        if (d != 1.0) {
            throw new IllegalArgumentException("Not yet implemented");
        }
        if (Math.abs(d2) >= 1.0) {
            throw new IllegalArgumentException("|Rho| must be < 1.0");
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private double getLogDet() {
        return Math.log(1.0 - this.decay * this.decay);
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        return new double[this.dim];
    }

    public double[] getPrecisionColumn(int n) {
        double[] dArray = new double[this.dim];
        if (n == 0) {
            dArray[0] = 1.0;
            dArray[1] = -this.decay;
        } else if (n == this.dim - 1) {
            dArray[this.dim - 2] = -this.decay;
            dArray[this.dim - 1] = 1.0;
        } else {
            dArray[n - 1] = -this.decay;
            dArray[n] = 1.0 + this.decay * this.decay;
            dArray[n + 1] = -this.decay;
        }
        return dArray;
    }

    @Override
    public double logPdf(double[] dArray) {
        int n;
        double d = dArray[0] * dArray[0] + dArray[this.dim - 1] * dArray[this.dim - 1];
        for (n = 1; n < this.dim - 1; ++n) {
            d += (1.0 + this.decay * this.decay) * dArray[n] * dArray[n];
        }
        for (n = 1; n < this.dim; ++n) {
            d -= 2.0 * this.decay * dArray[n - 1] * dArray[n];
        }
        double d2 = this.getLogDet();
        return (double)this.dim * logNormalize + 0.5 * (d2 - d);
    }

    private double[] scaledPrecisionVectorProduct(double[] dArray, double d) {
        assert (dArray.length == this.dim);
        double[] dArray2 = new double[this.dim];
        dArray2[0] = d * (dArray[0] - this.decay * dArray[1]);
        for (int i = 1; i < this.dim - 1; ++i) {
            dArray2[i] = d * (-this.decay * dArray[i - 1] + (1.0 + this.decay * this.decay) * dArray[i] - this.decay * dArray[i + 1]);
        }
        dArray2[this.dim - 1] = d * (-this.decay * dArray[this.dim - 2] + dArray[this.dim - 1]);
        return dArray2;
    }

    public double[] getDiagonal() {
        double[] dArray = new double[this.dim];
        dArray[0] = 1.0;
        for (int i = 1; i < this.dim - 1; ++i) {
            dArray[i] = 1.0 + this.decay * this.decay;
        }
        dArray[this.dim - 1] = 1.0;
        return dArray;
    }

    public double[] gradLogPdf(double[] dArray) {
        return this.scaledPrecisionVectorProduct(dArray, -1.0);
    }

    public double[] getPrecisionVectorProduct(double[] dArray) {
        return this.scaledPrecisionVectorProduct(dArray, 1.0);
    }

    private double[][] hessianLogPdf(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    private double[] diagonalHessianLogPdf(double[] dArray) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public Object nextRandom() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(Object object) {
        double[] dArray = (double[])object;
        return this.logPdf(dArray);
    }

    @Override
    public Likelihood getLikelihood() {
        return null;
    }

    @Override
    public int getDimension() {
        return this.dim;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        return this.gradLogPdf((double[])object);
    }

    @Override
    public double[][] getPrecisionMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        return this.diagonalHessianLogPdf((double[])object);
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        return this.hessianLogPdf((double[])object);
    }
}

