/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LAPACKkernel;
import no.uib.cipr.matrix.LowerSymmPackMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.SymmEVD;
import no.uib.cipr.matrix.UpperSymmPackMatrix;

public class SymmPackEVD
extends SymmEVD {
    private final double[] work;
    private final int[] iwork;
    private final BLASkernel.UpLo uplo;

    public SymmPackEVD(int n, boolean upper) {
        this(n, upper, true);
    }

    public SymmPackEVD(int n, boolean upper, boolean vectors) {
        super(n, vectors);
        this.uplo = upper ? BLASkernel.UpLo.Upper : BLASkernel.UpLo.Lower;
        double[] worksize = new double[1];
        int[] iworksize = new int[1];
        int info = Interface.lapack().spevd(this.job, this.uplo, n, new double[0], new double[0], new double[0], worksize, -1, iworksize, -1);
        int lwork = 0;
        int liwork = 0;
        if (info != 0) {
            if (this.job == LAPACKkernel.JobEig.All) {
                lwork = 1 + 6 * n + n * n;
                liwork = 3 + 5 * n;
            } else {
                lwork = 2 * n;
                liwork = 1;
            }
        } else {
            lwork = (int)worksize[0];
            liwork = iworksize[0];
        }
        lwork = Math.max(1, lwork);
        liwork = Math.max(1, liwork);
        this.work = new double[lwork];
        this.iwork = new int[liwork];
    }

    public static SymmPackEVD factorize(Matrix A) throws NotConvergedException {
        return new SymmPackEVD(A.numRows(), true).factor(new UpperSymmPackMatrix(A));
    }

    public SymmPackEVD factor(LowerSymmPackMatrix A) throws NotConvergedException {
        if (this.uplo != BLASkernel.UpLo.Lower) {
            throw new IllegalArgumentException("Eigenvalue computer configured for lower-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    public SymmPackEVD factor(UpperSymmPackMatrix A) throws NotConvergedException {
        if (this.uplo != BLASkernel.UpLo.Upper) {
            throw new IllegalArgumentException("Eigenvalue computer configured for upper-symmetrical matrices");
        }
        return this.factor(A, A.getData());
    }

    private SymmPackEVD factor(Matrix A, double[] data) throws NotConvergedException {
        if (A.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        int info = Interface.lapack().spevd(this.job, this.uplo, this.n, data, this.w, this.job == LAPACKkernel.JobEig.All ? this.Z.getData() : new double[]{}, this.work, this.work.length, this.iwork, this.iwork.length);
        if (info > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }
}

