/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.util;

import org.rosuda.util.Global;

public class Stopwatch {
    long ts_start = System.currentTimeMillis();
    long ts_stop = 0L;
    long ts_elapsed = -1L;
    boolean quiet = false;

    public Stopwatch() {
    }

    public Stopwatch(boolean beQuiet) {
        this();
        this.quiet = beQuiet;
    }

    public long stop() {
        this.ts_stop = System.currentTimeMillis();
        this.ts_elapsed = this.ts_stop - this.ts_start;
        return this.ts_elapsed;
    }

    public long start() {
        this.ts_start = System.currentTimeMillis();
        return this.ts_start;
    }

    public long last() {
        return this.ts_elapsed;
    }

    public long elapsed() {
        return System.currentTimeMillis() - this.ts_start;
    }

    public long restart() {
        this.stop();
        this.ts_start = this.ts_stop;
        return this.ts_elapsed;
    }

    public void profile() {
        this.restart();
        if (Global.PROFILE > 0) {
            System.out.println("time elapsed " + this.ts_elapsed + " ms");
        }
    }

    public void profile(String s) {
        this.restart();
        if (Global.PROFILE > 0) {
            System.out.println(s + " " + this.ts_elapsed + " ms" + (Global.PROFILE > 1 ? " [mem free " + Runtime.getRuntime().freeMemory() + "]" : ""));
        }
    }
}

