/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.seeding;

import com.sosnoski.util.hashmap.StringIntHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.seeding.SeedGenerator;
import uk.ac.rhul.cs.cl1.seeding.SeedIterator;
import uk.ac.rhul.cs.graph.Graph;

public class StreamBasedSeedGenerator
extends SeedGenerator {
    BufferedReader reader = null;
    String delimiters = " \t\r\n";

    public StreamBasedSeedGenerator(Graph graph, InputStream stream) {
        this(graph, new BufferedReader(new InputStreamReader(stream)));
    }

    public StreamBasedSeedGenerator(Graph graph, BufferedReader reader) {
        super(graph);
        this.reader = reader;
    }

    public String getDelimiters() {
        return this.delimiters;
    }

    public SeedIterator iterator() {
        return new IteratorImpl();
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }

    public int size() {
        return -1;
    }

    private class IteratorImpl
    extends SeedIterator {
        MutableNodeSet currentNodeSet = null;
        StringIntHashMap namesToIndices = new StringIntHashMap();

        public IteratorImpl() {
            int n = StreamBasedSeedGenerator.this.graph.getNodeCount();
            for (int i = 0; i < n; ++i) {
                this.namesToIndices.add(StreamBasedSeedGenerator.this.graph.getNodeName(i), i);
            }
            this.processLine();
        }

        private void processLine() {
            do {
                String line = null;
                this.currentNodeSet = new MutableNodeSet(StreamBasedSeedGenerator.this.graph);
                try {
                    line = StreamBasedSeedGenerator.this.reader.readLine();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    this.currentNodeSet = null;
                    return;
                }
                if (line == null) {
                    this.currentNodeSet = null;
                    return;
                }
                StringTokenizer st = new StringTokenizer(line, StreamBasedSeedGenerator.this.delimiters);
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    int idx = this.namesToIndices.get(name);
                    if (idx < 0) continue;
                    this.currentNodeSet.add(idx);
                }
            } while (this.currentNodeSet.size() == 0);
        }

        public boolean hasNext() {
            return this.currentNodeSet != null;
        }

        public MutableNodeSet next() {
            MutableNodeSet result = this.currentNodeSet;
            this.processLine();
            return result;
        }
    }
}

