/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.net;

public class Matrix {
    public static int InvertMatrix(double[][] matrix, double[][] inverted, int n) {
        int j;
        int i;
        double[] scales = new double[n];
        double[][] lu = new double[n][n];
        int[] ps = new int[n];
        if (Matrix.lu_decompose(matrix, n, scales, lu, ps) == 0) {
            return 0;
        }
        double[] b = new double[n];
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                b[j] = 0.0;
            }
            b[i] = 1.0;
            Matrix.lu_solve(inverted[i], b, n, lu, ps);
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < i; ++j) {
                double temp = inverted[i][j];
                inverted[i][j] = inverted[j][i];
                inverted[j][i] = temp;
            }
        }
        return 1;
    }

    public static void lu_solve(double[] x, double[] b, int n, double[][] lu, int[] ps) {
        int j;
        double dot;
        int i;
        for (i = 0; i < n; ++i) {
            dot = 0.0;
            for (j = 0; j < i; ++j) {
                dot += lu[ps[i]][j] * x[j];
            }
            x[i] = b[ps[i]] - dot;
        }
        for (i = n - 1; i >= 0; --i) {
            dot = 0.0;
            for (j = i + 1; j < n; ++j) {
                dot += lu[ps[i]][j] * x[j];
            }
            x[i] = (x[i] - dot) / lu[ps[i]][i];
        }
    }

    public static int lu_decompose(double[][] a, int n, double[] scales, double[][] lu, int[] ps) {
        double tempf;
        int j;
        double biggest;
        int i;
        int pivotindex = 0;
        for (i = 0; i < n; ++i) {
            biggest = 0.0;
            for (j = 0; j < n; ++j) {
                double d;
                double d2 = a[i][j];
                lu[i][j] = d2;
                tempf = Math.abs(d2);
                if (!(biggest < d)) continue;
                biggest = tempf;
            }
            if (biggest == 0.0) {
                scales[i] = 0.0;
                return 0;
            }
            scales[i] = 1.0 / biggest;
            ps[i] = i;
        }
        for (int k = 0; k < n - 1; ++k) {
            biggest = 0.0;
            for (i = k; i < n; ++i) {
                double d;
                tempf = Math.abs(lu[ps[i]][k]) * scales[ps[i]];
                if (!(biggest < d)) continue;
                biggest = tempf;
                pivotindex = i;
            }
            if (biggest == 0.0) {
                return 0;
            }
            if (pivotindex != k) {
                j = ps[k];
                ps[k] = ps[pivotindex];
                ps[pivotindex] = j;
            }
            double pivot = lu[ps[k]][k];
            for (i = k + 1; i < n; ++i) {
                double mult;
                lu[ps[i]][k] = mult = lu[ps[i]][k] / pivot;
                if (mult == 0.0) continue;
                for (j = k + 1; j < n; ++j) {
                    double[] dArray = lu[ps[i]];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - mult * lu[ps[k]][j];
                }
            }
        }
        if (lu[ps[n - 1]][n - 1] == 0.0) {
            return 0;
        }
        return 1;
    }
}

