/*
 * Decompiled with CFR 0.152.
 */
package javolution.xml;

import java.io.IOException;
import java.util.NoSuchElementException;
import javolution.lang.Text;
import javolution.lang.TextBuilder;
import javolution.lang.TypeFormat;
import javolution.util.FastComparator;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastTable;
import javolution.xml.CharacterData;
import javolution.xml.FormatAttributes;
import javolution.xml.ObjectWriter;
import javolution.xml.XmlException;
import javolution.xml.XmlFormat;
import javolution.xml.pull.XmlPullParser;
import javolution.xml.pull.XmlPullParserException;
import javolution.xml.pull.XmlPullParserImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlElement {
    ContentHandler _formatHandler;
    final XmlPullParserImpl _parser;
    private Object _object;
    private Class _objectClass;
    private boolean _isParserAtNext;
    private boolean _isClosure;
    final FormatAttributes _formatAttributes;
    private final TextBuilder _textBuilder = new TextBuilder();
    private CharSequence _elemName;
    final FastTable _packagePrefixes = new FastTable();
    boolean _areReferencesEnabled;
    boolean _expandReferences = false;
    boolean _isClassIdentifierEnabled;
    private final FastMap _idToObject;
    private final FastMap _objectToId;
    private final FastTable _formatStack;
    private final FastList _formatContent = new FastList(){

        public void addLast(Object object) {
            XmlElement.this.add(object);
        }
    };
    private final FastTable _parseContents;
    private int _parseContentIndex;

    XmlElement(XmlPullParserImpl xmlPullParserImpl) {
        if (xmlPullParserImpl != null) {
            this._parser = xmlPullParserImpl;
            this._parseContents = new FastTable();
            this._formatAttributes = null;
            this._idToObject = new FastMap();
            this._objectToId = null;
            this._formatStack = null;
        } else {
            this._parser = null;
            this._parseContents = null;
            this._formatAttributes = new FormatAttributes();
            this._idToObject = null;
            this._objectToId = new FastMap().setKeyComparator(FastComparator.IDENTITY);
            this._formatStack = (FastTable)new FastTable().setValueComparator(FastComparator.IDENTITY);
        }
    }

    public <T> T object() throws XmlException {
        if (this._object == null) {
            if (this._objectClass == null) {
                throw new XmlException("Object type unknown, cannot use reflection");
            }
            try {
                this._object = this._objectClass.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XmlException(this._objectClass + " default constructor inaccessible");
            }
            catch (InstantiationException instantiationException) {
                throw new XmlException(this._objectClass + " default constructor throws an exception");
            }
        }
        return (T)this._object;
    }

    public Class objectClass() {
        return this._objectClass;
    }

    public ContentHandler formatter() {
        return this._formatHandler;
    }

    public void add(Object object) {
        try {
            if (object == null) {
                object = XmlFormat.NULL;
            }
            if (this._elemName != null) {
                this.flushStart();
            }
            if (object instanceof CharacterData) {
                CharacterData characterData = (CharacterData)object;
                this._formatHandler.characters(characterData.chars(), characterData.offset(), characterData.length());
                return;
            }
            this._objectClass = object.getClass();
            Class<?> clazz = this._objectClass;
            XmlFormat<?> xmlFormat = XmlFormat.getInstance(clazz);
            String string = xmlFormat.defaultName();
            if (string != null) {
                this._objectClass = object.getClass();
                String string2 = XmlFormat.aliasFor(this._objectClass);
                if (this._isClassIdentifierEnabled) {
                    this._formatAttributes.addAttribute("j:class", string2 != null ? XmlElement.toCharSeq(string2) : XmlElement.toCharSeq(this._objectClass.getName()));
                }
                CharSequence charSequence = this._elemName = XmlElement.toCharSeq(string);
                this.format(object, xmlFormat);
                if (this._elemName != null) {
                    this.flushStart();
                }
                this._formatHandler.endElement(Text.EMPTY, charSequence, charSequence);
                return;
            }
            CharSequence charSequence = this._elemName = this.qNameFor(clazz);
            this.format(object, xmlFormat);
            if (this._elemName != null) {
                this.flushStart();
            }
            if (charSequence == this._textBuilder) {
                charSequence = this.qNameFor(clazz);
            }
            this._formatHandler.endElement(Text.EMPTY, charSequence, charSequence);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
    }

    public void add(Object object, String string) {
        if (object == null) {
            return;
        }
        try {
            if (this._elemName != null) {
                this.flushStart();
            }
            this._objectClass = object.getClass();
            String string2 = XmlFormat.aliasFor(this._objectClass);
            if (this._isClassIdentifierEnabled) {
                this._formatAttributes.addAttribute("j:class", string2 != null ? XmlElement.toCharSeq(string2) : XmlElement.toCharSeq(this._objectClass.getName()));
            }
            CharSequence charSequence = this._elemName = XmlElement.toCharSeq(string);
            this.format(object, XmlFormat.getInstance(this._objectClass));
            if (this._elemName != null) {
                this.flushStart();
            }
            this._formatHandler.endElement(Text.EMPTY, charSequence, charSequence);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
    }

    public void add(Object object, String string, XmlFormat xmlFormat) {
        if (object == null) {
            return;
        }
        try {
            if (this._elemName != null) {
                this.flushStart();
            }
            CharSequence charSequence = this._elemName = XmlElement.toCharSeq(string);
            this.format(object, xmlFormat);
            if (this._elemName != null) {
                this.flushStart();
            }
            this._formatHandler.endElement(Text.EMPTY, charSequence, charSequence);
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
    }

    public TextBuilder newAttribute(String string) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        return this._formatAttributes.newAttribute(string);
    }

    public void setAttribute(String string, CharSequence charSequence) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if (charSequence == null) {
            return;
        }
        this._formatAttributes.addAttribute(string, charSequence);
    }

    public void setAttribute(String string, String string2) {
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if (string2 == null) {
            return;
        }
        CharSequence charSequence = XmlElement.toCharSeq(string2);
        this._formatAttributes.addAttribute(string, charSequence);
    }

    public void setAttribute(String string, boolean bl) {
        this.newAttribute(string).append(bl);
    }

    public void setAttribute(String string, int n) {
        this.newAttribute(string).append(n);
    }

    public void setAttribute(String string, long l) {
        this.newAttribute(string).append(l);
    }

    public void setAttribute(String string, float f) {
        this.newAttribute(string).append(f);
    }

    public void setAttribute(String string, double d) {
        this.newAttribute(string).append(d);
    }

    public void setAttribute(String string, Boolean bl) {
        if (bl == null) {
            return;
        }
        this.newAttribute(string).append(bl);
    }

    public void setAttribute(String string, Byte by) {
        if (by == null) {
            return;
        }
        this.newAttribute(string).append(by.byteValue());
    }

    public void setAttribute(String string, Short s) {
        if (s == null) {
            return;
        }
        this.newAttribute(string).append(s.shortValue());
    }

    public void setAttribute(String string, Integer n) {
        if (n == null) {
            return;
        }
        this.newAttribute(string).append(n);
    }

    public void setAttribute(String string, Long l) {
        if (l == null) {
            return;
        }
        this.newAttribute(string).append(l);
    }

    public void setAttribute(String string, Float f) {
        if (f == null) {
            return;
        }
        this.newAttribute(string).append(f.floatValue());
    }

    public void setAttribute(String string, Double d) {
        if (d == null) {
            return;
        }
        this.newAttribute(string).append(d);
    }

    public void removeAttribute(String string) {
        int n;
        if (this._formatAttributes == null || this._elemName == null) {
            this.attributeSettingError();
        }
        if ((n = this._formatAttributes.getIndex(string)) >= 0) {
            this._formatAttributes.remove(n);
        }
    }

    public XmlPullParser parser() {
        return this._parser;
    }

    public boolean hasNext() {
        if (!this._isParserAtNext) {
            this.nextToken();
            this._isParserAtNext = true;
        }
        return !this._isClosure;
    }

    public <T> T getNext() {
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this._isParserAtNext = false;
            if (this._parser.getEventType() == 2) {
                Object object;
                Object object2;
                CharSequence charSequence = this._parser.getSaxAttributes().getValue("j:class");
                if (charSequence == null) {
                    object2 = this._parser.getNamespace();
                    object = this._parser.getName();
                    this._objectClass = object2.length() > 0 && !object2.equals(ObjectWriter.JAVOLUTION_URI) ? XmlFormat.classFor((CharSequence)object2, (CharSequence)object) : XmlFormat.classFor((CharSequence)object);
                } else {
                    this._objectClass = XmlFormat.classFor(charSequence);
                }
                object2 = XmlFormat.getInstance(this._objectClass);
                ++this._parseContentIndex;
                object = this.parse((XmlFormat)object2);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)object;
            }
            CharacterData characterData = CharacterData.valueOf(this._parser.getText());
            return (T)characterData;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlException(xmlPullParserException);
        }
    }

    public <T> T get(String string) {
        try {
            if (this.hasNext() && this._parser.getEventType() == 2 && this._parser.getQName().equals(string)) {
                this._isParserAtNext = false;
                CharSequence charSequence = this._parser.getSaxAttributes().getValue("j:class");
                if (charSequence == null) {
                    throw new XmlException("\"j:class\" attribute missing");
                }
                this._objectClass = XmlFormat.classFor(charSequence);
                XmlFormat xmlFormat = XmlFormat.getInstance(this._objectClass);
                ++this._parseContentIndex;
                Object object = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)object;
            }
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlException(xmlPullParserException);
        }
    }

    public <T> T get(String string, XmlFormat xmlFormat) {
        try {
            if (this.hasNext() && this._parser.getEventType() == 2 && this._parser.getQName().equals(string)) {
                this._isParserAtNext = false;
                ++this._parseContentIndex;
                Object object = this.parse(xmlFormat);
                --this._parseContentIndex;
                if (this.hasNext()) {
                    this.incompleteReadError();
                }
                this._isParserAtNext = false;
                return (T)object;
            }
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlException(xmlPullParserException);
        }
    }

    public Attributes getAttributes() {
        if (this._formatAttributes != null) {
            return this._formatAttributes;
        }
        if (this._isParserAtNext) {
            throw new XmlException("Attributes should be read before any content");
        }
        return this._parser.getSaxAttributes();
    }

    public CharSequence getAttribute(String string) {
        return this.getAttributes().getValue(string);
    }

    public boolean isAttribute(String string) {
        return this.getAttributes().getIndex(string) >= 0;
    }

    public CharSequence getAttribute(String string, CharSequence charSequence) {
        CharSequence charSequence2 = this.getAttributes().getValue(string);
        return charSequence2 != null ? charSequence2 : charSequence;
    }

    public String getAttribute(String string, String string2) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? ((Object)charSequence).toString() : string2;
    }

    public boolean getAttribute(String string, boolean bl) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? TypeFormat.parseBoolean(charSequence) : bl;
    }

    public int getAttribute(String string, int n) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? TypeFormat.parseInt(charSequence) : n;
    }

    public long getAttribute(String string, long l) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? TypeFormat.parseLong(charSequence) : l;
    }

    public float getAttribute(String string, float f) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? (float)TypeFormat.parseDouble(charSequence) : f;
    }

    public double getAttribute(String string, double d) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? TypeFormat.parseDouble(charSequence) : d;
    }

    public Boolean getAttribute(String string, Boolean bl) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Boolean(TypeFormat.parseBoolean(charSequence)) : bl;
    }

    public Byte getAttribute(String string, Byte by) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Byte(TypeFormat.parseByte(charSequence)) : by;
    }

    public Short getAttribute(String string, Short s) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Short(TypeFormat.parseShort(charSequence)) : s;
    }

    public Integer getAttribute(String string, Integer n) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Integer(TypeFormat.parseInt(charSequence)) : n;
    }

    public Long getAttribute(String string, Long l) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Long(TypeFormat.parseLong(charSequence)) : l;
    }

    public Float getAttribute(String string, Float f) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Float(TypeFormat.parseFloat(charSequence)) : f;
    }

    public Double getAttribute(String string, Double d) {
        CharSequence charSequence = this.getAttributes().getValue(string);
        return charSequence != null ? new Double(TypeFormat.parseDouble(charSequence)) : d;
    }

    void reset() {
        this._elemName = null;
        this._isClosure = false;
        this._object = null;
        this._objectClass = null;
        this._textBuilder.reset();
        if (this._parser != null) {
            this._parser.reset();
            for (int i = 0; i < this._parseContents.size(); ++i) {
                FastList fastList = (FastList)this._parseContents.get(i);
                fastList.reset();
            }
            this._parseContentIndex = 0;
            this._isParserAtNext = false;
            this._idToObject.clear();
        } else {
            this._formatAttributes.reset();
            this._formatContent.reset();
            this._formatHandler = null;
            this._objectToId.clear();
            this._formatStack.clear();
        }
    }

    private void flushStart() throws SAXException {
        this._formatHandler.startElement(Text.EMPTY, this._elemName, this._elemName, this._formatAttributes);
        this._formatAttributes.reset();
        this._elemName = null;
    }

    private int nextToken() {
        try {
            while (true) {
                int n = this._parser.nextToken();
                switch (n) {
                    case 2: 
                    case 5: {
                        this._isClosure = false;
                        return n;
                    }
                    case 1: 
                    case 3: {
                        this._isClosure = true;
                        return n;
                    }
                    case 4: {
                        if (this._parser.isWhitespace()) break;
                        this._isClosure = false;
                        return n;
                    }
                }
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new XmlException(xmlPullParserException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    private void attributeSettingError() {
        if (this._formatAttributes == null) {
            throw new XmlException("Attributes cannot be set during parsing");
        }
        if (this._elemName == null) {
            throw new XmlException("Attributes should be set before adding nested elements");
        }
        throw new XmlException();
    }

    private void incompleteReadError() throws XmlPullParserException {
        if (this._parser.getEventType() == 2) {
            throw new XmlException("Incomplete read error (nested " + this._parser.getQName() + " has not been read)");
        }
        throw new XmlException("Incomplete read error (character datahas not been read)");
    }

    private CharSequence qNameFor(Class clazz) {
        String string = XmlFormat.aliasFor(clazz);
        String string2 = string != null ? string : clazz.getName();
        String string3 = null;
        String string4 = "";
        int n = 0;
        while (n < this._packagePrefixes.size()) {
            String string5;
            String string6 = (String)this._packagePrefixes.get(n++);
            if (!string2.startsWith(string5 = (String)this._packagePrefixes.get(n++)) || string5.length() < string4.length() || string != null && !string6.equals("j")) continue;
            string3 = string6;
            string4 = string5;
        }
        if (string3 != null) {
            this._textBuilder.reset();
            if (string3.length() > 0) {
                this._textBuilder.append(string3).append(':');
            }
            if (string4.length() > 0) {
                this._textBuilder.append(string2, string4.length() + 1, string2.length());
            } else {
                this._textBuilder.append(string2);
            }
            return this._textBuilder;
        }
        return XmlElement.toCharSeq(string2);
    }

    private static CharSequence toCharSeq(Object object) {
        if (object instanceof CharSequence) {
            return (CharSequence)object;
        }
        return Text.valueOf((String)object);
    }

    private Object parse(XmlFormat xmlFormat) {
        if (this._areReferencesEnabled && xmlFormat.identifier(false) != null) {
            CharSequence charSequence = this.getAttribute(xmlFormat.identifier(true));
            if (charSequence != null) {
                Object v = this._idToObject.get(charSequence);
                if (v == null) {
                    throw new IllegalStateException("Reference " + charSequence + " not found.");
                }
                int n = this._parser.getDepth();
                while (this.nextToken() != 3 && this._parser.getDepth() <= n) {
                }
                this._isParserAtNext = true;
                return v;
            }
            this._object = null;
            this._object = xmlFormat.allocate(this);
            Object t = this._object;
            CharSequence charSequence2 = this.getAttribute(xmlFormat.identifier(false));
            if (charSequence2 != null) {
                if (t != null) {
                    this._idToObject.put(Text.valueOf(charSequence2), t);
                    if (xmlFormat.parse(this) != t) {
                        throw new XmlException("Parse should return xml.object() when allocate(xml) != null");
                    }
                    return t;
                }
                t = xmlFormat.parse(this);
                this._idToObject.put(Text.valueOf(charSequence2), t);
                return t;
            }
            this._areReferencesEnabled = false;
            t = xmlFormat.parse(this);
            this._areReferencesEnabled = true;
            return t;
        }
        this._object = null;
        this._object = xmlFormat.allocate(this);
        Object object = this._object;
        if (object != null) {
            if (xmlFormat.parse(this) != object) {
                throw new XmlException("Parse should return xml.object() when allocate(xml) != null");
            }
            return object;
        }
        return xmlFormat.parse(this);
    }

    private void format(Object object, XmlFormat xmlFormat) {
        if (this._areReferencesEnabled && xmlFormat.identifier(false) != null) {
            Text text = (Text)this._objectToId.get(object);
            if (text != null) {
                this.setAttribute(xmlFormat.identifier(true), text);
            } else {
                Text text2 = Text.valueOf(this._objectToId.size());
                this._objectToId.put(object, text2);
                this.setAttribute(xmlFormat.identifier(false), text2);
            }
            if (text == null || this._expandReferences && !this._formatStack.contains(object)) {
                this._formatStack.addLast(object);
                xmlFormat.format(object, this);
                this._formatStack.removeLast();
            }
            return;
        }
        xmlFormat.format(object, this);
    }

    public FastList getContent() {
        if (this._parser != null) {
            while (this._parseContents.size() <= this._parseContentIndex) {
                this._parseContents.add(new FastList());
            }
            FastList fastList = (FastList)this._parseContents.get(this._parseContentIndex);
            while (this.hasNext()) {
                fastList.add(this.getNext());
            }
            return fastList;
        }
        return this._formatContent;
    }
}

