/*
 * Decompiled with CFR 0.152.
 */
package com.miraisolutions.xlconnect.utils;

import com.miraisolutions.xlconnect.utils.RepeatableIterable;
import java.util.Iterator;

public class SimpleSequence<T>
implements RepeatableIterable<T> {
    private T[] values;

    public static SimpleSequence<String> create(String[] values) {
        return new SimpleSequence<String>(values);
    }

    public static SimpleSequence<Integer> create(int[] values) {
        Integer[] newValues = new Integer[values.length];
        int i = 0;
        for (int value : values) {
            newValues[i++] = value;
        }
        return new SimpleSequence<Integer>(newValues);
    }

    public static SimpleSequence<Double> create(double[] values) {
        Double[] newValues = new Double[values.length];
        int i = 0;
        for (double value : values) {
            newValues[i++] = value;
        }
        return new SimpleSequence<Double>(newValues);
    }

    public SimpleSequence(T[] values) {
        this.values = values;
    }

    @Override
    public Iterator<T> iterator(boolean repeating) {
        return new SequenceIterator(repeating);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(false);
    }

    private class SequenceIterator
    implements Iterator<T> {
        private boolean repeating = false;
        private int i = 0;

        public SequenceIterator(boolean repeating) {
            this.repeating = repeating;
        }

        @Override
        public boolean hasNext() {
            return this.repeating || this.i < SimpleSequence.this.values.length;
        }

        @Override
        public T next() {
            Object result = SimpleSequence.this.values[this.i];
            ++this.i;
            if (this.repeating && this.i >= SimpleSequence.this.length()) {
                this.i = 0;
            }
            return result;
        }

        @Override
        public void remove() {
        }
    }
}

