## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set(
  comment = "#>",
  collapse = TRUE,
  warning = FALSE,
  message = FALSE
)

## -----------------------------------------------------------------------------
library("geojson")

## -----------------------------------------------------------------------------
x <- '{
 "type": "GeometryCollection",
 "geometries": [
   {
     "type": "Point",
     "coordinates": [100.0, 0.0]
   },
   {
     "type": "LineString",
     "coordinates": [ [101.0, 0.0], [102.0, 1.0] ]
   }
  ]
}'
(y <- geometrycollection(x))

## -----------------------------------------------------------------------------
y[[1]]

## -----------------------------------------------------------------------------
geo_type(y)

## -----------------------------------------------------------------------------
geo_pretty(y)

## -----------------------------------------------------------------------------
geo_write(y, f <- tempfile(fileext = ".geojson"))
jsonlite::fromJSON(f, FALSE)

## ----echo=FALSE---------------------------------------------------------------
unlink(f)

## -----------------------------------------------------------------------------
x <- '{ "type": "LineString", "coordinates": [ [100.0, 0.0], [101.0, 1.0] ]}'
res <- linestring(x) %>% feature() %>% properties_add(population = 1000)
res

## -----------------------------------------------------------------------------
properties_get(res, property = 'population')

## -----------------------------------------------------------------------------
crs <- '{
  "type": "name",
  "properties": {
     "name": "urn:ogc:def:crs:OGC:1.3:CRS84"
  }
}'
z <- x %>% feature() %>% crs_add(crs)
z

## -----------------------------------------------------------------------------
crs_get(z)

## -----------------------------------------------------------------------------
tt <- x %>% feature() %>% bbox_add()
tt

## -----------------------------------------------------------------------------
bbox_get(tt)

## -----------------------------------------------------------------------------
x <- '{ "type": "Point", "coordinates": [100.0, 0.0] }'
(pt <- point(x))

## -----------------------------------------------------------------------------
library("tibble")
data_frame(a = 1:5, b = list(pt))

## -----------------------------------------------------------------------------
x <- '{ "type": "MultiLineString",
  "coordinates": [ [ [100.0, 0.0], [101.0, 1.0] ], [ [102.0, 2.0], [103.0, 3.0] ] ] }'
(mls <- multilinestring(x))

## -----------------------------------------------------------------------------
data_frame(a = 1:5, b = list(mls))

## -----------------------------------------------------------------------------
(df <- data_frame(a = 1:5, b = list(pt), c = list(mls)))

## -----------------------------------------------------------------------------
df$b
df$b[[1]]

