/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.TriangularDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class TriangularGen
extends RandomVariateGen {
    private double a;
    private double b;
    private double m;

    public TriangularGen(RandomStream s, double a, double b, double m) {
        super(s, new TriangularDist(a, b, m));
        this.setParams(a, b, m);
    }

    public TriangularGen(RandomStream s, double m) {
        this(s, 0.0, 1.0, m);
    }

    public TriangularGen(RandomStream s, TriangularDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getA(), dist.getB(), dist.getM());
        }
    }

    public static double nextDouble(RandomStream s, double a, double b, double m) {
        return TriangularDist.inverseF(a, b, m, s.nextDouble());
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getM() {
        return this.m;
    }

    private void setParams(double a, double b, double m) {
        if (a == 0.0 && b == 1.0 && (m < 0.0 || m > 1.0)) {
            throw new IllegalArgumentException("m is not in [0,1]");
        }
        if (a >= b) {
            throw new IllegalArgumentException("a >= b");
        }
        if (m < a || m > b) {
            throw new IllegalArgumentException("m is not in [a,b]");
        }
        this.a = a;
        this.b = b;
        this.m = m;
    }
}

