/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.ibase.Commander;
import org.rosuda.ibase.Notifier;
import org.rosuda.ibase.NotifyMsg;
import org.rosuda.ibase.SVarSet;

public class SMarker
extends Notifier
implements Commander {
    int[] mask;
    int msize;
    Vector list;
    int maxMark;
    int secMarked = 0;
    SVarSet masterSet;
    public static final int MASK_PRIMARY = 0;
    public static final int MASK_SECONDARY = 1;
    public static final int MASK_RAW = 2;

    public SMarker(int n) {
        this.mask = new int[n];
        this.list = new Vector();
        this.msize = n;
        this.masterSet = null;
        this.maxMark = 1;
    }

    public void resize(int n) {
        if (n < this.msize) {
            return;
        }
        this.list.removeAllElements();
        this.mask = new int[n];
        this.list = new Vector();
        this.msize = n;
        this.masterSet = null;
        this.maxMark = 1;
        this.secMarked = 0;
    }

    public int size() {
        return this.msize;
    }

    public int marked() {
        return this.list.size();
    }

    public int get(int n) {
        return n < 0 || n >= this.msize ? 0 : ((this.mask[n] & 1) == 1 ? -1 : this.mask[n] >> 1);
    }

    public int getSec(int n) {
        return n < 0 || n >= this.msize ? 0 : this.mask[n] >> 1;
    }

    public boolean at(int n) {
        return n < 0 || n >= this.msize ? false : (this.mask[n] & 1) == 1;
    }

    public Vector getList() {
        return this.list;
    }

    public int[] getSelectedIDs() {
        int n = this.list.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = (Integer)this.list.elementAt(i);
        }
        return nArray;
    }

    public int[] getMaskCopy(int n) {
        int n2;
        int[] nArray = new int[this.mask.length];
        System.arraycopy(this.mask, 0, nArray, 0, this.mask.length);
        if (n == 0) {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if ((nArray[n2] & 1) != 1) continue;
                nArray[n2] = -1;
            }
        }
        if (n == 1) {
            n2 = 0;
            while (n2 < nArray.length) {
                int n3 = n2++;
                nArray[n3] = nArray[n3] >> 1;
            }
        }
        return nArray;
    }

    public void set(int n, boolean bl) {
        if (n < 0 || n >= this.msize) {
            return;
        }
        if (bl == ((this.mask[n] & 1) == 1)) {
            return;
        }
        if ((this.mask[n] & 1) == 0 && bl) {
            this.list.addElement(new Integer(n));
        }
        if ((this.mask[n] & 1) == 1 && !bl) {
            this.list.removeElement(new Integer(n));
        }
        int n2 = n;
        this.mask[n2] = this.mask[n2] ^ 1;
    }

    public void setSec(int n, int n2) {
        if (n2 > this.maxMark) {
            this.maxMark = n2;
        }
        if ((n2 <<= 1) > 0 && this.mask[n] >> 1 == 0) {
            ++this.secMarked;
        } else if (n2 == 0 && this.mask[n] >> 1 > 0) {
            --this.secMarked;
        }
        this.mask[n] = this.mask[n] & 1 | n2;
    }

    public void setSelected(int n) {
        if (n > this.maxMark) {
            this.maxMark = n;
        }
        n <<= 1;
        Enumeration enumeration = this.list.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 == null) continue;
            int n3 = n2;
            if (n > 0 && this.mask[n3] >> 1 == 0) {
                ++this.secMarked;
            } else if (n == 0 && this.mask[n3] >> 1 > 0) {
                --this.secMarked;
            }
            this.mask[n3] = this.mask[n3] & 1 | n;
        }
    }

    public int getMaxMark() {
        return this.maxMark;
    }

    public int getSecCount() {
        return this.secMarked;
    }

    public Enumeration elements() {
        return this.list.elements();
    }

    public void selectNone() {
        int n = 0;
        while (n < this.msize) {
            int n2 = n++;
            this.mask[n2] = this.mask[n2] & 0xFFFFFFFE;
        }
        this.list.removeAllElements();
    }

    public void selectAll() {
        this.list.removeAllElements();
        int n = 0;
        while (n < this.msize) {
            this.list.addElement(new Integer(n));
            int n2 = n++;
            this.mask[n2] = this.mask[n2] | 1;
        }
    }

    public void selectInverse() {
        for (int i = 0; i < this.msize; ++i) {
            if ((this.mask[i] & 1) == 0) {
                this.list.addElement(new Integer(i));
                int n = i;
                this.mask[n] = this.mask[n] | 1;
                continue;
            }
            this.list.removeElement(new Integer(i));
            int n = i;
            this.mask[n] = this.mask[n] & 0xFFFFFFFE;
        }
    }

    public void resetSec() {
        if (this.secMarked > 0) {
            int n = 0;
            while (n < this.msize) {
                int n2 = n++;
                this.mask[n2] = this.mask[n2] & 1;
            }
        }
        this.maxMark = 1;
        this.secMarked = 0;
    }

    public SVarSet getMasterSet() {
        return this.masterSet;
    }

    public Object run(Object object, String string) {
        if (string == "selAll") {
            this.selectAll();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        if (string == "selNone") {
            this.selectNone();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        if (string == "selInv") {
            this.selectInverse();
            this.NotifyAll(new NotifyMsg(this, 4096));
        }
        return null;
    }

    public void setSecBySelection(int n, int n2) {
        int n3;
        boolean[] blArray = new boolean[this.mask.length];
        int[] nArray = this.getSelectedIDs();
        for (n3 = 0; n3 < nArray.length; ++n3) {
            this.setSec(nArray[n3], n);
            blArray[nArray[n3]] = true;
        }
        for (n3 = 0; n3 < blArray.length; ++n3) {
            if (blArray[n3]) continue;
            this.setSec(n3, n2);
        }
    }
}

