### R code from vignette source 'robflreg.Rnw'

###################################################
### code chunk number 1: robflreg.Rnw:148-157
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
Y <- sim.data$Y
out.indx <- sim.data$out.indx
plot(Y[-out.indx,], type = "p", pch = 16, xlab = "Index", ylab = "",
main = "Response", ylim = range(Y))
points(out.indx, Y[out.indx,], type = "p", pch = 16, col = "blue")


###################################################
### code chunk number 2: robflreg.Rnw:160-170
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX1 <- fdata(X[[1]], argvals = seq(0, 1, length.out = 101))
plot(fX1[-out.indx,], lty = 1, ylab = "", xlab = "",
main = expression(X[1](s)), mgp = c(2, 0.5, 0), ylim = range(fX1))
lines(fX1[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 3: robflreg.Rnw:173-183
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX2 <- fdata(X[[2]], argvals = seq(0, 1, length.out = 101))
plot(fX2[-out.indx,], lty = 1, ylab = "", xlab = "",
main = expression(X[2](s)), mgp = c(2, 0.5, 0), ylim = range(fX2))
lines(fX2[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 4: robflreg.Rnw:186-196
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX3 <- fdata(X[[3]], argvals = seq(0, 1, length.out = 101))
plot(fX3[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[3](s)), mgp = c(2, 0.5, 0), ylim = range(fX3))
lines(fX3[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 5: robflreg.Rnw:199-209
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX4 <- fdata(X[[4]], argvals = seq(0, 1, length.out = 101))
plot(fX4[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[4](s)), mgp = c(2, 0.5, 0), ylim = range(fX4))
lines(fX4[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 6: robflreg.Rnw:212-222
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 5, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX5 <- fdata(X[[5]], argvals = seq(0, 1, length.out = 101))
plot(fX5[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[5](s)), mgp = c(2, 0.5, 0), ylim = range(fX5))
lines(fX5[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 7: robflreg.Rnw:305-315
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
Y <- sim.data$Y
fY <- fdata(Y, argvals = seq(0, 1, length.out = 101))
plot(fY[-out.indx,], lty = 1, ylab = "", xlab = "",
main = "Response", mgp = c(2, 0.5, 0), ylim = range(fY))
lines(fY[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 8: robflreg.Rnw:318-328
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX1 <- fdata(X[[1]], argvals = seq(0, 1, length.out = 101))
plot(fX1[-out.indx,], lty = 1, ylab = "", xlab = "",
main = expression(X[1](s)), mgp = c(2, 0.5, 0), ylim = range(fX1))
lines(fX1[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 9: robflreg.Rnw:331-341
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX2 <- fdata(X[[2]], argvals = seq(0, 1, length.out = 101))
plot(fX2[-out.indx,], lty = 1, ylab = "", xlab = "",
main = expression(X[2](s)), mgp = c(2, 0.5, 0), ylim = range(fX2))
lines(fX2[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 10: robflreg.Rnw:344-354
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX3 <- fdata(X[[3]], argvals = seq(0, 1, length.out = 101))
plot(fX3[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[3](s)), mgp = c(2, 0.5, 0), ylim = range(fX3))
lines(fX3[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 11: robflreg.Rnw:357-367
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX4 <- fdata(X[[4]], argvals = seq(0, 1, length.out = 101))
plot(fX4[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[4](s)), mgp = c(2, 0.5, 0), ylim = range(fX4))
lines(fX4[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 12: robflreg.Rnw:370-380
###################################################
library(robflreg)
library(fda.usc)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101, out.p = 0.1)
out.indx <- sim.data$out.indx
X <- sim.data$X
fX5 <- fdata(X[[5]], argvals = seq(0, 1, length.out = 101))
plot(fX5[-out.indx,], lty = 1, ylab = "", xlab = "Grid point",
main = expression(X[5](s)), mgp = c(2, 0.5, 0), ylim = range(fX5))
lines(fX5[out.indx,], lty = 1, col = "grey")


###################################################
### code chunk number 13: robflreg.Rnw:470-487
###################################################
library(robflreg)
# Generate a dataset with five functional predictors and 200
# observations at 101 equally spaced point in the interval [0, 1]
# for each variable for the function-on-function regression model
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 5, n.curve = 200, n.gp = 101)
# Response variable
Y <- sim.data$Y
gpY <- seq(0, 1, length.out = 101) # grid points

# Perform robust functional principal component analysis on the response variable Y
rob.fpca <- getPCA(data = Y, nbasis = 20, ncomp = 4, gp = gpY, emodel = "robust")

# Principal components
PCs <- rob.fpca$PCAcoef

plot(PCs, xlab = "Grid point", ylab = "Values")


###################################################
### code chunk number 14: robflreg.Rnw:576-586
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 3, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gp <- rep(list(seq(0, 1, length.out = 101)), 3) # grid points of Xs
model.fit <- rob.sf.reg(Y, X, emodel = "robust", fmodel = "tau", gp = gp)
coefs <- get.sf.coeffs(model.fit)
plot_sf_coeffs(object = coefs, b = 1)


###################################################
### code chunk number 15: robflreg.Rnw:589-599
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 3, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gp <- rep(list(seq(0, 1, length.out = 101)), 3) # grid points of Xs
model.fit <- rob.sf.reg(Y, X, emodel = "robust", fmodel = "tau", gp = gp)
coefs <- get.sf.coeffs(model.fit)
plot_sf_coeffs(object = coefs, b = 2)


###################################################
### code chunk number 16: robflreg.Rnw:602-612
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.sf.data(n = 400, n.pred = 3, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gp <- rep(list(seq(0, 1, length.out = 101)), 3) # grid points of Xs
model.fit <- rob.sf.reg(Y, X, emodel = "robust", fmodel = "tau", gp = gp)
coefs <- get.sf.coeffs(model.fit)
plot_sf_coeffs(object = coefs, b = 3)


###################################################
### code chunk number 17: robflreg.Rnw:704-716
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 3, n.curve = 200, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gpY = seq(0, 1, length.out = 101)
gpX <- rep(list(seq(0, 1, length.out = 101)), 3)
model.fit <- rob.ff.reg(Y, X, model = "full", emodel = "robust",
fmodel = "MM", gpY = gpY, gpX = gpX)
coefs <- get.ff.coeffs(model.fit)
plot_ff_coeffs(object = coefs, b = 1)


###################################################
### code chunk number 18: robflreg.Rnw:719-731
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 3, n.curve = 200, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gpY = seq(0, 1, length.out = 101)
gpX <- rep(list(seq(0, 1, length.out = 101)), 3)
model.fit <- rob.ff.reg(Y, X, model = "full", emodel = "robust",
fmodel = "MM", gpY = gpY, gpX = gpX)
coefs <- get.ff.coeffs(model.fit)
plot_ff_coeffs(object = coefs, b = 2)


###################################################
### code chunk number 19: robflreg.Rnw:734-746
###################################################
library(robflreg)
set.seed(2022)
sim.data <- generate.ff.data(n.pred = 3, n.curve = 200, n.gp = 101)
Y <- sim.data$Y
X <- sim.data$X

gpY = seq(0, 1, length.out = 101)
gpX <- rep(list(seq(0, 1, length.out = 101)), 3)
model.fit <- rob.ff.reg(Y, X, model = "full", emodel = "robust",
fmodel = "MM", gpY = gpY, gpX = gpX)
coefs <- get.ff.coeffs(model.fit)
plot_ff_coeffs(object = coefs, b = 3)


