/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Graphics;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.AbstractGraphPlot;

public class GraphScatter
extends AbstractGraphPlot {
    private static final long serialVersionUID = 1L;
    private static final int DOT_SIZE = 6;
    private double[] variedParamValues;

    public void setGraph(MeasureCollection[] measures, MeasureCollection[] stds, double[] variedParamValues, Color[] colors) {
        this.variedParamValues = variedParamValues;
        super.setGraph(measures, stds, colors);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.measures == null || this.variedParamValues == null) {
            return;
        }
        for (int i = 0; i < this.measures.length; ++i) {
            this.scatter(g, i);
        }
    }

    private void scatter(Graphics g, int i) {
        int height = this.getHeight();
        int width = this.getWidth();
        int x = (int)((this.variedParamValues[i] - this.lower_x_value) / (this.upper_x_value - this.lower_x_value) * (double)width);
        double value = this.measures[i].getLastValue(this.measureSelected);
        if (Double.isNaN(value)) {
            return;
        }
        int y = (int)((double)height - value / this.upper_y_value * (double)height);
        g.setColor(this.colors[i]);
        if (this.isStandardDeviationPainted) {
            int len = (int)(this.measureStds[i].getLastValue(this.measureSelected) / this.upper_y_value * (double)height);
            this.paintStandardDeviation(g, len, x, y);
        }
        g.fillOval(x - 3, y - 3, 6, 6);
    }
}

