## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  results = "hold", 
  collapse = TRUE, 
  eval = TRUE,
  fig.pos = 'h',
  fig.width = 5,
  fig.height = 3.5,
  fig.align = 'center'
)

## ----message = FALSE----------------------------------------------------------
library(surveil)
library(rstan)
data(cancer)

## -----------------------------------------------------------------------------
data2 <- cancer[which(cancer$Age == "10-14"),]
fit <- stan_rw(data2, time = Year)

## -----------------------------------------------------------------------------
print(fit, scale = 100e3)

## -----------------------------------------------------------------------------
samples <- fit$samples
class(samples)

## -----------------------------------------------------------------------------
phi <- as.matrix(samples, pars = "rate")
dim(phi)

## -----------------------------------------------------------------------------
phi_1999 <- phi[,1] * 100e3
head(phi_1999)

## -----------------------------------------------------------------------------
hist(phi_1999, main = "Rate per 100,000")

## -----------------------------------------------------------------------------
mean(phi_1999)

## -----------------------------------------------------------------------------
quantile(phi_1999, probs = c(0.025, 0.1, 0.9, 0.975))

## -----------------------------------------------------------------------------
plot(fit, style = "lines", scale = 100e3)

## -----------------------------------------------------------------------------
diff <- (phi[,19] - phi[,1]) * 100e3
hist(diff)

## -----------------------------------------------------------------------------
mean(diff)

## ----fig.width = 4, fig.height = 3.5------------------------------------------
rstan::stan_mcse(samples)

## -----------------------------------------------------------------------------
print(samples)

## ----fig.width = 4, fig.height = 3.5------------------------------------------
rstan::stan_rhat(samples)

