/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.evomodel.treedatalikelihood.discrete.MaximizerWrtParameter;
import dr.inference.operators.SimpleMCMCOperator;

public class TreeMaximizationOperator
extends SimpleMCMCOperator {
    private SimpleMCMCOperator treeOperator;
    private MaximizerWrtParameter maximizerWrtParameter;
    private int maxSteps;

    public TreeMaximizationOperator(SimpleMCMCOperator simpleMCMCOperator, MaximizerWrtParameter maximizerWrtParameter, int n, double d) {
        this.setWeight(d);
        this.treeOperator = simpleMCMCOperator;
        this.maximizerWrtParameter = maximizerWrtParameter;
        this.maxSteps = n;
    }

    @Override
    public String getOperatorName() {
        if (this.getCount() < (long)this.maxSteps) {
            return "treeMaximizationOperator(" + this.treeOperator.getOperatorName() + ")";
        }
        return this.treeOperator.getOperatorName();
    }

    @Override
    public double doOperation() {
        double d = this.maximizerWrtParameter.getLikelihood().getLogLikelihood();
        double d2 = this.treeOperator.doOperation();
        if (this.getCount() < (long)this.maxSteps) {
            this.maximizerWrtParameter.maximize();
            double d3 = this.maximizerWrtParameter.getLikelihood().getLogLikelihood();
            return d3 - d;
        }
        return d2;
    }
}

