/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.oldevomodel.substmodel.ComplexSubstitutionModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.OnePhaseModel;

public abstract class MicrosatelliteModel
extends ComplexSubstitutionModel {
    protected OnePhaseModel subModel = null;
    protected boolean isNested = false;
    protected double[][] infinitesimalRateMatrix = null;
    protected boolean useStationaryFreqs = false;
    protected boolean modelUpdate = false;

    public MicrosatelliteModel(String string, Microsatellite microsatellite, FrequencyModel frequencyModel, Parameter parameter) {
        super(string, microsatellite, frequencyModel, parameter);
        if (parameter == null) {
            double[] dArray = new double[this.stateCount * (this.stateCount - 1)];
            this.infinitesimalRates = new Parameter.Default(dArray);
        }
        this.infinitesimalRateMatrix = new double[this.stateCount][this.stateCount];
    }

    public void setToEqualFrequencies() {
        double[] dArray = new double[this.stateCount];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 1.0 / (double)this.stateCount;
        }
        this.freqModel = new FrequencyModel(this.dataType, dArray);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.updateMatrix = true;
    }

    @Override
    public void storeIntoAmat() {
        this.amat = this.infinitesimalRateMatrix;
    }

    @Override
    protected void makeValid(double[][] dArray, int n) {
    }

    protected double getRate(int n, int n2) {
        return this.infinitesimalRateMatrix[n][n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTwoPhaseStationaryDistribution() {
        MicrosatelliteModel microsatelliteModel = this;
        synchronized (microsatelliteModel) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        if (!this.wellConditioned) {
            throw new RuntimeException("not well conditioned");
        }
        int n = -1;
        for (int i = 0; i < this.stateCount; ++i) {
            if (this.Eval[i] != 0.0) continue;
            n = i;
            break;
        }
        double[] dArray = new double[this.stateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            dArray[i] = this.Evec[i][n] * this.Ievc[n][i];
        }
        this.freqModel = new FrequencyModel(this.dataType, dArray);
    }

    @Override
    public double[] getRates() {
        return super.getRates();
    }

    public abstract void setupInfinitesimalRates();

    public double[][] getInfinitesimalRates() {
        return this.infinitesimalRateMatrix;
    }

    public double getLogOneTransitionProbabilityEntry(double d, int n, int n2) {
        return Math.log(this.getOneTransitionProbabilityEntry(d, n, n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getOneTransitionProbabilityEntry(double d, int n, int n2) {
        int n3;
        if (this.dataType.isAmbiguousState(n2)) {
            return 1.0;
        }
        double d2 = 0.0;
        Object object = this;
        synchronized (object) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        if (!this.wellConditioned) {
            return 0.0;
        }
        object = new double[this.stateCount];
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            if (this.EvalImag[n3] == 0.0) {
                double d3 = Math.exp(d * this.Eval[n3]);
                object[n3] = d3 * this.Ievc[n3][n2];
                continue;
            }
            int n4 = n3 + 1;
            double d4 = this.EvalImag[n3];
            double d5 = Math.exp(d * this.Eval[n3]);
            double d6 = d5 * Math.cos(d * d4);
            double d7 = d5 * Math.sin(d * d4);
            object[n3] = d6 * this.Ievc[n3][n2] + d7 * this.Ievc[n4][n2];
            object[n4] = d6 * this.Ievc[n4][n2] - d7 * this.Ievc[n3][n2];
            ++n3;
        }
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            d2 += this.Evec[n][n3] * object[n3];
        }
        if (d2 <= 0.0) {
            d2 = minProb;
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getColTransitionProbabilities(double d, int n) {
        int n2;
        int n3;
        double[] dArray = new double[this.stateCount];
        Object object = this;
        synchronized (object) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        if (!this.wellConditioned) {
            return dArray;
        }
        object = new double[this.stateCount];
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            if (this.EvalImag[n3] == 0.0) {
                double d2 = Math.exp(d * this.Eval[n3]);
                object[n3] = d2 * this.Ievc[n3][n];
                continue;
            }
            n2 = n3 + 1;
            double d3 = this.EvalImag[n3];
            double d4 = Math.exp(d * this.Eval[n3]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            object[n3] = d5 * this.Ievc[n3][n] + d6 * this.Ievc[n2][n];
            object[n2] = d5 * this.Ievc[n2][n] - d6 * this.Ievc[n3][n];
            ++n3;
        }
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + this.Evec[n3][n2] * object[n2];
            }
            if (!(dArray[n3] <= 0.0)) continue;
            dArray[n3] = minProb;
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getRowTransitionProbabilities(double d, int n) {
        int n2;
        int n3;
        double[] dArray = new double[this.stateCount];
        MicrosatelliteModel microsatelliteModel = this;
        synchronized (microsatelliteModel) {
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        if (!this.wellConditioned) {
            return dArray;
        }
        double[][] dArray2 = new double[this.stateCount][this.stateCount];
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            if (this.EvalImag[n3] == 0.0) {
                double d2 = Math.exp(d * this.Eval[n3]);
                for (n2 = 0; n2 < this.stateCount; ++n2) {
                    dArray2[n3][n2] = this.Ievc[n3][n2] * d2;
                }
                continue;
            }
            int n4 = n3 + 1;
            double d3 = this.EvalImag[n3];
            double d4 = Math.exp(d * this.Eval[n3]);
            double d5 = d4 * Math.cos(d * d3);
            double d6 = d4 * Math.sin(d * d3);
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                dArray2[n3][n2] = d5 * this.Ievc[n3][n2] + d6 * this.Ievc[n4][n2];
                dArray2[n4][n2] = d5 * this.Ievc[n4][n2] - d6 * this.Ievc[n3][n2];
            }
            ++n3;
        }
        for (n3 = 0; n3 < this.stateCount; ++n3) {
            for (n2 = 0; n2 < this.stateCount; ++n2) {
                int n5 = n3;
                dArray[n5] = dArray[n5] + this.Evec[n][n2] * dArray2[n2][n3];
            }
            if (!(dArray[n3] <= 0.0)) continue;
            dArray[n3] = minProb;
        }
        return dArray;
    }

    public void computeOnePhaseStationaryDistribution() {
        int n;
        double[] dArray = new double[this.stateCount];
        dArray[0] = 1.0;
        double d = 1.0;
        for (n = 1; n < this.stateCount; ++n) {
            dArray[n] = dArray[n - 1] * this.infinitesimalRateMatrix[n - 1][n] / this.infinitesimalRateMatrix[n][n - 1];
            d += dArray[n];
        }
        for (n = 0; n < this.stateCount; ++n) {
            dArray[n] = dArray[n] / d;
        }
        this.freqModel = new FrequencyModel(this.dataType, dArray);
    }

    @Override
    public void setupMatrix() {
        this.setupInfinitesimalRates();
        super.setupMatrix();
    }

    public MicrosatelliteModel getSubmodel() {
        return this.subModel;
    }

    public boolean isSubmodel() {
        return this.isNested;
    }

    public boolean hasSubmodel() {
        return this.subModel != null;
    }

    public boolean isModelUpdated() {
        return true;
    }
}

