/*
 * Decompiled with CFR 0.152.
 */
package dr.xml.unittest;

import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class CachedReport
implements Reportable {
    private String report;
    private final Reportable reportable;
    private static final String CACHED_REPORT = "cachedReport";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Class getReturnType() {
            return CachedReport.class;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Reportable reportable = (Reportable)xMLObject.getChild(Reportable.class);
            return new CachedReport(reportable);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Reportable.class)};
        }

        @Override
        public String getParserDescription() {
            return "Reportable object that caches the report rather than re-computing it.";
        }

        @Override
        public String getParserName() {
            return CachedReport.CACHED_REPORT;
        }
    };

    CachedReport(Reportable reportable) {
        this.reportable = reportable;
        this.report = null;
    }

    @Override
    public String getReport() {
        if (this.report == null) {
            this.report = this.reportable.getReport();
        }
        return this.report;
    }
}

