/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.alignments;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.sequences.Sequence;
import jebl.evolution.sequences.SequenceType;
import jebl.evolution.sequences.State;
import jebl.evolution.taxa.Taxon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicAlignment
implements Alignment {
    private SequenceType sequenceType = null;
    private List<Taxon> taxonList = new ArrayList<Taxon>();
    private Map<Taxon, Sequence> sequences = new HashMap<Taxon, Sequence>();
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public BasicAlignment() {
    }

    public BasicAlignment(Collection<? extends Sequence> sequences) {
        for (Sequence sequence : sequences) {
            this.put(sequence);
        }
        this.constructPatterns();
    }

    public BasicAlignment(Sequence[] sequences) {
        for (Sequence sequence : sequences) {
            this.put(sequence);
        }
        this.constructPatterns();
    }

    @Override
    public Set<Sequence> getSequences() {
        return new HashSet<Sequence>(this.sequences.values());
    }

    @Override
    public List<Sequence> getSequenceList() {
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        for (Taxon taxon : this.taxonList) {
            seqs.add(this.sequences.get(taxon));
        }
        return seqs;
    }

    @Override
    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    @Override
    public Sequence getSequence(Taxon taxon) {
        return this.sequences.get(taxon);
    }

    @Override
    public int getSiteCount() {
        return this.patterns.size();
    }

    @Override
    public int getPatternCount() {
        return this.patterns.size();
    }

    @Override
    public int getPatternLength() {
        return this.taxonList.size();
    }

    @Override
    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public List<Taxon> getTaxa() {
        return this.taxonList;
    }

    public void addSequence(Sequence sequence) {
        this.put(sequence);
        this.constructPatterns();
    }

    private void put(Sequence sequence) {
        if (this.sequenceType == null) {
            this.sequenceType = sequence.getSequenceType();
        }
        if (this.sequenceType != sequence.getSequenceType()) {
            throw new IllegalArgumentException("Type of sequence " + sequence.getTaxon().getName() + " does not match that of other sequences in the alignment" + " (data type = " + sequence.getSequenceType().getName() + ", but expected " + this.sequenceType.getName() + ").");
        }
        if (this.taxonList.indexOf(sequence.getTaxon()) >= 0) {
            throw new IllegalArgumentException("duplicate sequence name " + sequence.getTaxon());
        }
        this.sequences.put(sequence.getTaxon(), sequence);
        this.taxonList.add(sequence.getTaxon());
    }

    private void constructPatterns() {
        this.patterns.clear();
        State[][] seqs = new State[this.sequences.size()][];
        int i = 0;
        int maxLen = 0;
        for (Sequence seq : this.getSequenceList()) {
            seqs[i] = seq.getStates();
            if (seqs[i].length > maxLen) {
                maxLen = seqs[i].length;
            }
            ++i;
        }
        for (int j = 0; j < maxLen; ++j) {
            ArrayList<State> states = new ArrayList<State>();
            for (i = 0; i < seqs.length; ++i) {
                if (j < seqs[i].length) {
                    states.add(seqs[i][j]);
                    continue;
                }
                states.add(this.sequenceType.getGapState());
            }
            this.patterns.add(new BasicPattern(states));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BasicPattern
    implements Pattern {
        private final List<State> states;

        public BasicPattern(List<State> states) {
            this.states = states;
        }

        @Override
        public SequenceType getSequenceType() {
            return BasicAlignment.this.sequenceType;
        }

        @Override
        public int getLength() {
            return this.states.size();
        }

        @Override
        public List<Taxon> getTaxa() {
            return BasicAlignment.this.taxonList;
        }

        @Override
        public State getState(int index) {
            return this.states.get(index);
        }

        @Override
        public List<State> getStates() {
            return this.states;
        }

        @Override
        public Set<State> getStateSet() {
            return new HashSet<State>(this.states);
        }

        @Override
        public double getWeight() {
            return 1.0;
        }

        @Override
        public State getMostFrequentState() {
            return this.getMostFrequentState(false);
        }

        @Override
        public State getMostFrequentState(boolean includeAmbiguous) {
            int maxCount = 0;
            State mostFrequentState = null;
            int[] counts = new int[BasicAlignment.this.sequenceType.getStateCount()];
            for (State state : this.states) {
                int n = state.getIndex();
                counts[n] = counts[n] + 1;
                if (!includeAmbiguous && state.isAmbiguous() || counts[state.getIndex()] <= maxCount) continue;
                maxCount = counts[state.getIndex()];
                mostFrequentState = state;
            }
            if (mostFrequentState == null) {
                return BasicAlignment.this.sequenceType.getUnknownState();
            }
            return mostFrequentState;
        }

        @Override
        public double getStateFrequency(State state) {
            return (double)this.getStateCount(state) / (double)this.states.size();
        }

        @Override
        public int getStateCount(State state) {
            int count = 0;
            for (State s : this.states) {
                if (s != state) continue;
                ++count;
            }
            return count;
        }
    }
}

