/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import CADStat.java.plots.SubsetFormatter;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.neptuneinc.cadstat.prefs.PreferencesManager;
import org.neptuneinc.cadstat.ui.DatasetPane;
import org.neptuneinc.cadstat.ui.FactorSubsetPane;
import org.neptuneinc.cadstat.utils.GUIUtils;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REngineException;

public class BxPlot
extends JDialog
implements WindowListener {
    private JRadioButton bothPlotTypeRadioButton;
    private JPanel buttonPane;
    private JSeparator buttonSeparator;
    private JButton cancelButton;
    private JPanel datasetContainerPane;
    private DatasetPane datasetPane;
    private JSeparator datasetSeparator;
    private JCheckBox enableGroupByCheckBox;
    private FactorSubsetPane factorSubsetPane;
    private JPanel groupByPane;
    private JButton helpButton;
    private JCheckBox horizontal;
    private JPanel leftPane;
    private JRadioButton logPlotTypeRadioButton;
    private JPanel midPane;
    private JRadioButton originalPlotTypeRadioButton;
    private JPanel plotLabelsPane;
    private JPanel plotOptionsPane;
    private JTextField plotTitle;
    private JLabel plotTitleLabel;
    private ButtonGroup plotTypeGroup;
    private JPanel plotTypePane;
    private JComboBox resultComboBox;
    private JLabel resultLabel;
    private JPanel rightPane;
    private JCheckBox rotateXLabCheckBox;
    private JCheckBox sampleSizes;
    private JButton submitButton;
    private JPanel varPane;
    private JTextField yAxis;
    private JLabel yAxisLabel;

    public BxPlot() {
        this.initComponents();
        this.addWindowListener(this);
        this.datasetPane.getDatasetLabel().setText("Active Dataset:");
        this.datasetPane.getDatasetComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BxPlot.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.datasetPane.refreshDatasetComboBox();
        this.refreshVariableListValidity();
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
        this.getRootPane().setDefaultButton(this.submitButton);
    }

    private void datasetComboBoxActionPerformed(ActionEvent evt) {
        this.refreshVariableList();
        this.factorSubsetPane.setDataset(this.datasetPane.getSelectedDataset());
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotTypeGroup = new ButtonGroup();
        this.datasetContainerPane = new JPanel();
        this.datasetPane = new DatasetPane();
        this.datasetSeparator = new JSeparator();
        this.midPane = new JPanel();
        this.leftPane = new JPanel();
        this.varPane = new JPanel();
        this.resultLabel = new JLabel();
        this.resultComboBox = new JComboBox();
        this.groupByPane = new JPanel();
        this.enableGroupByCheckBox = new JCheckBox();
        this.factorSubsetPane = new FactorSubsetPane();
        this.rightPane = new JPanel();
        this.plotTypePane = new JPanel();
        this.originalPlotTypeRadioButton = new JRadioButton();
        this.logPlotTypeRadioButton = new JRadioButton();
        this.bothPlotTypeRadioButton = new JRadioButton();
        this.plotOptionsPane = new JPanel();
        this.sampleSizes = new JCheckBox();
        this.rotateXLabCheckBox = new JCheckBox();
        this.horizontal = new JCheckBox();
        this.plotLabelsPane = new JPanel();
        this.plotTitleLabel = new JLabel();
        this.plotTitle = new JTextField();
        this.yAxisLabel = new JLabel();
        this.yAxis = new JTextField();
        this.buttonSeparator = new JSeparator();
        this.buttonPane = new JPanel();
        this.cancelButton = new JButton();
        this.submitButton = new JButton();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Boxplot");
        this.datasetContainerPane.add(this.datasetPane);
        this.midPane.setLayout(new GridLayout(1, 2, 5, 0));
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.resultLabel.setText("Result:");
        GroupLayout varPaneLayout = new GroupLayout(this.varPane);
        this.varPane.setLayout(varPaneLayout);
        varPaneLayout.setHorizontalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, varPaneLayout.createSequentialGroup().addContainerGap().addComponent(this.resultLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resultComboBox, 0, 216, Short.MAX_VALUE).addContainerGap()));
        varPaneLayout.setVerticalGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(varPaneLayout.createSequentialGroup().addContainerGap().addGroup(varPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultLabel).addComponent(this.resultComboBox, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        this.groupByPane.setBorder(BorderFactory.createTitledBorder("Group By"));
        this.enableGroupByCheckBox.setText("Enable Grouping");
        this.enableGroupByCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BxPlot.this.enableGroupByCheckBoxStateChanged(evt);
            }
        });
        GroupLayout groupByPaneLayout = new GroupLayout(this.groupByPane);
        this.groupByPane.setLayout(groupByPaneLayout);
        groupByPaneLayout.setHorizontalGroup(groupByPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupByPaneLayout.createSequentialGroup().addContainerGap().addGroup(groupByPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupByPaneLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.factorSubsetPane, -1, 277, Short.MAX_VALUE)).addComponent(this.enableGroupByCheckBox)).addContainerGap()));
        groupByPaneLayout.setVerticalGroup(groupByPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupByPaneLayout.createSequentialGroup().addComponent(this.enableGroupByCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.factorSubsetPane, -1, 219, Short.MAX_VALUE).addContainerGap()));
        GroupLayout leftPaneLayout = new GroupLayout(this.leftPane);
        this.leftPane.setLayout(leftPaneLayout);
        leftPaneLayout.setHorizontalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.varPane, -1, -1, Short.MAX_VALUE).addComponent(this.groupByPane, -1, -1, Short.MAX_VALUE));
        leftPaneLayout.setVerticalGroup(leftPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPaneLayout.createSequentialGroup().addComponent(this.varPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.groupByPane, -1, -1, Short.MAX_VALUE)));
        this.midPane.add(this.leftPane);
        this.plotTypePane.setBorder(BorderFactory.createTitledBorder("Plot Type"));
        this.plotTypeGroup.add(this.originalPlotTypeRadioButton);
        this.originalPlotTypeRadioButton.setText("Original");
        this.plotTypeGroup.add(this.logPlotTypeRadioButton);
        this.logPlotTypeRadioButton.setText("Log");
        this.plotTypeGroup.add(this.bothPlotTypeRadioButton);
        this.bothPlotTypeRadioButton.setSelected(true);
        this.bothPlotTypeRadioButton.setText("Both");
        GroupLayout plotTypePaneLayout = new GroupLayout(this.plotTypePane);
        this.plotTypePane.setLayout(plotTypePaneLayout);
        plotTypePaneLayout.setHorizontalGroup(plotTypePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotTypePaneLayout.createSequentialGroup().addContainerGap().addGroup(plotTypePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.originalPlotTypeRadioButton).addComponent(this.logPlotTypeRadioButton).addComponent(this.bothPlotTypeRadioButton)).addContainerGap(208, Short.MAX_VALUE)));
        plotTypePaneLayout.setVerticalGroup(plotTypePaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotTypePaneLayout.createSequentialGroup().addComponent(this.originalPlotTypeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logPlotTypeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bothPlotTypeRadioButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.plotOptionsPane.setBorder(BorderFactory.createTitledBorder("Plot Options"));
        this.sampleSizes.setText("Sample Sizes");
        this.rotateXLabCheckBox.setText("Rotate X-Axis Labels");
        this.horizontal.setText("Horizontal Boxplot");
        this.horizontal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BxPlot.this.horizontalActionPerformed(evt);
            }
        });
        GroupLayout plotOptionsPaneLayout = new GroupLayout(this.plotOptionsPane);
        this.plotOptionsPane.setLayout(plotOptionsPaneLayout);
        plotOptionsPaneLayout.setHorizontalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotOptionsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sampleSizes).addComponent(this.rotateXLabCheckBox).addComponent(this.horizontal)).addContainerGap(95, Short.MAX_VALUE)));
        plotOptionsPaneLayout.setVerticalGroup(plotOptionsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, plotOptionsPaneLayout.createSequentialGroup().addComponent(this.horizontal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.sampleSizes).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rotateXLabCheckBox).addContainerGap()));
        this.plotLabelsPane.setBorder(BorderFactory.createTitledBorder("Plot Labels"));
        this.plotTitleLabel.setHorizontalAlignment(4);
        this.plotTitleLabel.setLabelFor(this.plotTitle);
        this.plotTitleLabel.setText("Plot Title");
        this.plotTitle.setColumns(10);
        this.plotTitle.setText("Boxplot");
        this.yAxisLabel.setHorizontalAlignment(4);
        this.yAxisLabel.setLabelFor(this.yAxis);
        this.yAxisLabel.setText("Result-Axis");
        this.yAxis.setColumns(10);
        this.yAxis.setText("Y");
        GroupLayout plotLabelsPaneLayout = new GroupLayout(this.plotLabelsPane);
        this.plotLabelsPane.setLayout(plotLabelsPaneLayout);
        plotLabelsPaneLayout.setHorizontalGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelsPaneLayout.createSequentialGroup().addContainerGap().addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelsPaneLayout.createSequentialGroup().addComponent(this.plotTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotTitle, -1, 179, Short.MAX_VALUE)).addGroup(plotLabelsPaneLayout.createSequentialGroup().addComponent(this.yAxisLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yAxis, -1, 179, Short.MAX_VALUE))).addContainerGap()));
        plotLabelsPaneLayout.linkSize(0, this.plotTitleLabel, this.yAxisLabel);
        plotLabelsPaneLayout.setVerticalGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(plotLabelsPaneLayout.createSequentialGroup().addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.plotTitleLabel).addComponent(this.plotTitle, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(plotLabelsPaneLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.yAxisLabel).addComponent(this.yAxis, -2, -1, -2)).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout rightPaneLayout = new GroupLayout(this.rightPane);
        this.rightPane.setLayout(rightPaneLayout);
        rightPaneLayout.setHorizontalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.plotTypePane, -1, -1, Short.MAX_VALUE).addComponent(this.plotOptionsPane, -1, -1, Short.MAX_VALUE).addComponent(this.plotLabelsPane, -1, -1, Short.MAX_VALUE));
        rightPaneLayout.setVerticalGroup(rightPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPaneLayout.createSequentialGroup().addComponent(this.plotTypePane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotOptionsPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.plotLabelsPane, -2, -1, -2)));
        this.midPane.add(this.rightPane);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 10, 0, 10));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BxPlot.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.cancelButton);
        this.submitButton.setText("Submit");
        this.submitButton.setMargin(new Insets(0, 10, 0, 10));
        this.submitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BxPlot.this.submitButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.submitButton);
        this.helpButton.setText("Help");
        this.helpButton.setMargin(new Insets(0, 10, 0, 10));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BxPlot.this.helpButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.helpButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.datasetContainerPane, -1, 680, Short.MAX_VALUE).addComponent(this.datasetSeparator, -1, 680, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.midPane, -1, 656, Short.MAX_VALUE).addContainerGap()).addComponent(this.buttonSeparator, GroupLayout.Alignment.TRAILING, -1, 680, Short.MAX_VALUE).addComponent(this.buttonPane, -1, 680, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.datasetContainerPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.datasetSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.midPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSeparator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPane, -2, 44, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void submitButtonActionPerformed(ActionEvent evt) {
        PreferencesManager prefsManager = new PreferencesManager();
        try {
            prefsManager.importPreferences();
        }
        catch (Exception ex) {
            Logger.getLogger(BxPlot.class.getName()).log(Level.INFO, null, ex);
        }
        String plotType = null;
        if (this.originalPlotTypeRadioButton.isSelected()) {
            plotType = "original";
        } else if (this.logPlotTypeRadioButton.isSelected()) {
            plotType = "log";
        } else if (this.bothPlotTypeRadioButton.isSelected()) {
            plotType = "both";
        }
        String cmd = "bxplot.JGR(my.data=" + this.datasetPane.getSelectedDataset() + ", result=" + GUIUtils.getSelectedItemR(this.resultComboBox) + ", group.name=" + (this.enableGroupByCheckBox.isSelected() ? RUtils.getStringValue(this.factorSubsetPane.getSelectedFactor()) : "NULL") + ", group.val=" + (this.enableGroupByCheckBox.isSelected() && this.factorSubsetPane.getFactorValueList().isSelectionEmpty() ? "NULL" : SubsetFormatter.formatSubset(this.factorSubsetPane.getSelectedFactorValues())) + ", subset1.name=NULL, subset1.val=NULL, subset2.name=NULL, subset2.val=NULL, main=" + RUtils.getStringValue(this.plotTitle.getText()) + ", result.lab=" + RUtils.getStringValue(this.yAxis.getText()) + ", plot.type=" + RUtils.getStringValue(plotType) + ", horizontal=" + GUIUtils.getBooleanValueR(this.horizontal) + ", iSampleSize=" + GUIUtils.getBooleanValueR(this.sampleSizes) + ", names.rot=" + GUIUtils.getBooleanValueR(this.rotateXLabCheckBox) + ", " + prefsManager.getCadstatPreferences().toString() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void helpButtonActionPerformed(ActionEvent evt) {
        String cmd = "CADStat.help('boxplot.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    private void enableGroupByCheckBoxStateChanged(ChangeEvent evt) {
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
    }

    private void horizontalActionPerformed(ActionEvent evt) {
        this.refreshSampleSizes();
    }

    public void refreshVariableListValidity() {
        this.resultComboBox.setEnabled(this.datasetPane.getDatasetComboBox().getItemCount() > 0 && this.resultComboBox.getItemCount() > 0);
    }

    public void refreshSampleSizes() {
        this.sampleSizes.setSelected(!this.horizontal.isSelected() && this.sampleSizes.isSelected());
    }

    public void refreshVariableList() {
        if (this.datasetPane.getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = null;
            try {
                nonFactors = RUtils.nonFactors(this.datasetPane.getSelectedDataset());
                this.resultComboBox.setModel(new DefaultComboBoxModel(nonFactors));
                if (this.resultComboBox.getItemCount() > 0) {
                    this.resultComboBox.setSelectedIndex(0);
                }
            }
            catch (REngineException ex) {
                Logger.getLogger(BxPlot.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (REXPMismatchException ex) {
                Logger.getLogger(BxPlot.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.resultComboBox.removeAllItems();
        }
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    public void refreshGroupByComponentValidity() {
        JLabel factorLabel = this.factorSubsetPane.getFactorLabel();
        JComboBox factorComboBox = this.factorSubsetPane.getFactorComboBox();
        JScrollPane factorValueScrollPane = this.factorSubsetPane.getFactorValueScrollPane();
        JList factorValueList = this.factorSubsetPane.getFactorValueList();
        boolean groupByEnabled = this.enableGroupByCheckBox.isSelected();
        factorLabel.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
        factorComboBox.setEnabled(groupByEnabled && factorComboBox.getItemCount() > 0);
        factorValueScrollPane.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
        factorValueList.setEnabled(groupByEnabled && factorValueList.getModel().getSize() > 0);
    }

    public void refreshSubmitButtonValidity() {
        JComboBox factorComboBox = this.factorSubsetPane.getFactorComboBox();
        this.submitButton.setEnabled(this.datasetPane.getDatasetComboBox().getItemCount() > 0 && this.resultComboBox.getItemCount() > 0 && (!this.enableGroupByCheckBox.isSelected() || factorComboBox.getItemCount() > 0));
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        Object result = this.resultComboBox.getSelectedItem();
        Object factor = this.factorSubsetPane.getFactorComboBox().getSelectedItem();
        int[] factorValueIndices = this.factorSubsetPane.getFactorValueList().getSelectedIndices();
        this.datasetPane.refreshDatasetComboBox();
        this.resultComboBox.setSelectedItem(result);
        this.factorSubsetPane.getFactorComboBox().setSelectedItem(factor);
        this.factorSubsetPane.getFactorValueList().setSelectedIndices(factorValueIndices);
        this.refreshVariableListValidity();
        this.refreshGroupByComponentValidity();
        this.refreshSubmitButtonValidity();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

