/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Hyperrectangles.Basic;

import java.util.Arrays;
import java.util.StringTokenizer;
import keel.Algorithms.Hyperrectangles.Basic.DataException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;
import org.core.Files;

public abstract class HyperrectanglesAlgorithm {
    protected String[] outFile;
    protected String testFile;
    protected String trainFile;
    protected String referenceFile;
    protected InstanceSet train;
    protected InstanceSet test;
    protected InstanceSet reference;
    protected Instance temp;
    protected int inputAtt;
    protected Attribute[] inputs;
    protected Attribute output;
    protected boolean[] nulls;
    protected double[][] trainData;
    protected int[] trainOutput;
    protected double[][] testData;
    protected int[] testOutput;
    protected double[][] referenceData;
    protected int[] referenceOutput;
    protected String relation;
    protected int nClasses;
    protected int[] nInstances;
    protected long initialTime;
    protected double modelTime;
    protected double trainingTime;
    protected double testTime;
    protected String name;
    protected long seed;
    protected int[][] confMatrix;
    protected int unclassified;
    protected int[][] realClass;
    protected int[][] prediction;
    protected int[][] trainConfMatrix;
    protected int trainUnclassified;
    protected int[][] trainRealClass;
    protected int[][] trainPrediction;
    protected String ruleSetText;

    protected void readDataFiles(String script) {
        int i;
        this.readConfiguracion(script);
        this.readParameters(script);
        try {
            this.train = new InstanceSet();
            this.train.readSet(this.trainFile, true);
            this.train.setAttributesAsNonStatic();
            this.inputAtt = this.train.getAttributeDefinitions().getInputNumAttributes();
            this.inputs = this.train.getAttributeDefinitions().getInputAttributes();
            this.output = this.train.getAttributeDefinitions().getOutputAttribute(0);
            this.normalizeTrain();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        try {
            this.test = new InstanceSet();
            this.test.readSet(this.testFile, false);
            this.test.setAttributesAsNonStatic();
            this.normalizeTest();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        Attributes.clearAll();
        try {
            this.reference = new InstanceSet();
            this.reference.readSet(this.referenceFile, true);
            this.reference.setAttributesAsNonStatic();
            this.normalizeReference();
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        this.nClasses = this.train.getAttributeDefinitions().getOutputAttribute(0).getNumNominalValues();
        this.nInstances = new int[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            this.nInstances[i] = 0;
        }
        for (i = 0; i < this.trainOutput.length; ++i) {
            int n = this.trainOutput[i];
            this.nInstances[n] = this.nInstances[n] + 1;
        }
    }

    protected void readConfiguracion(String script) {
        this.outFile = new String[3];
        String fichero = Files.readFile(script);
        StringTokenizer lineasFichero = new StringTokenizer(fichero, "\n\r");
        lineasFichero.nextToken();
        String linea = lineasFichero.nextToken();
        StringTokenizer tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        String token = tokens.nextToken();
        byte[] line = token.getBytes();
        int i = 0;
        while (line[i] != 34) {
            ++i;
        }
        int j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.trainFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.referenceFile = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.testFile = new String(line, i, j - i);
        linea = lineasFichero.nextToken();
        tokens = new StringTokenizer(linea, "=");
        tokens.nextToken();
        token = tokens.nextToken();
        line = token.getBytes();
        i = 0;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[0] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[1] = new String(line, i, j - i);
        i = j + 1;
        while (line[i] != 34) {
            ++i;
        }
        j = ++i;
        while (line[j] != 34) {
            ++j;
        }
        this.outFile[2] = new String(line, i, j - i);
    }

    protected abstract void readParameters(String var1);

    protected void normalizeTrain() throws DataException {
        int j;
        int i;
        if (this.train.getAttributeDefinitions().getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (this.train.getAttributeDefinitions().getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (this.train.getAttributeDefinitions().getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification \tproblem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.train.getHeader(), " \n\r");
        tokens.nextToken();
        this.relation = tokens.nextToken();
        this.trainData = new double[this.train.getNumInstances()][this.inputAtt];
        this.trainOutput = new int[this.train.getNumInstances()];
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            this.temp = this.train.getInstance(i);
            this.trainData[i] = this.temp.getAllInputValues();
            this.trainOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.trainData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (this.train.getAttributeDefinitions().getInputAttribute(i).getType() == 0) continue;
            minimum[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMinAttribute();
            range[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.train.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (this.train.getAttributeDefinitions().getInputAttribute(j).getType() == 0) {
                    if (this.train.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.trainData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(this.train.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.trainData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.trainData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    protected void normalizeTest() throws DataException {
        int j;
        int i;
        if (this.test.getAttributeDefinitions().getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (this.test.getAttributeDefinitions().getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (this.test.getAttributeDefinitions().getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification \tproblem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.test.getHeader(), " \n\r");
        tokens.nextToken();
        tokens.nextToken();
        this.testData = new double[this.test.getNumInstances()][this.inputAtt];
        this.testOutput = new int[this.test.getNumInstances()];
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            this.temp = this.test.getInstance(i);
            this.testData[i] = this.temp.getAllInputValues();
            this.testOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.testData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (this.test.getAttributeDefinitions().getInputAttribute(i).getType() == 0) continue;
            minimum[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMinAttribute();
            range[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.test.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (this.test.getAttributeDefinitions().getInputAttribute(j).getType() == 0) {
                    if (this.test.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.testData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(this.test.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.testData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.testData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    protected void normalizeReference() throws DataException {
        int j;
        int i;
        if (this.reference.getAttributeDefinitions().getOutputNumAttributes() < 1) {
            throw new DataException("This dataset haven\u00b4t outputs, so it not corresponding to a classification problem.");
        }
        if (this.reference.getAttributeDefinitions().getOutputNumAttributes() > 1) {
            throw new DataException("This dataset have more of one output.");
        }
        if (this.reference.getAttributeDefinitions().getOutputAttribute(0).getType() == 2) {
            throw new DataException("This dataset have an input attribute with float values, so it not corresponding to a classification \tproblem.");
        }
        StringTokenizer tokens = new StringTokenizer(this.reference.getHeader(), " \n\r");
        tokens.nextToken();
        tokens.nextToken();
        this.referenceData = new double[this.reference.getNumInstances()][this.inputAtt];
        this.referenceOutput = new int[this.reference.getNumInstances()];
        for (i = 0; i < this.reference.getNumInstances(); ++i) {
            this.temp = this.reference.getInstance(i);
            this.referenceData[i] = this.temp.getAllInputValues();
            this.referenceOutput[i] = (int)this.temp.getOutputRealValues(0);
            this.nulls = this.temp.getInputMissingValues();
            for (j = 0; j < this.nulls.length; ++j) {
                if (!this.nulls[j]) continue;
                this.referenceData[i][j] = 0.0;
            }
        }
        double[] minimum = new double[this.inputAtt];
        double[] range = new double[this.inputAtt];
        for (i = 0; i < this.inputAtt; ++i) {
            if (this.reference.getAttributeDefinitions().getInputAttribute(i).getType() == 0) continue;
            minimum[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMinAttribute();
            range[i] = this.train.getAttributeDefinitions().getInputAttribute(i).getMaxAttribute() - minimum[i];
        }
        for (i = 0; i < this.reference.getNumInstances(); ++i) {
            for (j = 0; j < this.inputAtt; ++j) {
                if (this.reference.getAttributeDefinitions().getInputAttribute(j).getType() == 0) {
                    if (this.reference.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() <= 1) continue;
                    double[] dArray = this.referenceData[i];
                    int n = j;
                    dArray[n] = dArray[n] / (double)(this.reference.getAttributeDefinitions().getInputAttribute(j).getNominalValuesList().size() - 1);
                    continue;
                }
                double[] dArray = this.referenceData[i];
                int n = j;
                dArray[n] = dArray[n] - minimum[j];
                double[] dArray2 = this.referenceData[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] / range[j];
            }
        }
    }

    public void execute() {
        int i;
        this.modelTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        System.out.println(this.name + " " + this.relation + " Model " + this.modelTime + "s");
        this.trainRealClass = new int[this.trainData.length][1];
        this.trainPrediction = new int[this.trainData.length][1];
        this.setInitialTime();
        for (i = 0; i < this.trainRealClass.length; ++i) {
            this.trainRealClass[i][0] = this.trainOutput[i];
            this.trainPrediction[i][0] = this.evaluate(this.trainData[i]);
        }
        this.trainingTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        this.writeOutput(this.outFile[0], this.trainRealClass, this.trainPrediction);
        System.out.println(this.name + " " + this.relation + " Training " + this.trainingTime + "s");
        this.realClass = new int[this.testData.length][1];
        this.prediction = new int[this.testData.length][1];
        this.setInitialTime();
        for (i = 0; i < this.realClass.length; ++i) {
            this.realClass[i][0] = this.testOutput[i];
            this.prediction[i][0] = this.evaluate(this.testData[i]);
        }
        this.testTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        this.writeOutput(this.outFile[1], this.realClass, this.prediction);
        System.out.println(this.name + " " + this.relation + " Test " + this.testTime + "s");
        this.printOutput();
    }

    public void executeReference() {
        int i;
        this.modelTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        System.out.println(this.name + " " + this.relation + " Model " + this.modelTime + "s");
        this.trainRealClass = new int[this.referenceData.length][1];
        this.trainPrediction = new int[this.referenceData.length][1];
        this.setInitialTime();
        for (i = 0; i < this.trainRealClass.length; ++i) {
            this.trainRealClass[i][0] = this.referenceOutput[i];
            this.trainPrediction[i][0] = this.evaluate(this.referenceData[i]);
        }
        this.trainingTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        this.writeOutput(this.outFile[0], this.trainRealClass, this.trainPrediction);
        System.out.println(this.name + " " + this.relation + " Training " + this.trainingTime + "s");
        this.realClass = new int[this.testData.length][1];
        this.prediction = new int[this.testData.length][1];
        this.setInitialTime();
        for (i = 0; i < this.realClass.length; ++i) {
            this.realClass[i][0] = this.testOutput[i];
            this.prediction[i][0] = this.evaluate(this.testData[i]);
        }
        this.testTime = ((double)System.currentTimeMillis() - (double)this.initialTime) / 1000.0;
        this.writeOutput(this.outFile[1], this.realClass, this.prediction);
        System.out.println(this.name + " " + this.relation + " Test " + this.testTime + "s");
        this.printOutput();
    }

    protected abstract int evaluate(double[] var1);

    protected double euclideanDistance(double[] instance1, double[] instance2) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += (instance1[i] - instance2[i]) * (instance1[i] - instance2[i]);
        }
        length = Math.sqrt(length);
        return length;
    }

    protected double manhattanDistance(double[] instance1, double[] instance2) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += Math.abs(instance1[i] - instance2[i]);
        }
        return length;
    }

    protected boolean same(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static String printInstance(int[] instance) {
        String exit = "";
        for (int i = 0; i < instance.length; ++i) {
            exit = exit + instance[i] + " ";
        }
        return exit;
    }

    protected void setInitialTime() {
        this.initialTime = System.currentTimeMillis();
    }

    private void writeOutput(String filename, int[][] realClass, int[][] prediction) {
        int j;
        int i;
        String text = "";
        text = text + "@relation " + this.relation + "\n";
        for (i = 0; i < this.inputs.length; ++i) {
            text = text + "@attribute " + this.inputs[i].getName() + " ";
            if (this.inputs[i].getType() == 0) {
                text = text + "{";
                for (j = 0; j < this.inputs[i].getNominalValuesList().size(); ++j) {
                    text = text + (String)this.inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= this.inputs[i].getNominalValuesList().size() - 1) continue;
                    text = text + ", ";
                }
                text = text + "}\n";
                continue;
            }
            text = this.inputs[i].getType() == 1 ? text + "integer" : text + "real";
            text = text + " [" + String.valueOf(this.inputs[i].getMinAttribute()) + ", " + String.valueOf(this.inputs[i].getMaxAttribute()) + "]\n";
        }
        text = text + "@attribute " + this.output.getName() + " ";
        if (this.output.getType() == 0) {
            text = text + "{";
            for (int j2 = 0; j2 < this.output.getNominalValuesList().size(); ++j2) {
                text = text + (String)this.output.getNominalValuesList().elementAt(j2);
                if (j2 >= this.output.getNominalValuesList().size() - 1) continue;
                text = text + ", ";
            }
            text = text + "}\n";
        } else {
            text = text + "integer [" + String.valueOf(this.output.getMinAttribute()) + ", " + String.valueOf(this.output.getMaxAttribute()) + "]\n";
        }
        text = text + "@data\n";
        Files.writeFile(filename, text);
        if (this.output.getType() == 1) {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + realClass[i][j] + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + prediction[i][j] + " ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        } else {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + (String)this.output.getNominalValuesList().elementAt(realClass[i][j]) + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = prediction[i][j] > -1 ? text + "" + (String)this.output.getNominalValuesList().elementAt(prediction[i][j]) + " " : text + "Unclassified ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        }
    }

    private void printOutput() {
        int j;
        int i;
        String text = "";
        this.computeConfussionMatrixes();
        text = text + "Accuracy: " + this.getAccuracy() + "\n";
        text = text + "Accuracy (Training): " + this.getTrainAccuracy() + "\n";
        text = text + "Kappa: " + this.getKappa() + "\n";
        text = text + "Kappa (Training): " + this.getTrainKappa() + "\n";
        text = text + "Unclassified instances: " + this.unclassified + "\n";
        text = text + "Unclassified instances (Training): " + this.trainUnclassified + "\n";
        double redIS = 1.0 - (double)this.trainData.length / (double)this.referenceData.length;
        double redFS = 1.0 - (double)this.inputAtt / (double)this.referenceData[0].length;
        double redIFS = 1.0 - (double)this.trainData.length / (double)this.referenceData.length * ((double)this.inputAtt / (double)this.referenceData[0].length);
        text = text + "Reduction (instances): " + redIS + "\n";
        text = text + "Reduction (features): " + redFS + "\n";
        text = text + "Reduction (both): " + redIFS + "\n";
        text = text + "Model time: " + this.modelTime + " s\n";
        text = text + "Training time: " + this.trainingTime + " s\n";
        text = text + "Test time: " + this.testTime + " s\n";
        int nRules = this.writeRules();
        text = text + "Number of rules: " + nRules + " s\n";
        text = text + "Confussion Matrix:\n";
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.nClasses; ++j) {
                text = text + this.confMatrix[i][j] + "\t";
            }
            text = text + "\n";
        }
        text = text + "\n";
        text = text + "Training Confussion Matrix:\n";
        for (i = 0; i < this.nClasses; ++i) {
            for (j = 0; j < this.nClasses; ++j) {
                text = text + this.trainConfMatrix[i][j] + "\t";
            }
            text = text + "\n";
        }
        text = text + "\n";
        text = text + "***Rules obtained****";
        text = text + this.ruleSetText;
        Files.writeFile(this.outFile[2], text);
    }

    protected abstract int writeRules();

    private void computeConfussionMatrixes() {
        int i;
        this.confMatrix = new int[this.nClasses][this.nClasses];
        this.trainConfMatrix = new int[this.nClasses][this.nClasses];
        this.unclassified = 0;
        for (i = 0; i < this.nClasses; ++i) {
            Arrays.fill(this.confMatrix[i], 0);
        }
        for (i = 0; i < this.prediction.length; ++i) {
            if (this.prediction[i][0] == -1) {
                ++this.unclassified;
                continue;
            }
            int[] nArray = this.confMatrix[this.prediction[i][0]];
            int n = this.realClass[i][0];
            nArray[n] = nArray[n] + 1;
        }
        this.trainUnclassified = 0;
        for (i = 0; i < this.nClasses; ++i) {
            Arrays.fill(this.trainConfMatrix[i], 0);
        }
        for (i = 0; i < this.trainPrediction.length; ++i) {
            if (this.trainPrediction[i][0] == -1) {
                ++this.trainUnclassified;
                continue;
            }
            int[] nArray = this.trainConfMatrix[this.trainPrediction[i][0]];
            int n = this.trainRealClass[i][0];
            nArray[n] = nArray[n] + 1;
        }
    }

    private double getAccuracy() {
        int count = 0;
        for (int i = 0; i < this.nClasses; ++i) {
            count += this.confMatrix[i][i];
        }
        double acc = (double)count / (double)this.test.getNumInstances();
        return acc;
    }

    private double getTrainAccuracy() {
        int count = 0;
        for (int i = 0; i < this.nClasses; ++i) {
            count += this.trainConfMatrix[i][i];
        }
        double acc = (double)count / (double)this.train.getNumInstances();
        return acc;
    }

    private double getKappa() {
        int i;
        int count = 0;
        for (i = 0; i < this.nClasses; ++i) {
            count += this.confMatrix[i][i];
        }
        double agreement = (double)count / (double)this.test.getNumInstances();
        double expected = 0.0;
        for (i = 0; i < this.nClasses; ++i) {
            count = 0;
            int count2 = 0;
            for (int j = 0; j < this.nClasses; ++j) {
                count += this.confMatrix[i][j];
                count2 += this.confMatrix[j][i];
            }
            double prob1 = (double)count / (double)this.test.getNumInstances();
            double prob2 = (double)count2 / (double)this.test.getNumInstances();
            expected += prob1 * prob2;
        }
        double kappa = (agreement - expected) / (1.0 - expected);
        return kappa;
    }

    private double getTrainKappa() {
        int i;
        int count = 0;
        for (i = 0; i < this.nClasses; ++i) {
            count += this.trainConfMatrix[i][i];
        }
        double agreement = (double)count / (double)this.train.getNumInstances();
        double expected = 0.0;
        for (i = 0; i < this.nClasses; ++i) {
            count = 0;
            int count2 = 0;
            for (int j = 0; j < this.nClasses; ++j) {
                count += this.trainConfMatrix[i][j];
                count2 += this.trainConfMatrix[j][i];
            }
            double prob1 = (double)count / (double)this.train.getNumInstances();
            double prob2 = (double)count2 / (double)this.train.getNumInstances();
            expected += prob1 * prob2;
        }
        double kappa = (agreement - expected) / (1.0 - expected);
        return kappa;
    }
}

