/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import weka.core.WekaException;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseSimpleDataVisualizer;
import weka.knowledgeflow.steps.KFStep;

@KFStep(name="GraphViewer", category="Visualization", toolTipText="Visualize graph output from Drawable schemes", iconPath="weka/gui/knowledgeflow/icons/DefaultGraph.gif")
public class GraphViewer
extends BaseSimpleDataVisualizer {
    private static final long serialVersionUID = -3256888744740965144L;

    @Override
    public List<String> getIncomingConnectionTypes() {
        return Arrays.asList("graph");
    }

    @Override
    public List<String> getOutgoingConnectionTypes() {
        return this.getStepManager().numIncomingConnections() > 0 ? Arrays.asList("text") : null;
    }

    @Override
    public void processIncoming(Data data) throws WekaException {
        this.getStepManager().processing();
        String graphTitle = (String)data.getPayloadElement("graph_title");
        this.getStepManager().logDetailed(graphTitle);
        this.m_data.add(data);
        Data textOut = new Data("text", data.getPrimaryPayload());
        textOut.setPayloadElement("aux_textTitle", graphTitle);
        this.getStepManager().outputData(textOut);
        this.getStepManager().finished();
    }

    @Override
    public Map<String, String> getInteractiveViewers() {
        LinkedHashMap<String, String> views = new LinkedHashMap<String, String>();
        if (this.m_data.size() > 0) {
            views.put("Show plots", "weka.gui.knowledgeflow.steps.GraphViewerInteractiveView");
        }
        return views;
    }
}

