/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uno.informatics.data.DataType;
import uno.informatics.data.Scale;
import uno.informatics.data.ScaleType;
import uno.informatics.data.pojo.EntityPojo;

public class ScalePojo
extends EntityPojo
implements Scale {
    private static final long serialVersionUID = 1L;
    private static final String DATA_TYPE_PROPERTY = Scale.class.getName() + ".dataType";
    private static final String SCALE_TYPE_PROPERTY = Scale.class.getName() + ".scaleType";
    private static final String MAXIMUM_VALUE_PROPERTY = Scale.class.getName() + ".maximumValue";
    private static final String MINIMUM_VALUE_PROPERTY = Scale.class.getName() + ".minimumValue";
    private static final String VALUES_PROPERTY = Scale.class.getName() + ".values";
    private List<Object> values = null;
    private Map<Object, Integer> index = null;
    private DataType dataType;
    private ScaleType scaleType;
    private Number maximumValue;
    private Number minimumValue;

    public ScalePojo(String name) {
        this(name, DataType.STRING, ScaleType.NOMINAL);
    }

    public ScalePojo(String uniqueIdentifier, String name) {
        this(uniqueIdentifier, name, DataType.STRING, ScaleType.NOMINAL);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description) {
        this(uniqueIdentifier, name, description, DataType.STRING, ScaleType.NOMINAL);
    }

    public ScalePojo(String name, DataType dataType, ScaleType scaleType) {
        super(name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
    }

    public ScalePojo(String name, DataType dataType, ScaleType scaleType, Number minimum, Number maximum) {
        super(name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, Number minimum, Number maximum) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, Number minimum, Number maximum) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
    }

    public ScalePojo(String uniqueIdentifier, DataType dataType, ScaleType scaleType, List<? extends Object> values) {
        super(uniqueIdentifier);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, List<? extends Object> values) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, List<? extends Object> values) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, DataType dataType, ScaleType scaleType, Object[] values) {
        super(uniqueIdentifier);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, Object[] values) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, Object[] values) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, List<Object> values) {
        super(uniqueIdentifier);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, List<Object> values) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, List<Object> values) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, Object[] values) {
        super(uniqueIdentifier);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, Object[] values) {
        super(uniqueIdentifier, name);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
        this.setValues(values);
    }

    public ScalePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, Number minimum, Number maximum, Object[] values) {
        super(uniqueIdentifier, name, description);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setMinimumValue(minimum);
        this.setMaximumValue(maximum);
        this.setValues(values);
    }

    public ScalePojo(Scale scale) {
        super(scale);
        this.setDataType(scale.getDataType());
        this.setScaleType(scale.getScaleType());
        this.setMinimumValue(scale.getMinimumValue());
        this.setMaximumValue(scale.getMaximumValue());
        this.setValues(scale.getValues());
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final void setDataType(DataType dataType) {
        if (dataType != null) {
            DataType oldValue = this.dataType;
            this.dataType = dataType;
            this.getPropertyChangeSupport().firePropertyChange(DATA_TYPE_PROPERTY, (Object)oldValue, (Object)this.dataType);
        }
    }

    @Override
    public ScaleType getScaleType() {
        return this.scaleType;
    }

    @Override
    public final void setScaleType(ScaleType scaleType) {
        if (scaleType != null) {
            ScaleType oldValue = this.scaleType;
            this.scaleType = scaleType;
            this.getPropertyChangeSupport().firePropertyChange(SCALE_TYPE_PROPERTY, (Object)oldValue, (Object)this.scaleType);
        }
    }

    @Override
    public final Number getMaximumValue() {
        return this.maximumValue;
    }

    @Override
    public final void setMaximumValue(Number maximumValue) {
        if (maximumValue != null && this.scaleType == ScaleType.NOMINAL) {
            throw new IllegalArgumentException("Maximum Value can not be set if the scale type is Nominal");
        }
        Number oldValue = this.maximumValue;
        this.maximumValue = maximumValue;
        this.getPropertyChangeSupport().firePropertyChange(MAXIMUM_VALUE_PROPERTY, oldValue, this.maximumValue);
    }

    @Override
    public final Number getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public final void setMinimumValue(Number minimumValue) {
        if (minimumValue != null && this.scaleType == ScaleType.NOMINAL) {
            throw new IllegalArgumentException("Minimum Value can not be set if the scale type is Nominal");
        }
        Number oldValue = this.minimumValue;
        this.minimumValue = minimumValue;
        this.getPropertyChangeSupport().firePropertyChange(MINIMUM_VALUE_PROPERTY, oldValue, this.minimumValue);
    }

    @Override
    public final List<Object> getValues() {
        return this.values;
    }

    @Override
    public int indexOf(Object value) {
        return this.index.getOrDefault(value, -1);
    }

    @Override
    public final void setValues(List<? extends Object> values) {
        if (values != null && !values.isEmpty() && this.scaleType == ScaleType.RATIO) {
            throw new IllegalArgumentException("Values can not be set if the scale type is Ratio");
        }
        List<Object> oldValue = this.values;
        this.values = this.createList(values);
        this.index = new HashMap<Object, Integer>();
        for (int i = 0; i < this.values.size(); ++i) {
            this.index.put(this.values.get(i), i);
        }
        this.getPropertyChangeSupport().firePropertyChange(VALUES_PROPERTY, oldValue, this.values);
    }

    public final void setValues(Object[] values) {
        this.setValues(Arrays.asList(values));
    }

    public void addValue(Object value) {
        if (value != null) {
            if (this.values == null) {
                this.values = new ArrayList<Object>();
            }
            if (!this.values.contains(value)) {
                this.values.add(value);
                this.index.put(value, this.values.size() - 1);
            }
        }
    }

    private List<Object> createList(List<? extends Object> values) {
        ArrayList<Object> list;
        if (values != null) {
            list = new ArrayList(values.size());
            for (Object object : values) {
                if (list.contains(object)) continue;
                list.add(object);
            }
        } else {
            list = new ArrayList<Object>();
        }
        return list;
    }
}

