/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.contrasts;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.commons.Localizer;
import org.af.commons.widgets.WidgetFactory;
import org.af.jhlir.call.RDataFrame;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatMethodDialog
extends JDialog
implements ActionListener {
    protected static Localizer localizer = Localizer.getInstance();
    private List<Object> labels;
    private List<Component> components;
    protected RDataFrame df;
    private List<String> violatedConstraints = new ArrayList<String>();
    protected static final Log logger = LogFactory.getLog(StatMethodDialog.class);

    public StatMethodDialog(JFrame owner, String title, RDataFrame df) {
        super((Frame)owner, title);
        this.df = df;
        this.checkConstraints();
        if (this.violatedConstraints.size() > 0) {
            String msg = localizer.getString("SHARED_DIALOG_COULDNOTOPEN");
            for (int i = 0; i < this.violatedConstraints.size(); ++i) {
                msg = msg + (i + 1) + ".\n" + this.violatedConstraints.get(i) + "\n\n";
            }
        }
    }

    public void setContent(Object[] labels, Component[] components) {
        this.setContent(Arrays.asList(labels), Arrays.asList(components));
    }

    public void setContent(List<Object> labels, List<Component> components) {
        this.labels = new Vector<Object>(labels);
        this.components = new Vector<Component>(components);
    }

    public void removeContent(Component comp) {
        int nr = this.components.indexOf(comp);
        this.labels.remove(nr);
        this.components.remove(nr);
    }

    public void insertContent(int index, String label, Component comp) {
        this.labels.add(index, label);
        this.components.add(index, comp);
    }

    public void setup() {
        this.doTheLayout();
        this.pack();
        WidgetFactory.showCompleteTitle((JDialog)this);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    protected void doTheLayout() {
        JPanel p = this.makeMainDialogPanel();
        p = WidgetFactory.makeDialogPanelWithButtons((Container)p, (ActionListener)this);
        this.setContentPane(p);
    }

    private JPanel makeMainDialogPanel() {
        String cols = "5dlu, pref, 4dlu, pref:grow, 5dlu";
        String rows = "";
        for (int i = 0; i < this.components.size(); ++i) {
            rows = this.components.get(i) instanceof JScrollPane ? rows + "5dlu, fill:default:grow, " : rows + "5dlu, pref, ";
        }
        rows = rows + "5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        JPanel panel = new JPanel((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        for (int i = 0; i < this.labels.size(); ++i) {
            Object label = this.labels.get(i);
            Component comp = this.components.get(i);
            if (label != null) {
                if (label instanceof Component) {
                    panel.add((Component)label, cc.xy(2, 2 + i * 2));
                } else {
                    panel.add((Component)new JLabel(label.toString()), cc.xy(2, 2 + i * 2));
                }
                panel.add(comp, cc.xy(4, 2 + i * 2));
                continue;
            }
            panel.add(comp, cc.xyw(2, 2 + i * 2, 3));
        }
        return panel;
    }

    protected void onOk() throws RemoteException {
    }

    protected void onCancel() {
        this.dispose();
    }

    protected void checkConstraints() {
    }

    protected void requiresNumVar() {
        this.requiresNumVars(1);
    }

    protected void requiresIntVar() {
        this.requiresIntVars(1);
    }

    protected void requiresFactVar() {
        this.requiresFactVars(1);
    }

    protected void requiresNumVars(int n) {
        int k = this.df.getNumberVars().size();
        if (k < n) {
            if (n == 1) {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_NUMVAR"));
            } else {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_NUMVARS1") + n + "\n" + localizer.getString("SHARED_DIALOG_NUMVARS2") + k);
            }
        }
    }

    protected void requiresVars(int n) {
        int k = this.df.getColumnCount();
        if (k < n) {
            if (n == 1) {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_VAR"));
            } else {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_VARS1") + n + "\n" + localizer.getString("SHARED_DIALOG_VARS2") + k);
            }
        }
    }

    protected void requiresFactVars(int n) {
        int k = this.df.getFactorVars().size();
        if (k < n) {
            if (n == 1) {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_FACTORVAR"));
            } else {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_FACTORVARS1") + n + "\n" + localizer.getString("SHARED_DIALOG_FACTORVARS2") + k);
            }
        }
    }

    protected void requiresIntVars(int n) {
        int k = this.df.getIntegerVars().size();
        if (k < n) {
            if (n == 1) {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_INTVAR"));
            } else {
                this.violatedConstraints.add(localizer.getString("SHARED_DIALOG_INTVARS1") + n + "\n" + localizer.getString("SHARED_DIALOG_INTVARS2") + k);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            try {
                this.onOk();
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.onCancel();
        }
    }

    public RDataFrame getDataFrame() {
        return this.df;
    }
}

