/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.regex.Pattern;

public class LineGroupIterator
implements Iterator<Instance> {
    LineNumberReader reader;
    Pattern lineBoundaryRegex;
    boolean skipBoundary;
    String nextLineGroup;
    String nextBoundary;
    String nextNextBoundary;
    int groupIndex = 0;
    boolean putBoundaryInSource = true;

    public LineGroupIterator(Reader input, Pattern lineBoundaryRegex, boolean skipBoundary) {
        this.reader = new LineNumberReader(input);
        this.lineBoundaryRegex = lineBoundaryRegex;
        this.skipBoundary = skipBoundary;
        this.setNextLineGroup();
    }

    public String peekLineGroup() {
        return this.nextLineGroup;
    }

    private void setNextLineGroup() {
        StringBuffer sb = new StringBuffer();
        if (!this.skipBoundary && this.nextBoundary != null) {
            sb.append(this.nextBoundary + System.getProperty("line.separator"));
        }
        while (true) {
            String line;
            try {
                line = this.reader.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (line == null) break;
            if (this.lineBoundaryRegex.matcher(line).matches()) {
                if (sb.length() > 0) {
                    this.nextBoundary = this.nextNextBoundary;
                    this.nextNextBoundary = line;
                    break;
                }
                if (!this.skipBoundary) {
                    sb.append(line + System.getProperty("line.separator"));
                }
                this.nextNextBoundary = line;
                continue;
            }
            sb.append(line);
            sb.append(System.getProperty("line.separator"));
        }
        this.nextLineGroup = sb.length() == 0 ? null : sb.toString();
    }

    @Override
    public Instance next() {
        assert (this.nextLineGroup != null);
        Instance carrier = new Instance(this.nextLineGroup, null, "linegroup" + this.groupIndex++, this.putBoundaryInSource ? this.nextBoundary : null);
        this.setNextLineGroup();
        return carrier;
    }

    @Override
    public boolean hasNext() {
        return this.nextLineGroup != null;
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

