/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.tsf;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class WordVectors
extends Pipe
implements Serializable {
    String prefix;
    HashMap<String, double[]> wordVectors;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    public WordVectors(String prefix, File vectorsFile) throws IOException {
        String line;
        this.prefix = prefix;
        this.wordVectors = new HashMap();
        BufferedReader in = new BufferedReader(new FileReader(vectorsFile));
        while ((line = in.readLine()) != null) {
            String[] fields = line.split("\\s+");
            String word = fields[0];
            double[] vector = new double[fields.length - 1];
            for (int i = 0; i < vector.length; ++i) {
                vector[i] = Double.parseDouble(fields[i + 1]);
            }
            this.wordVectors.put(word, vector);
        }
        in.close();
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence tokens = (TokenSequence)carrier.getData();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = (Token)tokens.get(i);
            String s = token.getText().toLowerCase();
            if (!this.wordVectors.containsKey(s)) continue;
            double[] vector = this.wordVectors.get(s);
            for (int j = 0; j < vector.length; ++j) {
                token.setFeatureValue(this.prefix + j, vector[j]);
            }
        }
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        out.writeObject(this.wordVectors);
        out.writeObject(this.prefix);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.wordVectors = (HashMap)in.readObject();
        this.prefix = (String)in.readObject();
    }
}

