/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.tree;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.dmg.pmml.tree.ComplexNode;
import org.dmg.pmml.tree.HasNode;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.dmg.pmml.tree.PMMLElements;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="TreeModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "node", "modelVerification"})
@JsonRootName(value="TreeModel")
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "missingValueStrategy", "missingValuePenalty", "noTrueChildStrategy", "splitCharacteristic", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "node", "modelVerification"})
public class TreeModel
extends Model
implements HasExtensions<TreeModel>,
HasNode<TreeModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="missingValueStrategy")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="missingValueStrategy")
    private MissingValueStrategy missingValueStrategy;
    @XmlAttribute(name="missingValuePenalty")
    @XmlJavaTypeAdapter(value=ProbabilityNumberAdapter.class)
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="missingValuePenalty")
    private Number missingValuePenalty;
    @XmlAttribute(name="noTrueChildStrategy")
    @Added(value=Version.PMML_3_1)
    @JsonProperty(value="noTrueChildStrategy")
    private NoTrueChildStrategy noTrueChildStrategy;
    @XmlAttribute(name="splitCharacteristic")
    @JsonProperty(value="splitCharacteristic")
    private SplitCharacteristic splitCharacteristic;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @Added(value=Version.XPMML)
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_4")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements(value={@XmlElement(name="Node", namespace="http://www.dmg.org/PMML-4_4", required=true, type=ComplexNode.class)})
    @JsonProperty(value="Node")
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE, defaultImpl=ComplexNode.class)
    @JsonDeserialize(as=ComplexNode.class)
    private Node node;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Number DEFAULT_MISSING_VALUE_PENALTY = new ProbabilityNumberAdapter().unmarshal("1.0");
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371270L;

    public TreeModel() {
    }

    @ValueConstructor
    public TreeModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="node") Node node) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.node = node;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public TreeModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TREEMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public TreeModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public TreeModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public MissingValueStrategy getMissingValueStrategy() {
        if (this.missingValueStrategy == null) {
            return MissingValueStrategy.NONE;
        }
        return this.missingValueStrategy;
    }

    @Override
    public TreeModel setMissingValueStrategy(@Property(value="missingValueStrategy") MissingValueStrategy missingValueStrategy) {
        this.missingValueStrategy = missingValueStrategy;
        return this;
    }

    @Override
    public Number getMissingValuePenalty() {
        if (this.missingValuePenalty == null) {
            return DEFAULT_MISSING_VALUE_PENALTY;
        }
        return this.missingValuePenalty;
    }

    @Override
    public TreeModel setMissingValuePenalty(@Property(value="missingValuePenalty") Number missingValuePenalty) {
        this.missingValuePenalty = missingValuePenalty;
        return this;
    }

    @Override
    public NoTrueChildStrategy getNoTrueChildStrategy() {
        if (this.noTrueChildStrategy == null) {
            return NoTrueChildStrategy.RETURN_NULL_PREDICTION;
        }
        return this.noTrueChildStrategy;
    }

    @Override
    public TreeModel setNoTrueChildStrategy(@Property(value="noTrueChildStrategy") NoTrueChildStrategy noTrueChildStrategy) {
        this.noTrueChildStrategy = noTrueChildStrategy;
        return this;
    }

    @Override
    public SplitCharacteristic getSplitCharacteristic() {
        if (this.splitCharacteristic == null) {
            return SplitCharacteristic.MULTI_SPLIT;
        }
        return this.splitCharacteristic;
    }

    @Override
    public TreeModel setSplitCharacteristic(@Property(value="splitCharacteristic") SplitCharacteristic splitCharacteristic) {
        this.splitCharacteristic = splitCharacteristic;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public TreeModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public TreeModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public TreeModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.TREEMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public TreeModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public TreeModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public TreeModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public TreeModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public TreeModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public TreeModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Node requireNode() {
        if (this.node == null) {
            throw new MissingElementException(this, PMMLElements.TREEMODEL_NODE);
        }
        return this.node;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public TreeModel setNode(@Property(value="node") Node node) {
        this.node = node;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public TreeModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations(), this.getNode(), this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum SplitCharacteristic implements StringValue<SplitCharacteristic>
    {
        BINARY_SPLIT("binarySplit"),
        MULTI_SPLIT("multiSplit");

        private final String value;

        private SplitCharacteristic(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static SplitCharacteristic fromValue(String v) {
            for (SplitCharacteristic c : SplitCharacteristic.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum NoTrueChildStrategy implements StringValue<NoTrueChildStrategy>
    {
        RETURN_NULL_PREDICTION("returnNullPrediction"),
        RETURN_LAST_PREDICTION("returnLastPrediction");

        private final String value;

        private NoTrueChildStrategy(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static NoTrueChildStrategy fromValue(String v) {
            for (NoTrueChildStrategy c : NoTrueChildStrategy.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum MissingValueStrategy implements StringValue<MissingValueStrategy>
    {
        LAST_PREDICTION("lastPrediction"),
        NULL_PREDICTION("nullPrediction"),
        DEFAULT_CHILD("defaultChild"),
        WEIGHTED_CONFIDENCE("weightedConfidence"),
        AGGREGATE_NODES("aggregateNodes"),
        NONE("none");

        private final String value;

        private MissingValueStrategy(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static MissingValueStrategy fromValue(String v) {
            for (MissingValueStrategy c : MissingValueStrategy.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

