ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
               
sidebarLayout(
  sidebarPanel(width = 3,
  hr(),
  sliderInput("range.ln", 
              label = "Range:",
              min = 0, 
              max = 50, 
              value = c(0,20)),
  hr(),
  sliderInput("mu.ln", 
              label = HTML("Log[Mean] (ln[&mu;])"),
              min = 0, 
              max = 10, 
              step = 0.5, 
              value = 4, 
              animate = T),
  hr(),
  sliderInput("sig.ln", 
              label = HTML("log[Std Dev] (ln[&sigma;])"),
              min = .5, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = T)),

mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',
           metricsgraphicsOutput(height = "550px", "lnorC")),
  tabPanel('Density',
           metricsgraphicsOutput(height = "550px", "lnorP")),
  tabPanel('Survival',
           metricsgraphicsOutput(height = "550px", "lnorR")),
  tabPanel('Hazard',
           metricsgraphicsOutput(height = "550px", "lnorh")),
  tabPanel('Cumulative Hazard',
           metricsgraphicsOutput(height = "550px", "lnorH")),
  tabPanel('Quantile',
           metricsgraphicsOutput(height = "550px", "lnorQ"))))))
