/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.SimpleSiteList;
import dr.evolution.datatype.DataType;
import dr.evolution.util.TaxonList;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UncertainSiteList
extends SimpleSiteList
implements Citable {
    private List<double[][]> uncertainSitePatterns = new ArrayList<double[][]>();

    public UncertainSiteList(DataType dataType, TaxonList taxonList) {
        super(dataType, taxonList);
    }

    @Override
    public int addPattern(int[] nArray) {
        throw new IllegalArgumentException("Do not call directly");
    }

    public void addPattern(double[][] dArray) {
        this.uncertainSitePatterns.add(dArray);
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = UncertainSiteList.getMostProbable(dArray[i]);
        }
        super.addPattern(nArray);
    }

    private static int getMostProbable(double[] dArray) {
        int n = 0;
        double d = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > d)) continue;
            d = dArray[i];
            n = i;
        }
        return n;
    }

    public void fillPartials(int n, int n2, double[] dArray, int n3) {
        double[][] dArray2 = this.uncertainSitePatterns.get(n2);
        System.arraycopy(dArray2[n], 0, dArray, n3, this.getDataType().getStateCount());
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.DATA_MODELS;
    }

    @Override
    public String getDescription() {
        return "Uncertain site list";
    }

    @Override
    public List<Citation> getCitations() {
        return Arrays.asList(new Citation(new Author[]{new Author("MA", "Suchard"), new Author("P", "Lemey"), new Author("M", "Scotch")}, Citation.Status.IN_PREPARATION));
    }
}

