/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.BitSet;
import java.util.Set;

public class RestrictedPartials
extends AbstractModel {
    private final TreeModel treeModel;
    private final TaxonList taxonList;
    private final Set<Integer> tips;
    private final BitSet tipBitSet;
    private final Parameter meanParameter;
    private final Parameter priorSampleSize;
    private int index;
    private NodeRef node;

    public RestrictedPartials(String string, TreeModel treeModel, TaxonList taxonList, Parameter parameter, Parameter parameter2) throws TreeUtils.MissingTaxonException {
        this(string, treeModel, taxonList, parameter, parameter2, null, -1);
    }

    public RestrictedPartials(String string, TreeModel treeModel, TaxonList taxonList, Parameter parameter, Parameter parameter2, NodeRef nodeRef, int n) throws TreeUtils.MissingTaxonException {
        super(string);
        this.treeModel = treeModel;
        this.taxonList = taxonList;
        this.meanParameter = parameter;
        this.priorSampleSize = parameter2;
        this.index = n;
        this.node = nodeRef;
        this.tips = TreeUtils.getTipsForTaxa(treeModel, taxonList);
        this.tipBitSet = TreeUtils.getTipsBitSetForTaxa(treeModel, taxonList);
        this.addVariable(parameter);
        this.addVariable(parameter2);
    }

    final TreeModel getTreeModel() {
        return this.treeModel;
    }

    final double[] getPartials() {
        return this.meanParameter.getParameterValues();
    }

    final double getPartial(int n) {
        return this.meanParameter.getParameterValue(n);
    }

    final double getPriorSampleSize() {
        return this.priorSampleSize.getParameterValue(0);
    }

    final double[] getRestrictedPartials() {
        assert (false);
        return null;
    }

    final PrecisionType getPrecisionType() {
        assert (false);
        return PrecisionType.SCALAR;
    }

    final int getIndex() {
        return this.index;
    }

    final void setIndex(int n) {
        this.index = n;
    }

    final NodeRef getNode() {
        return this.node;
    }

    final void setNode(NodeRef nodeRef) {
        this.node = nodeRef;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(variable, n);
    }

    public TaxonList getTaxonList() {
        return this.taxonList;
    }

    public BitSet getTipBitSet() {
        return this.tipBitSet;
    }
}

