## ----results='hide', echo=FALSE, message=FALSE------------------------------------------------------------------------
library(crunch)
load("vignettes.RData")
options(width=120)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# # Using the `derive` argument in `VariableDefinition()`
# ds$force_materialized_age <- VariableDefinition(2015 - ds$birthyr, derived = FALSE)
# 
# # Using the `derive` argument in `deriveArray()`
# ds$force_materialiazed_array <- deriveArray(list(ds$v1, ds$v2), name = "v_arry", derived = FALSE)
# 
# # Could set the global default to FALSE (materialized)
# # set_crunch_opts(crunch.default.derived = FALSE)
# # (Note that the rest of this vignette assumes derived)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# ds$age <- 2015 - ds$birthyr

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# summary(ds$age)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
age.summary.before

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# summary(ds$birthyr)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
by.summary.before

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# class(2015 - ds$birthyr)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
class(cr.expr)

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# ds$birthyr[ds$birthyr < 1945] <- 1945

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# summary(ds$birthyr)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
by.summary.after

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# summary(ds$age)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
age.summary.after

## ----eval=FALSE-------------------------------------------------------------------------------------------------------
# class(ds$birthyr < 1945)

## ----echo=FALSE-------------------------------------------------------------------------------------------------------
class(cr.log.expr)

