## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.height = '451px'
)

## -----------------------------------------------------------------------------
  library(linevis)

  df_data = data.frame(x = c('2014-06-11',
                             '2014-06-12',
                             '2014-06-13',
                             '2014-06-14',
                             '2014-06-15',
                             '2014-06-16'),
                       y = c(0,
                             1,
                             30000,
                             10,
                             150,
                             30000))

## -----------------------------------------------------------------------------
  linevis(df_data)

## -----------------------------------------------------------------------------
  df_data$group = 0

  df_threshold = data.frame(x = c('2014-06-09', '2014-06-18'),
                            y = c(20, 20),
                            group = 1)

  df_data = rbind(df_data, df_threshold)

  df_group = data.frame(id = 0:1,
                        content = c('Time-serie', 'Threshold'),
                        className = c('grp1', 'grp2'))

## -----------------------------------------------------------------------------
  linevis(df_data, groups = df_group)

## -----------------------------------------------------------------------------
  linevis_options = list(min = '2014-06-11', max = '2014-06-18',
                         interpolation = FALSE,
                         legend = list(left = list(position = 'bottom-left')))

  linevis(df_data, groups = df_group, log_scale = TRUE,
          options = linevis_options)

