/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.logging;

import choco.kernel.common.logging.DetailedFormatter;
import choco.kernel.common.logging.LightFormatter;
import choco.kernel.common.logging.Verbosity;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public final class ChocoLogging {
    public static final String START_MESSAGE = "** CHOCO : Constraint Programming Solver\n** CHOCO v2.1.5 (August, 2012), Copyleft (c) 1999-2012";
    public static final Formatter LIGHT_FORMATTER = new LightFormatter();
    public static final Formatter DETAILED_FORMATTER = new DetailedFormatter();
    public static final Handler DEFAULT_HANDLER = new StreamHandler(System.out, LIGHT_FORMATTER);
    public static final Handler DETAILED_HANDLER = new StreamHandler(System.out, DETAILED_FORMATTER);
    public static final Handler ERROR_HANDLER = new StreamHandler(System.err, DETAILED_FORMATTER);
    public static final Logger[] CHOCO_LOGGERS = new Logger[]{Logger.getLogger("choco"), Logger.getLogger("choco.core"), Logger.getLogger("choco.core.engine"), Logger.getLogger("choco.core.search"), Logger.getLogger("choco.core.search.branching"), Logger.getLogger("choco.api"), Logger.getLogger("choco.api.main"), Logger.getLogger("choco.api.test")};
    private static int LOGGING_MAX_DEPTH;
    private static int EVERY_X_NODES;

    private static Verbosity loadProperties() {
        try {
            Integer verb;
            Properties properties = new Properties();
            InputStream is = ChocoLogging.class.getResourceAsStream("/verbosity.properties");
            properties.load(is);
            String key = "verbosity.level";
            if (!properties.isEmpty() && properties.containsKey("verbosity.level") && (verb = Integer.valueOf(Integer.parseInt(properties.getProperty("verbosity.level")))) >= 0 && verb <= 6) {
                return Verbosity.values()[verb];
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Verbosity.DEFAULT;
    }

    private ChocoLogging() {
    }

    public static final int getEveryXNodes() {
        return EVERY_X_NODES;
    }

    public static final void setEveryXNodes(int everyXnodes) {
        if (everyXnodes > 0) {
            EVERY_X_NODES = everyXnodes;
        }
    }

    public static final void setLoggingMaxDepth(int loggingMaxDepth) {
        if (loggingMaxDepth > 1) {
            LOGGING_MAX_DEPTH = loggingMaxDepth;
        }
    }

    public static final int getLoggingMaxDepth() {
        return LOGGING_MAX_DEPTH;
    }

    public static Logger makeUserLogger(String name) {
        return Logger.getLogger(ChocoLogging.getMainLogger().getName() + "." + name);
    }

    protected static Logger getChocoLogger() {
        return CHOCO_LOGGERS[0];
    }

    protected static Logger getCoreLogger() {
        return CHOCO_LOGGERS[1];
    }

    public static Logger getEngineLogger() {
        return CHOCO_LOGGERS[2];
    }

    public static Logger getSearchLogger() {
        return CHOCO_LOGGERS[3];
    }

    public static Logger getBranchingLogger() {
        return CHOCO_LOGGERS[4];
    }

    protected static Logger getAPILogger() {
        return CHOCO_LOGGERS[5];
    }

    public static Logger getMainLogger() {
        return CHOCO_LOGGERS[6];
    }

    public static Logger getTestLogger() {
        return CHOCO_LOGGERS[7];
    }

    public static Formatter getDefaultFormatter() {
        return LIGHT_FORMATTER;
    }

    public static void flushLog(Logger logger) {
        for (Handler h : logger.getHandlers()) {
            h.flush();
        }
    }

    public static void flushLogs() {
        for (Logger logger : CHOCO_LOGGERS) {
            ChocoLogging.flushLog(logger);
        }
    }

    protected static void clearHandlers() {
        for (Logger logger : CHOCO_LOGGERS) {
            ChocoLogging.clearHandlers(logger);
        }
    }

    protected static void clearHandlers(Logger logger) {
        logger.setUseParentHandlers(true);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
    }

    public static void setDefaultHandler() {
        ChocoLogging.clearHandlers();
        Logger log = ChocoLogging.getChocoLogger();
        log.setUseParentHandlers(false);
        log.addHandler(DEFAULT_HANDLER);
        log.addHandler(ERROR_HANDLER);
    }

    public static void setLevel(Level level, Handler ... handlers) {
        for (Handler h : handlers) {
            h.setLevel(level);
        }
    }

    public static OutputStream setFileHandler(File file, Level level, Formatter formatter) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            StreamHandler handler = new StreamHandler(stream, formatter);
            handler.setLevel(level);
            ChocoLogging.clearHandlers();
            Logger log = ChocoLogging.getChocoLogger();
            log.setUseParentHandlers(false);
            log.addHandler(handler);
            return stream;
        }
        catch (FileNotFoundException e) {
            ChocoLogging.getChocoLogger().log(Level.SEVERE, "cant create stream", e);
            return null;
        }
    }

    public static OutputStream setErrorFileHandler(File file) {
        return ChocoLogging.setFileHandler(file, Level.WARNING, DETAILED_FORMATTER);
    }

    public static OutputStream setFileHandler(File file) {
        return ChocoLogging.setFileHandler(file, Level.ALL, LIGHT_FORMATTER);
    }

    public static void setHandler(Logger logger, Handler handler) {
        ChocoLogging.clearHandlers(logger);
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
    }

    protected static void addHandler(Handler handler, Logger ... loggers) {
        for (Logger logger : loggers) {
            if (logger.getUseParentHandlers()) continue;
            logger.addHandler(handler);
        }
    }

    public static OutputStream addFileHandler(File file, Level level, Formatter formatter) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            StreamHandler handler = new StreamHandler(stream, formatter);
            handler.setLevel(level);
            ChocoLogging.addHandler(handler, CHOCO_LOGGERS);
            return stream;
        }
        catch (FileNotFoundException e) {
            ChocoLogging.getChocoLogger().log(Level.SEVERE, "cant create stream", e);
            return null;
        }
    }

    public static OutputStream addErrorFileHandler(File file) {
        return ChocoLogging.addFileHandler(file, Level.WARNING, DETAILED_FORMATTER);
    }

    public static OutputStream addFileHandler(File file) {
        return ChocoLogging.addFileHandler(file, Level.ALL, LIGHT_FORMATTER);
    }

    public static void setLevel(Level level, Logger logger) {
        logger.setLevel(level);
    }

    public static void setLevel(Level level, Logger ... loggers) {
        for (Logger logger : loggers) {
            logger.setLevel(level);
        }
    }

    public static void toSilent() {
        ChocoLogging.setVerbosity(Verbosity.SILENT);
    }

    public static void toQuiet() {
        ChocoLogging.setVerbosity(Verbosity.QUIET);
    }

    public static void toDefault() {
        ChocoLogging.setVerbosity(Verbosity.DEFAULT);
    }

    public static void toVerbose() {
        ChocoLogging.setVerbosity(Verbosity.VERBOSE);
    }

    public static void toSolution() {
        ChocoLogging.setVerbosity(Verbosity.SOLUTION);
    }

    public static void toSearch() {
        ChocoLogging.setVerbosity(Verbosity.SEARCH);
    }

    public static void setVerbosity(Verbosity verbosity) {
        if (verbosity == Verbosity.OFF) {
            ChocoLogging.setLevel(Level.OFF, CHOCO_LOGGERS);
        } else if (verbosity == Verbosity.FINEST) {
            ChocoLogging.setLevel(Level.FINEST, CHOCO_LOGGERS);
        } else {
            ChocoLogging.setLevel(Level.FINEST, ChocoLogging.getChocoLogger(), ChocoLogging.getCoreLogger(), ChocoLogging.getAPILogger());
            switch (verbosity) {
                case SILENT: {
                    ChocoLogging.setLevel(Level.SEVERE, ChocoLogging.getEngineLogger(), ChocoLogging.getSearchLogger(), ChocoLogging.getBranchingLogger());
                    ChocoLogging.setLevel(Level.WARNING, ChocoLogging.getMainLogger(), ChocoLogging.getTestLogger());
                    break;
                }
                case QUIET: {
                    ChocoLogging.setLevel(Level.WARNING, ChocoLogging.getEngineLogger(), ChocoLogging.getSearchLogger(), ChocoLogging.getBranchingLogger());
                    ChocoLogging.setLevel(Level.INFO, ChocoLogging.getMainLogger(), ChocoLogging.getTestLogger());
                    break;
                }
                case DEFAULT: {
                    ChocoLogging.setLevel(Level.WARNING, ChocoLogging.getEngineLogger(), ChocoLogging.getBranchingLogger());
                    ChocoLogging.setLevel(Level.INFO, ChocoLogging.getMainLogger(), ChocoLogging.getSearchLogger(), ChocoLogging.getTestLogger());
                    break;
                }
                case VERBOSE: {
                    ChocoLogging.setLevel(Level.INFO, ChocoLogging.getEngineLogger(), ChocoLogging.getBranchingLogger());
                    ChocoLogging.setLevel(Level.CONFIG, ChocoLogging.getMainLogger(), ChocoLogging.getSearchLogger(), ChocoLogging.getTestLogger());
                    ChocoLogging.setLevel(Level.FINE, ChocoLogging.getSearchLogger());
                    break;
                }
                case SOLUTION: {
                    ChocoLogging.setLevel(Level.INFO, ChocoLogging.getBranchingLogger());
                    ChocoLogging.setLevel(Level.CONFIG, ChocoLogging.getEngineLogger(), ChocoLogging.getTestLogger());
                    ChocoLogging.setLevel(Level.FINER, ChocoLogging.getMainLogger(), ChocoLogging.getSearchLogger());
                    break;
                }
                case SEARCH: {
                    ChocoLogging.setLevel(Level.CONFIG, ChocoLogging.getBranchingLogger(), ChocoLogging.getTestLogger());
                    ChocoLogging.setLevel(Level.FINER, ChocoLogging.getEngineLogger());
                    ChocoLogging.setLevel(Level.FINEST, ChocoLogging.getMainLogger(), ChocoLogging.getSearchLogger());
                    break;
                }
                default: {
                    ChocoLogging.setVerbosity(Verbosity.VERBOSE);
                }
            }
        }
    }

    public static final String toDotty() {
        int i;
        StringBuilder b = new StringBuilder();
        TObjectIntHashMap<Logger> indexMap = new TObjectIntHashMap<Logger>(CHOCO_LOGGERS.length);
        for (i = 0; i < CHOCO_LOGGERS.length; ++i) {
            indexMap.put(CHOCO_LOGGERS[i], i);
            String name = CHOCO_LOGGERS[i].getName();
            int idx = name.lastIndexOf(46);
            if (idx != -1) {
                name = name.substring(idx + 1);
            }
            b.append(i).append("[ shape=record, label=\"{");
            b.append(name).append("|").append(CHOCO_LOGGERS[i].getLevel());
            b.append("}\"]");
        }
        for (i = 1; i < CHOCO_LOGGERS.length; ++i) {
            b.append(indexMap.get(CHOCO_LOGGERS[i].getParent()));
            b.append(" -> ").append(i).append('\n');
        }
        return new String(b);
    }

    public static void main(String[] args) {
        System.out.println(ChocoLogging.toDotty());
    }

    static {
        try {
            ChocoLogging.setLevel(Level.ALL, DEFAULT_HANDLER, DETAILED_HANDLER);
            ChocoLogging.setLevel(Level.WARNING, ERROR_HANDLER);
            ChocoLogging.setDefaultHandler();
            ChocoLogging.setVerbosity(ChocoLogging.loadProperties());
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        LOGGING_MAX_DEPTH = 25;
        EVERY_X_NODES = 2000;
    }
}

