/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.hybrid;

import java.util.ArrayList;
import java.util.List;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.extension.hybrid.ASupport;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;

public interface ISupportable {
    public boolean satisfiable(ASupport[] var1, int var2);

    public void support(ASupport[] var1, int var2);

    public static class Many
    implements ISupportable {
        final List<ISupportable> exps;
        ASupport.AndSupport andSup = new ASupport.AndSupport();
        ASupport[] copy = null;

        Many() {
            this.exps = new ArrayList<ISupportable>();
        }

        public void push(ISupportable e) {
            this.exps.add(e);
        }

        @Override
        public boolean satisfiable(ASupport[] vs, int i) {
            if (this.copy == null) {
                this.copy = new ASupport[vs.length];
                System.arraycopy(vs, 0, this.copy, 0, vs.length);
            }
            this.andSup.setVar(vs[i].getVar());
            ASupport old = vs[i];
            this.copy[i] = this.andSup;
            for (int j = 0; j < this.exps.size(); ++j) {
                this.exps.get(j).support(this.copy, i);
                this.andSup.filter();
            }
            this.copy[i] = old;
            return this.andSup.and.cardinality() > 0;
        }

        @Override
        public void support(ASupport[] vs, int i) {
            this.andSup.transferTo(vs[i]);
        }

        public static Many merge(ISupportable h1, ISupportable h2) {
            Many m;
            if (h1 instanceof Many) {
                m = (Many)h1;
                if (h2 instanceof Many) {
                    Many m2 = (Many)h2;
                    for (int i = 0; i < m2.exps.size(); ++i) {
                        m.push(m2.exps.get(i));
                    }
                } else if (!(h2 instanceof UnAny)) {
                    m.push(h2);
                }
            } else if (h2 instanceof Many) {
                m = (Many)h2;
                if (!(h1 instanceof UnAny)) {
                    m.push(h2);
                }
            } else {
                m = new Many();
                if (!(h1 instanceof UnAny)) {
                    m.push(h1);
                }
                if (!(h2 instanceof UnAny)) {
                    m.push(h2);
                }
            }
            return m;
        }
    }

    public static class NaLqXYC
    extends Nary {
        NaLqXYC(int i0, int i1, int a) {
            super(a, new int[]{i0, i1});
        }

        @Override
        public boolean satisfiable(ASupport[] vs, int idx) {
            if (idx == this.is[0]) {
                int j = this.is[1];
                return vs[idx].getVar().getLB() <= vs[j].getVar().getUB() + this.cste;
            }
            int j = this.is[0];
            return vs[j].getVar().getLB() <= vs[idx].getVar().getUB() + this.cste;
        }

        @Override
        public void support(ASupport[] vs, int idx) {
            if (idx == this.is[0]) {
                int j = this.is[1];
                int ub = vs[j].getVar().getUB() + this.cste;
                int a = vs[idx].getVar().getLB();
                while (a <= ub) {
                    vs[idx].support(a);
                    a = vs[idx].getVar().nextValue(a);
                }
            } else {
                int j = this.is[0];
                int lb = Math.max(vs[idx].getVar().getLB(), vs[j].getVar().getLB() - this.cste);
                int ub = vs[idx].getVar().getUB();
                int a = vs[idx].getVar().nextValue(lb - 1);
                while (a <= ub) {
                    vs[idx].support(a);
                    a = vs[idx].getVar().nextValue(a);
                }
            }
        }
    }

    public static class NaGqXYC
    extends Nary {
        NaGqXYC(int i0, int i1, int a) {
            super(a, new int[]{i0, i1});
        }

        @Override
        public boolean satisfiable(ASupport[] vs, int idx) {
            if (idx == this.is[0]) {
                int j = this.is[1];
                return vs[idx].getVar().getUB() >= vs[j].getVar().getLB() + this.cste;
            }
            int j = this.is[0];
            return vs[j].getVar().getUB() >= vs[idx].getVar().getLB() + this.cste;
        }

        @Override
        public void support(ASupport[] vs, int idx) {
            if (idx == this.is[0]) {
                int j = this.is[1];
                int lb = vs[j].getVar().getLB() + this.cste;
                int ub = vs[idx].getVar().getUB();
                int a = vs[idx].getVar().nextValue(lb - 1);
                while (a <= ub) {
                    vs[idx].support(a);
                    a = vs[idx].getVar().nextValue(a);
                }
            } else {
                int j = this.is[0];
                int ub = Math.min(vs[idx].getVar().getUB(), vs[j].getVar().getUB() - this.cste);
                int a = vs[idx].getVar().getLB();
                while (a <= ub) {
                    vs[idx].support(a);
                    a = vs[idx].getVar().nextValue(a);
                }
            }
        }
    }

    public static class NaNqXYC
    extends Nary {
        NaNqXYC(int i0, int i1, int a) {
            super(a, new int[]{i0, i1});
        }

        @Override
        public boolean satisfiable(ASupport[] vs, int idx) {
            int j = this.is[1];
            int c = this.cste;
            if (idx == this.is[1]) {
                j = this.is[0];
                c = -this.cste;
            }
            if (vs[j].getVar().isInstantiated()) {
                return !vs[idx].getVar().isInstantiatedTo(vs[j].getVar().getValue() + c);
            }
            return true;
        }

        @Override
        public void support(ASupport[] vs, int idx) {
            int j = this.is[1];
            int c = this.cste;
            if (idx == this.is[1]) {
                j = this.is[0];
                c = -this.cste;
            }
            if (vs[j].getVar().isInstantiated()) {
                int vj = vs[j].getVar().getValue() + c;
                int ub = vs[idx].getVar().getUB();
                int val = vs[idx].getVar().getLB();
                while (val <= ub) {
                    if (val != vj) {
                        vs[idx].support(val);
                    }
                    val = vs[idx].getVar().nextValue(val);
                }
            } else {
                vs[idx].supportAll();
            }
        }
    }

    public static class NaEqXYC
    extends Nary {
        NaEqXYC(int i0, int i1, int a) {
            super(a, new int[]{i0, i1});
        }

        @Override
        public boolean satisfiable(ASupport[] vs, int idx) {
            int j = this.is[1];
            int c = this.cste;
            if (idx == this.is[1]) {
                j = this.is[0];
                c = -this.cste;
            }
            int sm = idx;
            int la = j;
            if (vs[idx].getVar().getDomainSize() > vs[j].getVar().getDomainSize()) {
                sm = j;
                la = idx;
                c *= -1;
            }
            int l = vs[sm].getVar().getLB();
            while (l <= vs[sm].getVar().getUB()) {
                if (vs[la].getVar().contains(l + c)) {
                    return true;
                }
                l = vs[sm].getVar().nextValue(l);
            }
            return false;
        }

        @Override
        public void support(ASupport[] vs, int idx) {
            int j = this.is[1];
            int c = this.cste;
            if (idx == this.is[1]) {
                j = this.is[0];
                c = -this.cste;
            }
            int sm = idx;
            int la = j;
            int de = 0;
            if (vs[idx].getVar().getDomainSize() > vs[j].getVar().getDomainSize()) {
                sm = j;
                la = idx;
                de = c *= -1;
            }
            int l = vs[sm].getVar().getLB();
            while (l <= vs[sm].getVar().getUB()) {
                if (vs[la].getVar().contains(l + c)) {
                    vs[idx].support(l + de);
                }
                l = vs[sm].getVar().nextValue(l);
            }
        }
    }

    public static abstract class Nary
    implements ISupportable {
        final int cste;
        final int[] is;

        Nary(int cste, int[] indices) {
            this.cste = cste;
            this.is = indices;
        }
    }

    public static class UnXInS
    extends Unary {
        IntIterableRangeSet set;

        UnXInS(IntIterableRangeSet set) {
            super(0);
            this.set = set;
        }

        @Override
        public boolean satisfiable(ASupport v) {
            boolean intersect = false;
            if (v.getVar().getDomainSize() < this.set.size()) {
                int ub = v.getVar().getUB();
                int i = v.getVar().getLB();
                while (i <= ub && !intersect) {
                    intersect = this.set.contains(i);
                    i = v.getVar().nextValue(i);
                }
            } else {
                int max = this.set.max();
                int i = this.set.min();
                while (i <= max && !intersect) {
                    intersect = v.getVar().contains(i);
                    i = this.set.nextValue(i);
                }
            }
            return intersect;
        }

        @Override
        public void support(ASupport v) {
            int ub = v.getVar().getUB();
            int i = v.getVar().getLB();
            while (i <= ub) {
                if (this.set.contains(i)) {
                    v.support(i);
                }
                i = v.getVar().nextValue(i);
            }
        }
    }

    public static class UnGqXC
    extends Unary {
        UnGqXC(int cste) {
            super(cste);
        }

        @Override
        public boolean satisfiable(ASupport v) {
            return v.getVar().getUB() >= this.anInt;
        }

        @Override
        public void support(ASupport v) {
            int ub = v.getVar().getUB();
            int val = v.getVar().nextValue(this.anInt - 1);
            while (val <= ub) {
                v.support(val);
                val = v.getVar().nextValue(val);
            }
        }
    }

    public static class UnLqXC
    extends Unary {
        UnLqXC(int cste) {
            super(cste);
        }

        @Override
        public boolean satisfiable(ASupport v) {
            return v.getVar().getLB() <= this.anInt;
        }

        @Override
        public void support(ASupport v) {
            int ub = v.getVar().previousValue(this.anInt + 1);
            int val = v.getVar().getLB();
            while (val <= ub) {
                v.support(val);
                val = v.getVar().nextValue(val);
            }
        }
    }

    public static class UnNqXC
    extends Unary {
        UnNqXC(int cste) {
            super(cste);
        }

        @Override
        public boolean satisfiable(ASupport v) {
            return !v.getVar().isInstantiatedTo(this.anInt);
        }

        @Override
        public void support(ASupport v) {
            int ub = v.getVar().getUB();
            int val = v.getVar().getLB();
            while (val <= ub) {
                if (val != this.anInt) {
                    v.support(val);
                }
                val = v.getVar().nextValue(val);
            }
        }
    }

    public static class UnEqXC
    extends Unary {
        UnEqXC(int cste) {
            super(cste);
        }

        @Override
        public boolean satisfiable(ASupport v) {
            return v.getVar().contains(this.anInt);
        }

        @Override
        public void support(ASupport v) {
            v.support(this.anInt);
        }
    }

    public static class UnCol
    extends Unary {
        int inc;
        Operator op;

        UnCol(int idx, int inc, Operator operator) {
            super(idx);
            this.inc = inc;
            this.op = operator;
        }

        void op(Operator op) {
            this.op = op;
        }

        void add(int delta) {
            this.inc += delta;
        }

        @Override
        public boolean satisfiable(ASupport v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void support(ASupport v) {
            throw new UnsupportedOperationException();
        }

        protected UnCol copy() {
            return new UnCol(this.anInt, this.inc, this.op);
        }
    }

    public static class UnAny
    extends Unary {
        UnAny() {
            super(0);
        }

        @Override
        public boolean satisfiable(ASupport v) {
            return true;
        }

        @Override
        public void support(ASupport v) {
            v.supportAll();
        }
    }

    public static abstract class Unary
    implements ISupportable {
        final int anInt;

        Unary(int anInt) {
            this.anInt = anInt;
        }

        @Override
        public final boolean satisfiable(ASupport[] vs, int i) {
            return this.satisfiable(vs[i]);
        }

        @Override
        public final void support(ASupport[] vs, int i) {
            this.support(vs[i]);
        }

        public abstract boolean satisfiable(ASupport var1);

        public abstract void support(ASupport var1);
    }
}

