/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.lns.neighbors;

import gnu.trove.list.array.TIntArrayList;
import java.util.Random;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.lns.neighbors.INeighbor;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class SetRandomNeighbor
implements INeighbor {
    protected final SetVar var;
    protected final TIntArrayList value;
    protected final Random rd = new Random(0L);

    public SetRandomNeighbor(SetVar variable) {
        this.var = variable;
        this.value = new TIntArrayList();
    }

    @Override
    public void recordSolution() {
        this.value.clear();
        ISetIterator iSetIterator = this.var.getLB().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.value.add(i);
        }
    }

    @Override
    public void fixSomeVariables() throws ContradictionException {
        for (int k = 0; k < this.value.size(); ++k) {
            if (!this.rd.nextBoolean()) continue;
            this.var.force(this.value.get(k), this);
        }
        ISetIterator iSetIterator = this.var.getLB().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (this.var.getLB().contains(i) || !this.rd.nextBoolean()) continue;
            this.var.remove(i, this);
        }
    }

    @Override
    public void loadFromSolution(Solution solution) {
        this.value.clear();
        for (int i : solution.getSetVal(this.var)) {
            this.value.add(i);
        }
    }
}

